/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.concurrent.ExecutionException;
import oadd.io.netty.channel.Channel;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.ChannelInboundHandlerAdapter;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.rpc.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.ResettableBarrier;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteConnection
implements ConnectionThrottle,
AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(RemoteConnection.class);
    private final Channel channel;
    private final WriteManager writeManager;
    private String name;
    private final String clientName;

    public boolean inEventLoop() {
        return this.channel.eventLoop().inEventLoop();
    }

    public RemoteConnection(SocketChannel channel, String name) {
        this.channel = channel;
        this.clientName = name;
        this.writeManager = new WriteManager();
        channel.pipeline().addLast(new BackPressureHandler());
        channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                RemoteConnection.this.writeManager.disable();
                RemoteConnection.this.writeManager.setWritable(true);
            }
        });
    }

    public String getName() {
        if (this.name == null) {
            this.name = String.format("%s <--> %s (%s)", this.channel.localAddress(), this.channel.remoteAddress(), this.clientName);
        }
        return this.name;
    }

    public abstract BufferAllocator getAllocator();

    public final Channel getChannel() {
        return this.channel;
    }

    public boolean blockOnNotWritable(RpcOutcomeListener<?> listener) {
        try {
            this.writeManager.waitForWritable();
            return true;
        }
        catch (InterruptedException e) {
            listener.interrupted(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.channel.config().setAutoRead(enableAutoRead);
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    @Override
    public void close() {
        try {
            if (this.channel.isActive()) {
                this.channel.close().get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Caught exception while closing channel.", e);
            Thread.currentThread().interrupt();
        }
    }

    private class BackPressureHandler
    extends ChannelInboundHandlerAdapter {
        private BackPressureHandler() {
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            RemoteConnection.this.writeManager.setWritable(ctx.channel().isWritable());
            ctx.fireChannelWritabilityChanged();
        }
    }

    private static class WriteManager {
        private final ResettableBarrier barrier = new ResettableBarrier();
        private volatile boolean disabled = false;

        public WriteManager() {
            this.barrier.openBarrier();
        }

        public void waitForWritable() throws InterruptedException {
            this.barrier.await();
        }

        public void setWritable(boolean isWritable) {
            if (isWritable) {
                this.barrier.openBarrier();
            } else if (!this.disabled) {
                this.barrier.closeBarrier();
            }
        }

        public void disable() {
            this.disabled = true;
        }
    }
}

