/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.IOException;
import java.net.BindException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Stopwatch;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.com.google.protobuf.Parser;
import oadd.io.netty.bootstrap.ServerBootstrap;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.ChannelInitializer;
import oadd.io.netty.channel.ChannelOption;
import oadd.io.netty.channel.ChannelPipeline;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.handler.timeout.ReadTimeoutHandler;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.AbstractHandshakeHandler;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.OutOfMemoryHandler;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.RpcBus;
import oadd.org.apache.drill.exec.rpc.RpcConfig;
import oadd.org.apache.drill.exec.rpc.RpcDecoder;
import oadd.org.apache.drill.exec.rpc.RpcEncoder;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcExceptionHandler;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicServer<T extends Internal.EnumLite, C extends RemoteConnection>
extends RpcBus<T, C> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String TIMEOUT_HANDLER = "timeout-handler";
    private ServerBootstrap b;
    private volatile boolean connect = false;
    private final EventLoopGroup eventLoopGroup;

    public BasicServer(final RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup) {
        super(rpcMapping);
        this.eventLoopGroup = eventLoopGroup;
        this.b = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(TransportCheck.getServerSocketChannel())).option(ChannelOption.SO_BACKLOG, 1000)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).group(eventLoopGroup).childOption(ChannelOption.ALLOCATOR, alloc).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                Object connection = BasicServer.this.initRemoteConnection(ch);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)BasicServer.this.getCloseHandler(ch, connection));
                ChannelPipeline pipe = ch.pipeline();
                pipe.addLast("protocol-decoder", (ChannelHandler)BasicServer.this.getDecoder(((RemoteConnection)connection).getAllocator(), BasicServer.this.getOutOfMemoryHandler()));
                pipe.addLast("message-decoder", (ChannelHandler)new RpcDecoder("s-" + BasicServer.this.rpcConfig.getName()));
                pipe.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("s-" + BasicServer.this.rpcConfig.getName()));
                pipe.addLast("handshake-handler", BasicServer.this.getHandshakeHandler(connection));
                if (rpcMapping.hasTimeout()) {
                    pipe.addLast(BasicServer.TIMEOUT_HANDLER, (ChannelHandler)new LogggingReadTimeoutHandler(BasicServer.this, connection, rpcMapping.getTimeout()));
                }
                pipe.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)BasicServer.this, connection));
                pipe.addLast("exception-handler", new RpcExceptionHandler(connection));
                BasicServer.this.connect = true;
            }
        });
    }

    public OutOfMemoryHandler getOutOfMemoryHandler() {
        return OutOfMemoryHandler.DEFAULT_INSTANCE;
    }

    protected void removeTimeoutHandler() {
    }

    public abstract ProtobufLengthDecoder getDecoder(BufferAllocator var1, OutOfMemoryHandler var2);

    @Override
    public boolean isClient() {
        return false;
    }

    protected abstract ServerHandshakeHandler<?> getHandshakeHandler(C var1);

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return null;
    }

    @Override
    protected Response handle(C connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        return null;
    }

    @Override
    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    public C initRemoteConnection(SocketChannel channel) {
        this.local = channel.localAddress();
        this.remote = channel.remoteAddress();
        return null;
    }

    public int bind(int initialPort, boolean allowPortHunting) {
        int port = initialPort - 1;
        while (true) {
            try {
                this.b.bind(++port).sync();
            }
            catch (Exception e) {
                if (e instanceof BindException && allowPortHunting) continue;
                UserException bindException = UserException.resourceError(e).addContext("Server type", this.getClass().getSimpleName()).message("Drillbit could not bind to port %s.", port).build(this.logger);
                throw bindException;
            }
            break;
        }
        this.connect = !this.connect;
        this.logger.debug("Server of type {} started on port {}.", (Object)this.getClass().getSimpleName(), (Object)port);
        return port;
    }

    @Override
    public void close() throws IOException {
        try {
            Stopwatch watch = new Stopwatch().start();
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).get();
            long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsed > 500L) {
                this.logger.info("closed eventLoopGroup " + this.eventLoopGroup + " in " + elapsed + " ms");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.warn("Failure while shutting down {}. ", (Object)this.getClass().getName(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    protected static abstract class ServerHandshakeHandler<T extends MessageLite>
    extends AbstractHandshakeHandler<T> {
        public ServerHandshakeHandler(Internal.EnumLite handshakeType, Parser<T> parser) {
            super(handshakeType, parser);
        }

        @Override
        protected void consumeHandshake(ChannelHandlerContext ctx, T inbound) throws Exception {
            OutboundRpcMessage msg = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, this.handshakeType, this.coordinationId, this.getHandshakeResponse(inbound), new ByteBuf[0]);
            ctx.writeAndFlush(msg);
        }

        public abstract MessageLite getHandshakeResponse(T var1) throws Exception;
    }

    private class LogggingReadTimeoutHandler<C extends RemoteConnection>
    extends ReadTimeoutHandler {
        private final C connection;
        private final int timeoutSeconds;
        final /* synthetic */ BasicServer this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public LogggingReadTimeoutHandler(C connection, int timeoutSeconds) {
            this.this$0 = (BasicServer)n;
            super(timeoutSeconds);
            this.connection = connection;
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
            this.this$0.logger.info("RPC connection {} timed out.  Timeout was set to {} seconds. Closing connection.", (Object)((RemoteConnection)this.connection).getName(), (Object)this.timeoutSeconds);
            super.readTimedOut(ctx);
        }
    }
}

