/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resolver;

import java.util.LinkedList;
import java.util.List;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.exec.expr.fn.DrillFuncHolder;
import oadd.org.apache.drill.exec.resolver.FunctionResolver;
import oadd.org.apache.drill.exec.resolver.TypeCastRules;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFunctionResolver
implements FunctionResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFunctionResolver.class);

    @Override
    public DrillFuncHolder getBestMatch(List<DrillFuncHolder> methods, FunctionCall call) {
        int bestcost = Integer.MAX_VALUE;
        int currcost = Integer.MAX_VALUE;
        DrillFuncHolder bestmatch = null;
        LinkedList<DrillFuncHolder> bestMatchAlternatives = new LinkedList<DrillFuncHolder>();
        for (DrillFuncHolder h : methods) {
            currcost = TypeCastRules.getCost(call, h);
            if (currcost < 0) continue;
            if (currcost < bestcost) {
                bestcost = currcost;
                bestmatch = h;
                bestMatchAlternatives.clear();
                continue;
            }
            if (currcost != bestcost) continue;
            bestMatchAlternatives.add(h);
        }
        if (bestcost < 0) {
            return null;
        }
        if (AssertionUtil.isAssertionsEnabled() && bestMatchAlternatives.size() > 0) {
            logger.error("Chosen function impl: " + bestmatch.toString());
            logger.error("Printing all the possible functions that could have matched: ");
            for (DrillFuncHolder holder : bestMatchAlternatives) {
                logger.error(holder.toString());
            }
            throw new AssertionError((Object)"Multiple functions with best cost found");
        }
        return bestmatch;
    }
}

