/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class MaterializedField {
    private final Key key;
    private final LinkedHashSet<MaterializedField> children;

    private MaterializedField(SchemaPath path, TypeProtos.MajorType type) {
        this(path, type, new LinkedHashSet<MaterializedField>());
    }

    private MaterializedField(SchemaPath path, TypeProtos.MajorType type, LinkedHashSet<MaterializedField> children) {
        this.key = new Key(path, type);
        this.children = children;
    }

    public static MaterializedField create(UserBitShared.SerializedField serField) {
        MaterializedField field = new MaterializedField(SchemaPath.create(serField.getNamePart()), serField.getMajorType());
        for (UserBitShared.SerializedField sf : serField.getChildList()) {
            field.addChild(MaterializedField.create(sf));
        }
        return field;
    }

    public UserBitShared.SerializedField getSerializedField() {
        UserBitShared.SerializedField.Builder serializedFieldBuilder = this.getAsBuilder();
        for (MaterializedField childMaterializedField : this.getChildren()) {
            serializedFieldBuilder.addChild(childMaterializedField.getSerializedField());
        }
        return serializedFieldBuilder.build();
    }

    public UserBitShared.SerializedField.Builder getAsBuilder() {
        return UserBitShared.SerializedField.newBuilder().setMajorType(this.key.type).setNamePart(this.key.path.getAsNamePart());
    }

    public Collection<MaterializedField> getChildren() {
        return this.children;
    }

    public void addChild(MaterializedField field) {
        this.children.add(field);
    }

    public MaterializedField clone() {
        return this.withPathAndType(this.getPath(), this.getType());
    }

    public MaterializedField withType(TypeProtos.MajorType type) {
        return this.withPathAndType(this.getPath(), type);
    }

    public MaterializedField withPath(SchemaPath path) {
        return this.withPathAndType(path, this.getType());
    }

    public MaterializedField withPathAndType(SchemaPath path, TypeProtos.MajorType type) {
        LinkedHashSet<MaterializedField> newChildren = new LinkedHashSet<MaterializedField>(this.children.size());
        MaterializedField clone = new MaterializedField(path, type, newChildren);
        for (MaterializedField child : this.children) {
            newChildren.add(child.clone());
        }
        return clone;
    }

    public String getLastName() {
        PathSegment seg = this.key.path.getRootSegment();
        while (seg.getChild() != null) {
            seg = seg.getChild();
        }
        return ((PathSegment)seg).getNameSegment().getPath();
    }

    public boolean matches(UserBitShared.SerializedField field) {
        MaterializedField f = MaterializedField.create(field);
        return f.equals(this);
    }

    public static MaterializedField create(String path, TypeProtos.MajorType type) {
        SchemaPath p = SchemaPath.getSimplePath(path);
        return MaterializedField.create(p, type);
    }

    public static MaterializedField create(SchemaPath path, TypeProtos.MajorType type) {
        return new MaterializedField(path, type);
    }

    public SchemaPath getPath() {
        return this.key.path;
    }

    @Deprecated
    public SchemaPath getAsSchemaPath() {
        return this.getPath();
    }

    public int getWidth() {
        return this.key.type.getWidth();
    }

    public TypeProtos.MajorType getType() {
        return this.key.type;
    }

    public int getScale() {
        return this.key.type.getScale();
    }

    public int getPrecision() {
        return this.key.type.getPrecision();
    }

    public boolean isNullable() {
        return this.key.type.getMode() == TypeProtos.DataMode.OPTIONAL;
    }

    public TypeProtos.DataMode getDataMode() {
        return this.key.type.getMode();
    }

    public MaterializedField getOtherNullableVersion() {
        TypeProtos.MajorType mt = this.key.type;
        TypeProtos.DataMode newDataMode = null;
        switch (mt.getMode()) {
            case OPTIONAL: {
                newDataMode = TypeProtos.DataMode.REQUIRED;
                break;
            }
            case REQUIRED: {
                newDataMode = TypeProtos.DataMode.OPTIONAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new MaterializedField(this.key.path, mt.toBuilder().setMode(newDataMode).build());
    }

    public Class<?> getValueClass() {
        return BasicTypeHelper.getValueVectorClass(this.getType().getMinorType(), this.getDataMode());
    }

    public boolean matches(SchemaPath path) {
        if (!path.isSimplePath()) {
            return false;
        }
        return this.key.path.equals(path);
    }

    public int hashCode() {
        int result = 1;
        result = this.key == null ? 0 : this.key.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedField other = (MaterializedField)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        int maxLen = 10;
        String childStr = this.children != null && !this.children.isEmpty() ? this.toString(this.children, 10) : "";
        return this.key.path + "(" + this.key.type.getMinorType().name() + ":" + this.key.type.getMode().name() + ")" + childStr;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public Key key() {
        return this.key;
    }

    public String toExpr() {
        return this.key.path.toExpr();
    }

    public class Key {
        private final SchemaPath path;
        private final TypeProtos.MajorType type;

        private Key(SchemaPath path, TypeProtos.MajorType type) {
            this.path = path;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }
}

