/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metrics;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oadd.com.codahale.metrics.JmxReporter;
import oadd.com.codahale.metrics.Metric;
import oadd.com.codahale.metrics.MetricFilter;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.com.codahale.metrics.MetricSet;
import oadd.com.codahale.metrics.Slf4jReporter;
import oadd.com.codahale.metrics.jvm.BufferPoolMetricSet;
import oadd.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import oadd.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import oadd.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import oadd.org.apache.drill.common.config.DrillConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillMetrics {
    static final Logger logger = LoggerFactory.getLogger(DrillMetrics.class);
    public static final String METRICS_JMX_OUTPUT_ENABLED = "drill.metrics.jmx.enabled";
    public static final String METRICS_LOG_OUTPUT_ENABLED = "drill.metrics.log.enabled";
    public static final String METRICS_LOG_OUTPUT_INTERVAL = "drill.metrics.log.interval";
    static final DrillConfig config = DrillConfig.create();

    private DrillMetrics() {
    }

    public static synchronized <T extends Metric> void register(String name, T metric) {
        boolean removed = RegistryHolder.REGISTRY.remove(name);
        if (removed) {
            logger.warn("Removing old metric since name matched newly registered metric. Metric name: {}", (Object)name);
        }
        RegistryHolder.REGISTRY.register(name, metric);
    }

    private static void registerAll(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                DrillMetrics.registerAll(prefix + "." + entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + entry.getKey(), entry.getValue());
        }
    }

    public static MetricRegistry getInstance() {
        return RegistryHolder.REGISTRY;
    }

    public static void resetMetrics() {
        RegistryHolder.REGISTRY.removeMatching(new MetricFilter(){

            @Override
            public boolean matches(String name, Metric metric) {
                return true;
            }
        });
        RegistryHolder.registerSysStats();
    }

    private static class RegistryHolder {
        public static final MetricRegistry REGISTRY = new MetricRegistry();
        private static final Slf4jReporter LOG_REPORTER;

        private RegistryHolder() {
        }

        private static void registerSysStats() {
            REGISTRY.registerAll(new GarbageCollectorMetricSet());
            REGISTRY.registerAll(new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            REGISTRY.registerAll(new MemoryUsageGaugeSet());
            REGISTRY.registerAll(new ThreadStatesGaugeSet());
        }

        private static JmxReporter getJmxReporter() {
            if (config.getBoolean(DrillMetrics.METRICS_JMX_OUTPUT_ENABLED)) {
                JmxReporter reporter = JmxReporter.forRegistry(DrillMetrics.getInstance()).build();
                reporter.start();
                return reporter;
            }
            return null;
        }

        private static Slf4jReporter getLogReporter() {
            if (config.getBoolean(DrillMetrics.METRICS_LOG_OUTPUT_ENABLED)) {
                Slf4jReporter reporter = Slf4jReporter.forRegistry(DrillMetrics.getInstance()).outputTo(logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start(config.getInt(DrillMetrics.METRICS_LOG_OUTPUT_INTERVAL), TimeUnit.SECONDS);
                return reporter;
            }
            return null;
        }

        static {
            RegistryHolder.registerSysStats();
            LOG_REPORTER = RegistryHolder.getLogReporter();
        }
    }
}

