/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.IOException;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.compile.TemplateClassDefinition;
import oadd.org.apache.drill.exec.compile.sig.MappingSet;
import oadd.org.apache.drill.exec.expr.ClassGenerator;
import oadd.org.apache.drill.exec.expr.EvaluationVisitor;
import oadd.org.apache.drill.exec.expr.SingleClassStringWriter;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;

public class CodeGenerator<T> {
    private static final String PACKAGE_NAME = "oadd.org.apache.drill.exec.test.generated";
    private final TemplateClassDefinition<T> definition;
    private final String className;
    private final String fqcn;
    private final JCodeModel model;
    private final ClassGenerator<T> rootGenerator;
    private String generatedCode;
    private String generifiedCode;

    CodeGenerator(TemplateClassDefinition<T> definition, FunctionImplementationRegistry funcRegistry) {
        this(ClassGenerator.getDefaultMapping(), definition, funcRegistry);
    }

    CodeGenerator(MappingSet mappingSet, TemplateClassDefinition<T> definition, FunctionImplementationRegistry funcRegistry) {
        Preconditions.checkNotNull(definition.getSignature(), "The signature for defintion %s was incorrectly initialized.", definition);
        this.definition = definition;
        this.className = definition.getExternalInterface().getSimpleName() + "Gen" + definition.getNextClassNumber();
        this.fqcn = "oadd.org.apache.drill.exec.test.generated." + this.className;
        try {
            this.model = new JCodeModel();
            JDefinedClass clazz = this.model._package(PACKAGE_NAME)._class(this.className);
            this.rootGenerator = new ClassGenerator(this, mappingSet, definition.getSignature(), new EvaluationVisitor(funcRegistry), clazz, this.model);
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
    }

    public ClassGenerator<T> getRoot() {
        return this.rootGenerator;
    }

    public void generate() throws IOException {
        this.rootGenerator.flushCode();
        SingleClassStringWriter w = new SingleClassStringWriter();
        this.model.build((CodeWriter)w);
        this.generatedCode = w.getCode().toString();
        this.generifiedCode = this.generatedCode.replaceAll(this.className, "GenericGenerated");
    }

    public String generateAndGet() throws IOException {
        this.generate();
        return this.generatedCode;
    }

    public String getGeneratedCode() {
        return this.generatedCode;
    }

    public TemplateClassDefinition<T> getDefinition() {
        return this.definition;
    }

    public String getMaterializedClassName() {
        return this.fqcn;
    }

    public static <T> CodeGenerator<T> get(TemplateClassDefinition<T> definition, FunctionImplementationRegistry funcRegistry) {
        return new CodeGenerator<T>(definition, funcRegistry);
    }

    public static <T> ClassGenerator<T> getRoot(TemplateClassDefinition<T> definition, FunctionImplementationRegistry funcRegistry) {
        return CodeGenerator.get(definition, funcRegistry).getRoot();
    }

    public static <T> ClassGenerator<T> getRoot(MappingSet mappingSet, TemplateClassDefinition<T> definition, FunctionImplementationRegistry funcRegistry) {
        return CodeGenerator.get(mappingSet, definition, funcRegistry).getRoot();
    }

    public static <T> CodeGenerator<T> get(MappingSet mappingSet, TemplateClassDefinition<T> definition, FunctionImplementationRegistry funcRegistry) {
        return new CodeGenerator<T>(mappingSet, definition, funcRegistry);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.generifiedCode == null ? 0 : this.generifiedCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeGenerator other = (CodeGenerator)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.generifiedCode == null ? other.generifiedCode != null : !this.generifiedCode.equals(other.generifiedCode));
    }
}

