/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.com.codahale.metrics.Timer;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.cache.AbstractStreamSerializable;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.WritableBatch;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class VectorAccessibleSerializable
extends AbstractStreamSerializable {
    static final MetricRegistry metrics = DrillMetrics.getInstance();
    static final String WRITER_TIMER = MetricRegistry.name(VectorAccessibleSerializable.class, "writerTime");
    private VectorContainer va;
    private WritableBatch batch;
    private final BufferAllocator allocator;
    private int recordCount = -1;
    private BatchSchema.SelectionVectorMode svMode = BatchSchema.SelectionVectorMode.NONE;
    private SelectionVector2 sv2;
    private boolean retain = false;

    public VectorAccessibleSerializable(BufferAllocator allocator) {
        this.allocator = allocator;
        this.va = new VectorContainer();
    }

    public VectorAccessibleSerializable(WritableBatch batch, BufferAllocator allocator) {
        this(batch, null, allocator);
    }

    public VectorAccessibleSerializable(WritableBatch batch, SelectionVector2 sv2, BufferAllocator allocator) {
        this.allocator = allocator;
        this.batch = batch;
        if (sv2 != null) {
            this.sv2 = sv2;
            this.svMode = BatchSchema.SelectionVectorMode.TWO_BYTE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromStream(InputStream input) throws IOException {
        VectorContainer container = new VectorContainer();
        UserBitShared.RecordBatchDef batchDef = UserBitShared.RecordBatchDef.parseDelimitedFrom(input);
        this.recordCount = batchDef.getRecordCount();
        if (batchDef.hasCarriesTwoByteSelectionVector() && batchDef.getCarriesTwoByteSelectionVector()) {
            if (this.sv2 == null) {
                this.sv2 = new SelectionVector2(this.allocator);
            }
            this.sv2.allocateNew(this.recordCount * 2);
            this.sv2.getBuffer().setBytes(0, input, this.recordCount * 2);
            this.svMode = BatchSchema.SelectionVectorMode.TWO_BYTE;
        }
        ArrayList<ValueVector> vectorList = Lists.newArrayList();
        List<UserBitShared.SerializedField> fieldList = batchDef.getFieldList();
        for (UserBitShared.SerializedField metaData : fieldList) {
            ValueVector vector;
            int dataLength = metaData.getBufferLength();
            MaterializedField field = MaterializedField.create(metaData);
            DrillBuf buf = this.allocator.buffer(dataLength);
            try {
                buf.writeBytes(input, dataLength);
                vector = TypeHelper.getNewVector(field, this.allocator);
                vector.load(metaData, buf);
            }
            finally {
                buf.release();
            }
            vectorList.add(vector);
        }
        container.addCollection(vectorList);
        container.buildSchema(this.svMode);
        container.setRecordCount(this.recordCount);
        this.va = container;
    }

    public void writeToStreamAndRetain(OutputStream output) throws IOException {
        this.retain = true;
        this.writeToStream(output);
    }

    @Override
    public void writeToStream(OutputStream output) throws IOException {
        Preconditions.checkNotNull(output);
        Timer.Context timerContext = metrics.timer(WRITER_TIMER).time();
        DrillBuf[] incomingBuffers = this.batch.getBuffers();
        UserBitShared.RecordBatchDef batchDef = this.batch.getDef();
        DrillBuf svBuf = null;
        Integer svCount = null;
        if (this.svMode == BatchSchema.SelectionVectorMode.TWO_BYTE) {
            svCount = this.sv2.getCount();
            svBuf = this.sv2.getBuffer();
        }
        try {
            batchDef.writeDelimitedTo(output);
            if (svBuf != null) {
                svBuf.getBytes(0, output, svBuf.readableBytes());
                this.sv2.setBuffer(svBuf);
                svBuf.release();
                this.sv2.setRecordCount(svCount);
            }
            for (DrillBuf buf : incomingBuffers) {
                int bufLength = buf.readableBytes();
                buf.getBytes(0, output, bufLength);
            }
            output.flush();
            timerContext.stop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        if (!this.retain) {
            this.batch.clear();
            if (this.sv2 != null) {
                this.sv2.clear();
            }
        }
    }

    public VectorContainer get() {
        return this.va;
    }

    public SelectionVector2 getSv2() {
        return this.sv2;
    }
}

