/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonGenerationException;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;

@JsonSerialize(using=Se.class)
@JsonDeserialize(using=De.class)
public class FieldReference
extends SchemaPath {
    TypeProtos.MajorType overrideType;

    public FieldReference(SchemaPath sp) {
        super(sp);
        this.checkData();
    }

    private void checkData() {
        if (this.getRootSegment().getChild() != null) {
            throw new UnsupportedOperationException("Field references must be singular names.");
        }
    }

    private void checkSimpleString(CharSequence value) {
        if (value.toString().contains(".")) {
            throw new UnsupportedOperationException(String.format("Unhandled field reference \"%s\"; a field reference identifier must not have the form of a qualified name (i.e., with \".\").", value));
        }
    }

    public FieldReference(CharSequence value) {
        this(value, ExpressionPosition.UNKNOWN);
        this.checkSimpleString(value);
    }

    public static FieldReference getWithQuotedRef(CharSequence safeString) {
        return new FieldReference(safeString, ExpressionPosition.UNKNOWN, false);
    }

    public FieldReference(CharSequence value, ExpressionPosition pos) {
        this(value, pos, true);
    }

    public FieldReference(CharSequence value, ExpressionPosition pos, boolean check) {
        super(new PathSegment.NameSegment(value), pos);
        if (check) {
            this.checkData();
            this.checkSimpleString(value);
        }
    }

    public FieldReference(String value, ExpressionPosition pos, TypeProtos.MajorType dataType) {
        this((CharSequence)value, pos);
        this.overrideType = dataType;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        if (this.overrideType == null) {
            return super.getMajorType();
        }
        return this.overrideType;
    }

    public static class Se
    extends StdSerializer<FieldReference> {
        public Se() {
            super(FieldReference.class);
        }

        @Override
        public void serialize(FieldReference value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString('`' + value.getRootSegment().getNameSegment().getPath() + '`');
        }
    }

    public static class De
    extends StdDeserializer<FieldReference> {
        public De() {
            super(FieldReference.class);
        }

        @Override
        public FieldReference deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String ref = this._parseString(jp, ctxt);
            ref = ref.replace("`", "");
            return new FieldReference((CharSequence)ref, ExpressionPosition.UNKNOWN, false);
        }
    }
}

