/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.config;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Stopwatch;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.typesafe.config.Config;
import oadd.com.typesafe.config.ConfigFactory;
import oadd.com.typesafe.config.ConfigRenderOptions;
import oadd.org.apache.drill.common.config.NestedConfig;
import oadd.org.apache.drill.common.exceptions.DrillConfigurationException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.scanner.ClassPathScanner;
import oadd.org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.VM;

public class DrillConfig
extends NestedConfig {
    private static final Logger logger = LoggerFactory.getLogger(DrillConfig.class);
    private final ImmutableList<String> startupArguments;
    public static final boolean ON_OSX = System.getProperty("os.name").contains("OS X");
    private static final long MAX_DIRECT_MEMORY = VM.maxDirectMemory();

    @VisibleForTesting
    public DrillConfig(Config config, boolean enableServerConfigs) {
        super(config);
        logger.debug("Setting up DrillConfig object.");
        logger.trace("Given Config object is:\n{}", (Object)config.root().render(ConfigRenderOptions.defaults()));
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        this.startupArguments = ImmutableList.copyOf(bean.getInputArguments());
        logger.debug("DrillConfig object initialized.");
    }

    public <T> T getInstance(String path, Class<T> iface, Object ... constructorArgs) {
        try {
            String className = this.getString(path);
            Class<?> clazz = Class.forName(className);
            Preconditions.checkArgument(iface.isAssignableFrom(clazz));
            Class[] argClasses = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                argClasses[i] = constructorArgs[i].getClass();
            }
            Constructor<?> constructor = clazz.getConstructor(argClasses);
            return (T)constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to load instance of the class of type %s requested at path %s.", iface.getName(), path).build(logger);
        }
    }

    public List<String> getStartupArguments() {
        return this.startupArguments;
    }

    public static DrillConfig create() {
        return DrillConfig.create(null, true);
    }

    public static DrillConfig forClient() {
        return DrillConfig.create(null, false);
    }

    public static DrillConfig create(String overrideFileResourcePathname) {
        return DrillConfig.create(overrideFileResourcePathname, true);
    }

    @VisibleForTesting
    public static DrillConfig create(Properties testConfigurations) {
        return DrillConfig.create(null, testConfigurations, true);
    }

    public static DrillConfig create(String overrideFileResourcePathname, boolean enableServerConfigs) {
        return DrillConfig.create(overrideFileResourcePathname, null, enableServerConfigs);
    }

    private static DrillConfig create(String overrideFileResourcePathname, Properties overriderProps, boolean enableServerConfigs) {
        ClassLoader[] classLoaders;
        StringBuilder logString = new StringBuilder();
        Stopwatch watch = new Stopwatch().start();
        overrideFileResourcePathname = overrideFileResourcePathname == null ? "drill-override.conf" : overrideFileResourcePathname;
        Config fallback = null;
        for (ClassLoader classLoader : classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0])) {
            URL url = classLoader.getResource("drill-default.conf");
            if (null == url) continue;
            logString.append("Base Configuration:\n\t- ").append(url).append("\n");
            fallback = ConfigFactory.load(classLoader, "drill-default.conf");
            break;
        }
        Collection<URL> urls = ClassPathScanner.getConfigURLs();
        logString.append("\nIntermediate Configuration and Plugin files, in order of precedence:\n");
        for (URL url : urls) {
            logString.append("\t- ").append(url).append("\n");
            fallback = ConfigFactory.parseURL(url).withFallback(fallback);
        }
        logString.append("\n");
        URL overrideFileUrl = Thread.currentThread().getContextClassLoader().getResource(overrideFileResourcePathname);
        if (null != overrideFileUrl) {
            logString.append("Override File: ").append(overrideFileUrl).append("\n");
        }
        Config effectiveConfig = ConfigFactory.load(overrideFileResourcePathname).withFallback(fallback);
        if (overriderProps != null) {
            logString.append("Overridden Properties:\n");
            for (Map.Entry<Object, Object> entry : overriderProps.entrySet()) {
                logString.append("\t-").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
            logString.append("\n");
            effectiveConfig = ConfigFactory.parseProperties(overriderProps).withFallback(effectiveConfig);
        }
        logger.info("Configuration and plugin file(s) identified in {}ms.\n{}", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)logString);
        return new DrillConfig(effectiveConfig.resolve(), enableServerConfigs);
    }

    public <T> Class<T> getClassAt(String location, Class<T> clazz) throws DrillConfigurationException {
        String className = this.getString(location);
        if (className == null) {
            throw new DrillConfigurationException(String.format("No class defined at location '%s'. Expected a definition of the class []", location, clazz.getCanonicalName()));
        }
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                Class<?> t = c;
                return t;
            }
            throw new DrillConfigurationException(String.format("The class [%s] listed at location '%s' should be of type [%s].  It isn't.", className, location, clazz.getCanonicalName()));
        }
        catch (Exception ex) {
            if (ex instanceof DrillConfigurationException) {
                throw (DrillConfigurationException)ex;
            }
            throw new DrillConfigurationException(String.format("Failure while initializing class [%s] described at configuration value '%s'.", className, location), ex);
        }
    }

    public <T> T getInstanceOf(String location, Class<T> clazz) throws DrillConfigurationException {
        Class<T> c = this.getClassAt(location, clazz);
        try {
            T t = c.newInstance();
            return t;
        }
        catch (Exception ex) {
            throw new DrillConfigurationException(String.format("Failure while instantiating class [%s] located at '%s.", clazz.getCanonicalName(), location), ex);
        }
    }

    public String toString() {
        return this.root().render();
    }

    public static long getMaxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }
}

