/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.util.Collection;
import oadd.org.apache.commons.dbcp.AbandonedConfig;
import oadd.org.apache.commons.dbcp.PoolableConnectionFactory;
import oadd.org.apache.commons.dbcp.PoolingConnection;
import oadd.org.apache.commons.dbcp.managed.PoolableManagedConnection;
import oadd.org.apache.commons.dbcp.managed.TransactionRegistry;
import oadd.org.apache.commons.dbcp.managed.XAConnectionFactory;
import oadd.org.apache.commons.pool.KeyedObjectPool;
import oadd.org.apache.commons.pool.KeyedObjectPoolFactory;
import oadd.org.apache.commons.pool.ObjectPool;

public class PoolableManagedConnectionFactory
extends PoolableConnectionFactory {
    private final TransactionRegistry transactionRegistry;

    public PoolableManagedConnectionFactory(XAConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit);
        this.transactionRegistry = connFactory.getTransactionRegistry();
    }

    public PoolableManagedConnectionFactory(XAConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, int validationQueryTimeout, Collection connectionInitSqls, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, validationQueryTimeout, connectionInitSqls, defaultReadOnly, defaultAutoCommit, defaultTransactionIsolation, defaultCatalog, config);
        this.transactionRegistry = connFactory.getTransactionRegistry();
    }

    @Override
    public synchronized Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(conn);
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((PoolingConnection)conn);
        }
        return new PoolableManagedConnection(this.transactionRegistry, conn, this._pool, this._config);
    }
}

