/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oadd.org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import oadd.org.apache.commons.dbcp.datasources.PooledConnectionManager;
import oadd.org.apache.commons.dbcp.datasources.UserPassKey;
import oadd.org.apache.commons.pool.KeyedObjectPool;
import oadd.org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final KeyedObjectPool _pool;
    private final Map validatingMap = new HashMap();
    private final WeakHashMap pcMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery) {
        this(cpds, pool, validationQuery, false);
    }

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery, boolean rollbackAfterValidation) {
        this._cpds = cpds;
        this._pool = pool;
        pool.setFactory(this);
        this._validationQuery = validationQuery;
        this._rollbackAfterValidation = rollbackAfterValidation;
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    @Override
    public synchronized Object makeObject(Object key) throws Exception {
        PooledConnectionAndInfo obj = null;
        UserPassKey upkey = (UserPassKey)key;
        PooledConnection pc = null;
        String username = upkey.getUsername();
        String password = upkey.getPassword();
        pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, password);
        if (pc == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pc.addConnectionEventListener(this);
        obj = new PooledConnectionAndInfo(pc, username, password);
        this.pcMap.put(pc, obj);
        return obj;
    }

    @Override
    public void destroyObject(Object key, Object obj) throws Exception {
        if (obj instanceof PooledConnectionAndInfo) {
            PooledConnection pc = ((PooledConnectionAndInfo)obj).getPooledConnection();
            pc.removeConnectionEventListener(this);
            this.pcMap.remove(pc);
            pc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateObject(Object key, Object obj) {
        boolean valid = false;
        if (!(obj instanceof PooledConnectionAndInfo)) return false;
        PooledConnection pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
        String query = this._validationQuery;
        if (null == query) return true;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        this.validatingMap.put(pconn, null);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            valid = rset.next();
            if (!this._rollbackAfterValidation) return valid;
            conn.rollback();
            return valid;
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t) {}
            }
            this.validatingMap.remove(pconn);
        }
    }

    @Override
    public void passivateObject(Object key, Object obj) {
    }

    @Override
    public void activateObject(Object key, Object obj) {
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingMap.containsKey(pc)) {
            PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(info.getUserPassKey(), info);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this._pool.invalidateObject(info.getUserPassKey(), info);
                }
                catch (Exception e3) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e3.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(info.getUserPassKey(), info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey key = info.getUserPassKey();
        try {
            this._pool.invalidateObject(key, info);
            this._pool.clear(key);
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(ex);
        }
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public void closePool(String username) throws SQLException {
        try {
            this._pool.clear(new UserPassKey(username, null));
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(ex);
        }
    }
}

