/*
 * Decompiled with CFR 0.152.
 */
package oadd.net.hydromatic.avatica;

import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteString
implements Comparable<ByteString>,
Serializable {
    private final byte[] bytes;
    public static final ByteString EMPTY = new ByteString(new byte[0], false);
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ByteString(byte[] bytes) {
        this((byte[])bytes.clone(), false);
    }

    private ByteString(byte[] bytes, boolean dummy) {
        this.bytes = bytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ByteString && Arrays.equals(this.bytes, ((ByteString)obj).bytes);
    }

    @Override
    public int compareTo(ByteString that) {
        byte[] v1 = this.bytes;
        byte[] v2 = that.bytes;
        int n = Math.min(v1.length, v2.length);
        for (int i = 0; i < n; ++i) {
            byte c1 = v1[i];
            byte c2 = v2[i];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return v1.length - v2.length;
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int base) {
        return ByteString.toString(this.bytes, base);
    }

    public static String toString(byte[] bytes, int base) {
        char[] chars;
        int j = 0;
        switch (base) {
            case 2: {
                chars = new char[bytes.length * 8];
                for (byte b : bytes) {
                    chars[j++] = DIGITS[(b & 0x80) >> 7];
                    chars[j++] = DIGITS[(b & 0x40) >> 6];
                    chars[j++] = DIGITS[(b & 0x20) >> 5];
                    chars[j++] = DIGITS[(b & 0x10) >> 4];
                    chars[j++] = DIGITS[(b & 8) >> 3];
                    chars[j++] = DIGITS[(b & 4) >> 2];
                    chars[j++] = DIGITS[(b & 2) >> 1];
                    chars[j++] = DIGITS[b & 1];
                }
                break;
            }
            case 16: {
                chars = new char[bytes.length * 2];
                for (byte b : bytes) {
                    chars[j++] = DIGITS[(b & 0xF0) >> 4];
                    chars[j++] = DIGITS[b & 0xF];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad base " + base);
            }
        }
        return new String(chars, 0, j);
    }

    public Object clone() {
        return this;
    }

    public int length() {
        return this.bytes.length;
    }

    public byte byteAt(int i) {
        return this.bytes[i];
    }

    public ByteString substring(int start, int end) {
        byte[] bytes = Arrays.copyOfRange(this.bytes, start, end);
        return new ByteString(bytes, false);
    }

    public ByteString substring(int start) {
        return this.substring(start, this.length());
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public ByteString concat(ByteString other) {
        int otherLen = other.length();
        if (otherLen == 0) {
            return this;
        }
        int len = this.bytes.length;
        byte[] buf = Arrays.copyOf(this.bytes, len + otherLen);
        System.arraycopy(other.bytes, 0, buf, len, other.bytes.length);
        return new ByteString(buf, false);
    }

    public int indexOf(ByteString seek) {
        block0: for (int i = 0; i < this.bytes.length - seek.bytes.length + 1; ++i) {
            int j = 0;
            while (j != seek.bytes.length) {
                if (this.bytes[i + j] != seek.bytes[j]) continue block0;
                ++j;
            }
            return i;
        }
        return -1;
    }
}

