/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.ser;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;
import oadd.com.fasterxml.jackson.databind.BeanDescription;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializationConfig;
import oadd.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import oadd.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import oadd.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import oadd.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import oadd.com.fasterxml.jackson.databind.util.ClassUtil;
import oadd.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import oadd.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import oadd.com.fasterxml.jackson.module.afterburner.ser.PropertyAccessorCollector;
import oadd.com.fasterxml.jackson.module.afterburner.util.MyClassLoader;

public class SerializerModifier
extends BeanSerializerModifier {
    protected final MyClassLoader _classLoader;

    public SerializerModifier(ClassLoader cl) {
        this._classLoader = cl == null ? null : new MyClassLoader(cl, false);
    }

    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        Class<?> beanClass = beanDesc.getBeanClass();
        if (!MyClassLoader.canAddClassInPackageOf(beanClass)) {
            return beanProperties;
        }
        if (this._classLoader != null && Modifier.isPrivate(beanClass.getModifiers())) {
            return beanProperties;
        }
        PropertyAccessorCollector collector = this.findProperties(beanClass, config, beanProperties);
        if (collector.isEmpty()) {
            return beanProperties;
        }
        BeanPropertyAccessor acc = collector.findAccessor(this._classLoader);
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            BeanPropertyWriter bpw = it.next();
            if (!(bpw instanceof OptimizedBeanPropertyWriter)) continue;
            it.set((BeanPropertyWriter)((OptimizedBeanPropertyWriter)bpw).withAccessor(acc));
        }
        return beanProperties;
    }

    protected PropertyAccessorCollector findProperties(Class<?> beanClass, SerializationConfig config, List<BeanPropertyWriter> beanProperties) {
        PropertyAccessorCollector collector = new PropertyAccessorCollector(beanClass);
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            BeanPropertyWriter bpw = it.next();
            Class<?> type = bpw.getPropertyType();
            AnnotatedMember member = bpw.getMember();
            if (Modifier.isPrivate(member.getMember().getModifiers()) || bpw.hasSerializer() && !this.isDefaultSerializer(config, bpw.getSerializer()) || bpw.isUnwrapping()) continue;
            boolean isMethod = member instanceof AnnotatedMethod;
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    if (isMethod) {
                        it.set(collector.addIntGetter(bpw));
                        continue;
                    }
                    it.set(collector.addIntField(bpw));
                    continue;
                }
                if (type != Long.TYPE) continue;
                if (isMethod) {
                    it.set(collector.addLongGetter(bpw));
                    continue;
                }
                it.set(collector.addLongField(bpw));
                continue;
            }
            if (type == String.class) {
                if (isMethod) {
                    it.set(collector.addStringGetter(bpw));
                    continue;
                }
                it.set(collector.addStringField(bpw));
                continue;
            }
            if (isMethod) {
                it.set(collector.addObjectGetter(bpw));
                continue;
            }
            it.set(collector.addObjectField(bpw));
        }
        return collector;
    }

    protected boolean isDefaultSerializer(SerializationConfig config, JsonSerializer<?> ser) {
        return ClassUtil.isJacksonStdImpl(ser);
    }
}

