/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.deser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oadd.com.fasterxml.jackson.databind.deser.SettableBeanProperty;

public abstract class BeanPropertyMutator {
    private boolean broken = false;

    public void intSetter(SettableBeanProperty originalMutator, Object bean, int propertyIndex, int value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.intSetter(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void longSetter(SettableBeanProperty originalMutator, Object bean, int propertyIndex, long value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.longSetter(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void stringSetter(SettableBeanProperty originalMutator, Object bean, int propertyIndex, String value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.stringSetter(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void objectSetter(SettableBeanProperty originalMutator, Object bean, int propertyIndex, Object value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.objectSetter(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void intField(SettableBeanProperty originalMutator, Object bean, int propertyIndex, int value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.intField(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void longField(SettableBeanProperty originalMutator, Object bean, int propertyIndex, long value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.longField(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void stringField(SettableBeanProperty originalMutator, Object bean, int propertyIndex, String value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.stringField(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    public void objectField(SettableBeanProperty originalMutator, Object bean, int propertyIndex, Object value) throws IOException {
        if (this.broken) {
            originalMutator.set(bean, value);
            return;
        }
        try {
            this.objectField(bean, propertyIndex, value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, propertyIndex, e);
            originalMutator.set(bean, value);
        }
    }

    protected void intSetter(Object bean, int propertyIndex, int value) {
        throw new UnsupportedOperationException("No intSetters defined");
    }

    protected void longSetter(Object bean, int propertyIndex, long value) {
        throw new UnsupportedOperationException("No longSetters defined");
    }

    protected void stringSetter(Object bean, int propertyIndex, String value) {
        throw new UnsupportedOperationException("No stringSetters defined");
    }

    protected void objectSetter(Object bean, int propertyIndex, Object value) {
        throw new UnsupportedOperationException("No objectSetters defined");
    }

    protected void intField(Object bean, int propertyIndex, int value) {
        throw new UnsupportedOperationException("No intFields defined");
    }

    protected void longField(Object bean, int propertyIndex, long value) {
        throw new UnsupportedOperationException("No longFields defined");
    }

    protected void stringField(Object bean, int propertyIndex, String value) {
        throw new UnsupportedOperationException("No stringFields defined");
    }

    protected void objectField(Object bean, int propertyIndex, Object value) {
        throw new UnsupportedOperationException("No objectFields defined");
    }

    protected void _reportProblem(Object bean, int index, Throwable e) {
        this.broken = true;
        String msg = String.format("Disabling Afterburner deserialization for type %s, field #%d, due to access error (type %s, message=%s)%n", bean.getClass(), index, e.getClass().getName(), e.getMessage());
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, msg, e);
    }
}

