/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.databind.deser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import oadd.com.fasterxml.jackson.annotation.JsonFormat;
import oadd.com.fasterxml.jackson.databind.AnnotationIntrospector;
import oadd.com.fasterxml.jackson.databind.BeanDescription;
import oadd.com.fasterxml.jackson.databind.DeserializationConfig;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonMappingException;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.databind.KeyDeserializer;
import oadd.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import oadd.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import oadd.com.fasterxml.jackson.databind.introspect.Annotated;
import oadd.com.fasterxml.jackson.databind.type.ArrayType;
import oadd.com.fasterxml.jackson.databind.type.CollectionLikeType;
import oadd.com.fasterxml.jackson.databind.type.CollectionType;
import oadd.com.fasterxml.jackson.databind.type.MapLikeType;
import oadd.com.fasterxml.jackson.databind.type.MapType;
import oadd.com.fasterxml.jackson.databind.util.ClassUtil;
import oadd.com.fasterxml.jackson.databind.util.Converter;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);

    Object writeReplace() {
        this._incompleteDeserializers.clear();
        return this;
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType propertyType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(propertyType);
        if (deser == null && (deser = this._createAndCacheValueDeserializer(ctxt, factory, propertyType)) == null) {
            deser = this._handleUnknownValueDeserializer(propertyType);
        }
        return deser;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        KeyDeserializer kd = factory.createKeyDeserializer(ctxt, type);
        if (kd == null) {
            return this._handleUnknownKeyDeserializer(type);
        }
        if (kd instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)kd)).resolve(ctxt);
        }
        return kd;
    }

    public boolean hasValueDeserializerFor(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
        if (deser == null) {
            deser = this._createAndCacheValueDeserializer(ctxt, factory, type);
        }
        return deser != null;
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        return this._cachedDeserializers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer<Object> jsonDeserializer;
            block9: {
                JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
                if (deser != null) {
                    return deser;
                }
                int count = this._incompleteDeserializers.size();
                if (count > 0 && (deser = this._incompleteDeserializers.get(type)) != null) {
                    return deser;
                }
                try {
                    jsonDeserializer = this._createAndCache2(ctxt, factory, type);
                    if (count != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (count == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(ctxt, factory, type);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (deser == null) {
            return null;
        }
        boolean isResolvable = deser instanceof ResolvableDeserializer;
        boolean addToCache = deser.isCachable();
        if (isResolvable) {
            this._incompleteDeserializers.put(type, deser);
            ((ResolvableDeserializer)((Object)deser)).resolve(ctxt);
            this._incompleteDeserializers.remove(type);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        Class<?> builder;
        Object beanDesc;
        JsonDeserializer<Object> deser;
        DeserializationConfig config = ctxt.getConfig();
        if (type.isAbstract() || type.isMapLikeType() || type.isCollectionLikeType()) {
            type = factory.mapAbstractType(config, type);
        }
        if ((deser = this.findDeserializerFromAnnotation(ctxt, ((BeanDescription)(beanDesc = config.introspect(type))).getClassInfo())) != null) {
            return deser;
        }
        JavaType newType = this.modifyTypeByAnnotation(ctxt, ((BeanDescription)beanDesc).getClassInfo(), type);
        if (newType != type) {
            type = newType;
            beanDesc = config.introspect(newType);
        }
        if ((builder = ((BeanDescription)beanDesc).findPOJOBuilder()) != null) {
            return factory.createBuilderBasedDeserializer(ctxt, type, (BeanDescription)beanDesc, builder);
        }
        Converter<Object, Object> conv = ((BeanDescription)beanDesc).findDeserializationConverter();
        if (conv == null) {
            return this._createDeserializer2(ctxt, factory, type, (BeanDescription)beanDesc);
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        if (!delegateType.hasRawClass(type.getRawClass())) {
            beanDesc = config.introspect(delegateType);
        }
        return new StdDelegatingDeserializer<Object>(conv, delegateType, this._createDeserializer2(ctxt, factory, delegateType, (BeanDescription)beanDesc));
    }

    protected JsonDeserializer<?> _createDeserializer2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        if (type.isEnumType()) {
            return factory.createEnumDeserializer(ctxt, type, beanDesc);
        }
        if (type.isContainerType()) {
            JsonFormat.Value format;
            if (type.isArrayType()) {
                return factory.createArrayDeserializer(ctxt, (ArrayType)type, beanDesc);
            }
            if (type.isMapLikeType()) {
                MapLikeType mlt = (MapLikeType)type;
                if (mlt.isTrueMapType()) {
                    return factory.createMapDeserializer(ctxt, (MapType)mlt, beanDesc);
                }
                return factory.createMapLikeDeserializer(ctxt, mlt, beanDesc);
            }
            if (type.isCollectionLikeType() && ((format = beanDesc.findExpectedFormat(null)) == null || format.getShape() != JsonFormat.Shape.OBJECT)) {
                CollectionLikeType clt = (CollectionLikeType)type;
                if (clt.isTrueCollectionType()) {
                    return factory.createCollectionDeserializer(ctxt, (CollectionType)clt, beanDesc);
                }
                return factory.createCollectionLikeDeserializer(ctxt, clt, beanDesc);
            }
        }
        if (JsonNode.class.isAssignableFrom(type.getRawClass())) {
            return factory.createTreeDeserializer(config, type, beanDesc);
        }
        return factory.createBeanDeserializer(ctxt, type, beanDesc);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) throws JsonMappingException {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef == null) {
            return null;
        }
        JsonDeserializer<Object> deser = ctxt.deserializerInstance(ann, deserDef);
        return this.findConvertingDeserializer(ctxt, ann, deser);
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext ctxt, Annotated a, JsonDeserializer<Object> deser) throws JsonMappingException {
        Converter<Object, Object> conv = this.findConverter(ctxt, a);
        if (conv == null) {
            return deser;
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        return new StdDelegatingDeserializer<Object>(conv, delegateType, deser);
    }

    protected Converter<Object, Object> findConverter(DeserializationContext ctxt, Annotated a) throws JsonMappingException {
        Object convDef = ctxt.getAnnotationIntrospector().findDeserializationConverter(a);
        if (convDef == null) {
            return null;
        }
        return ctxt.converterInstance(a, convDef);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext ctxt, Annotated a, JavaType type) throws JsonMappingException {
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a, type);
        if (subclass != null) {
            try {
                type = type.narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        if (type.isContainerType()) {
            Object cdDef;
            JavaType contentType;
            Class<?> cc;
            KeyDeserializer kd;
            Object kdDef;
            JavaType keyType;
            Class<?> keyClass = intr.findDeserializationKeyType(a, type.getKeyType());
            if (keyClass != null) {
                if (!(type instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type + " is not a Map(-like) type");
                }
                try {
                    type = ((MapLikeType)type).narrowKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((keyType = type.getKeyType()) != null && keyType.getValueHandler() == null && (kdDef = intr.findKeyDeserializer(a)) != null && (kd = ctxt.keyDeserializerInstance(a, kdDef)) != null) {
                type = ((MapLikeType)type).withKeyValueHandler(kd);
                keyType = type.getKeyType();
            }
            if ((cc = intr.findDeserializationContentType(a, type.getContentType())) != null) {
                try {
                    type = type.narrowContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((contentType = type.getContentType()).getValueHandler() == null && (cdDef = intr.findContentDeserializer(a)) != null) {
                JsonDeserializer<Object> cd = null;
                if (cdDef instanceof JsonDeserializer) {
                    cdDef = (JsonDeserializer)cdDef;
                } else {
                    Class<?> cdClass = this._verifyAsClass(cdDef, "findContentDeserializer", JsonDeserializer.None.class);
                    if (cdClass != null) {
                        cd = ctxt.deserializerInstance(a, cdClass);
                    }
                }
                if (cd != null) {
                    type = type.withContentValueHandler(cd);
                }
            }
        }
        return type;
    }

    private Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type) throws JsonMappingException {
        Class<?> rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + type);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + type);
    }
}

