/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.AbstractShortCollection;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.ShortContainer;
import oadd.com.carrotsearch.hppc.ShortLookupContainer;
import oadd.com.carrotsearch.hppc.ShortSet;
import oadd.com.carrotsearch.hppc.cursors.ShortCursor;
import oadd.com.carrotsearch.hppc.predicates.ShortPredicate;
import oadd.com.carrotsearch.hppc.procedures.ShortProcedure;

public class ShortOpenHashSet
extends AbstractShortCollection
implements ShortLookupContainer,
ShortSet,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public short[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public ShortOpenHashSet() {
        this(16, 0.75f);
    }

    public ShortOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ShortOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ShortOpenHashSet(ShortContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(short e) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = e;
        return true;
    }

    public int add(short e1, short e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(short ... elements) {
        int count = 0;
        for (short e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(ShortContainer container) {
        return this.addAll((Iterable<? extends ShortCursor>)container);
    }

    public final int addAll(Iterable<? extends ShortCursor> iterable) {
        int count = 0;
        for (ShortCursor shortCursor : iterable) {
            if (!this.add(shortCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndRehash() {
        short[] oldKeys = this.keys;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            short key = oldKeys[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new short[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public int removeAllOccurrences(short key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public short lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(short key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        int capacity;
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, (short)0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ShortSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortSet && (other = (ShortSet)obj).size() == this.size()) {
                for (ShortCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public final short[] toArray() {
        short[] cloned = new short[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public ShortOpenHashSet clone() {
        try {
            ShortOpenHashSet cloned = (ShortOpenHashSet)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        short[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        short[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static ShortOpenHashSet from(short ... elements) {
        ShortOpenHashSet set = new ShortOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static ShortOpenHashSet from(ShortContainer container) {
        return new ShortOpenHashSet(container);
    }

    public static ShortOpenHashSet newInstance() {
        return new ShortOpenHashSet();
    }

    public static ShortOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new ShortOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            int max = ShortOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < ShortOpenHashSet.this.keys.length && !ShortOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

