/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.AbstractObjectCollection;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.ObjectContainer;
import oadd.com.carrotsearch.hppc.ObjectLookupContainer;
import oadd.com.carrotsearch.hppc.ObjectSet;
import oadd.com.carrotsearch.hppc.cursors.ObjectCursor;
import oadd.com.carrotsearch.hppc.predicates.ObjectPredicate;
import oadd.com.carrotsearch.hppc.procedures.ObjectProcedure;

public class ObjectOpenHashSet<KType>
extends AbstractObjectCollection<KType>
implements ObjectLookupContainer<KType>,
ObjectSet<KType>,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public KType[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public ObjectOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjectOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ObjectOpenHashSet(ObjectContainer<KType> container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(KType e) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e) & mask;
        while (this.allocated[slot]) {
            if (e == null ? this.keys[slot] == null : e.equals(this.keys[slot])) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = e;
        return true;
    }

    public int add(KType e1, KType e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(KType ... elements) {
        int count = 0;
        for (KType e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(ObjectContainer<? extends KType> container) {
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public final int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int count = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            if (!this.add((KType)objectCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndRehash() {
        KType[] oldKeys = this.keys;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            KType key = oldKeys[i];
            oldKeys[i] = null;
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && !(key == null ? this.keys[slot] == null : key.equals(this.keys[slot]))) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = (Object[])Internals.newArray(capacity);
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public int removeAllOccurrences(KType key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(KType key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.keys[slotPrev] = null;
    }

    public KType lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(KType key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == null ? this.keys[slot] == null : key.equals(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        int capacity;
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        KType[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ObjectSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectSet && (other = (ObjectSet)obj).size() == this.size()) {
                for (ObjectCursor<KType> c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        KType[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public final Object[] toArray() {
        Object[] cloned = (Object[])Internals.newArray(this.assigned);
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public ObjectOpenHashSet<KType> clone() {
        try {
            ObjectOpenHashSet cloned = (ObjectOpenHashSet)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        KType[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        KType[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static <KType> ObjectOpenHashSet<KType> from(KType ... elements) {
        ObjectOpenHashSet<KType> set = new ObjectOpenHashSet<KType>((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static <KType> ObjectOpenHashSet<KType> from(ObjectContainer<KType> container) {
        return new ObjectOpenHashSet<KType>(container);
    }

    public static <KType> ObjectOpenHashSet<KType> newInstance() {
        return new ObjectOpenHashSet<KType>();
    }

    public static <KType> ObjectOpenHashSet<KType> newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new ObjectOpenHashSet<KType>(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            int max = ObjectOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < ObjectOpenHashSet.this.keys.length && !ObjectOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

