/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.AbstractObjectCollection;
import oadd.com.carrotsearch.hppc.ArraySizingStrategy;
import oadd.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.ObjectContainer;
import oadd.com.carrotsearch.hppc.ObjectDeque;
import oadd.com.carrotsearch.hppc.cursors.ObjectCursor;
import oadd.com.carrotsearch.hppc.predicates.ObjectPredicate;
import oadd.com.carrotsearch.hppc.procedures.ObjectProcedure;

public class ObjectArrayDeque<KType>
extends AbstractObjectCollection<KType>
implements ObjectDeque<KType>,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    public KType[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayDeque() {
        this(5);
    }

    public ObjectArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        initialCapacity = resizer.round(initialCapacity);
        this.buffer = (Object[])Internals.newArray(initialCapacity);
    }

    public ObjectArrayDeque(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(KType e1) {
        int h = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    @Override
    public void addFirst(KType ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public final int addFirst(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.addFirst((KType)objectCursor.value);
        }
        return size;
    }

    public final int addFirst(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addFirst((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(KType e1) {
        int t = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    @Override
    public void addLast(KType ... elements) {
        this.ensureBufferSpace(1);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public final int addLast(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.addLast((KType)objectCursor.value);
        }
        return size;
    }

    public final int addLast(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addLast((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public KType removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        KType result = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = ObjectArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public KType removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = ObjectArrayDeque.oneLeft(this.tail, this.buffer.length);
        KType result = this.buffer[this.tail];
        this.buffer[this.tail] = null;
        return result;
    }

    @Override
    public KType getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public KType getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[ObjectArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirstOccurrence(KType e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(KType e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (e1 == null ? this.buffer[i] == null : e1.equals(this.buffer[i])) {
                return i;
            }
            i = ObjectArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLastOccurrence(KType e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(KType e1) {
        int bufLen = this.buffer.length;
        int last = ObjectArrayDeque.oneLeft(this.head, bufLen);
        int i = ObjectArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (e1 == null ? this.buffer[i] == null : e1.equals(this.buffer[i])) {
                return i;
            }
            i = ObjectArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAllOccurrences(KType e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (e1 == null ? this.buffer[from] == null : e1.equals(this.buffer[from])) {
                this.buffer[from] = null;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = null;
                }
                to = ObjectArrayDeque.oneRight(to, bufLen);
            }
            from = ObjectArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        KType[] b = this.buffer;
        int bufLen = b.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(b, head, b, head + 1, leftChunk);
            } else {
                System.arraycopy(b, 0, b, 1, index);
                b[0] = b[lastIndex];
                System.arraycopy(b, head, b, head + 1, lastIndex - head);
            }
            b[head] = null;
            this.head = ObjectArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(b, index + 1, b, index, rightChunk);
            } else {
                System.arraycopy(b, index + 1, b, index, lastIndex - index);
                b[lastIndex] = b[0];
                System.arraycopy(b, 1, b, 0, tail);
            }
            b[tail] = null;
            this.tail = ObjectArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, null);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, null);
            Arrays.fill(this.buffer, this.head, this.buffer.length, null);
        }
        this.tail = 0;
        this.head = 0;
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = (Object[])Internals.newArray(this.resizer.round(5));
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int elementsCount = this.size();
        int requestedMinimum = 1 + elementsCount + expectedAdditions;
        if (requestedMinimum >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions + 1);
            assert (newSize >= requestedMinimum) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            Object[] newBuffer = (Object[])Internals.newArray(newSize);
            if (bufferLen > 0) {
                this.toArray(newBuffer);
                this.tail = elementsCount;
                this.head = 0;
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public final Object[] toArray() {
        int size = this.size();
        return this.toArray((Object[])Internals.newArray(size));
    }

    public KType[] toArray(KType[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public ObjectArrayDeque<KType> clone() {
        try {
            ObjectArrayDeque cloned = (ObjectArrayDeque)super.clone();
            cloned.buffer = (Object[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static final int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    static final int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<ObjectCursor<KType>> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        KType[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        KType[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        KType[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = ObjectArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(ObjectPredicate<? super KType> predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        KType[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = ObjectArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = null;
                    ++removed;
                } else {
                    if (to != from) {
                        this.buffer[to] = this.buffer[from];
                        this.buffer[from] = null;
                    }
                    to = ObjectArrayDeque.oneRight(to, bufLen);
                }
                from = ObjectArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = null;
                }
                to = ObjectArrayDeque.oneRight(to, bufLen);
                from = ObjectArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(KType e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        KType[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == null ? buffer[i] == null : e.equals(buffer[i])) {
                return true;
            }
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        KType[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        ObjectDeque other;
        if (obj != null && obj instanceof ObjectDeque && (other = (ObjectDeque)obj).size() == this.size()) {
            int fromIndex = this.head;
            KType[] buffer = this.buffer;
            int i = fromIndex;
            for (ObjectCursor c : other) {
                if (!(c.value != null ? c.value.equals(buffer[i]) : buffer[i] == null)) {
                    return false;
                }
                i = ObjectArrayDeque.oneRight(i, buffer.length);
            }
            return true;
        }
        return false;
    }

    public static <KType> ObjectArrayDeque<KType> newInstance() {
        return new ObjectArrayDeque<KType>();
    }

    public static <KType> ObjectArrayDeque<KType> newInstanceWithCapacity(int initialCapacity) {
        return new ObjectArrayDeque<KType>(initialCapacity);
    }

    public static <KType> ObjectArrayDeque<KType> from(KType ... elements) {
        ObjectArrayDeque<KType> coll = new ObjectArrayDeque<KType>(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static <KType> ObjectArrayDeque<KType> from(ObjectArrayDeque<KType> container) {
        return new ObjectArrayDeque<KType>(container);
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = ObjectArrayDeque.this.tail;
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ObjectArrayDeque.oneLeft(this.cursor.index, ObjectArrayDeque.this.buffer.length);
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ObjectArrayDeque.oneLeft(ObjectArrayDeque.this.head, ObjectArrayDeque.this.buffer.length);
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ObjectArrayDeque.oneRight(this.cursor.index, ObjectArrayDeque.this.buffer.length);
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

