/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.ArraySizingStrategy;
import oadd.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import oadd.com.carrotsearch.hppc.EmptyArrays;
import oadd.com.carrotsearch.hppc.IntArrayList;
import oadd.com.carrotsearch.hppc.IntContainer;
import oadd.com.carrotsearch.hppc.IntLookupContainer;
import oadd.com.carrotsearch.hppc.IntSet;
import oadd.com.carrotsearch.hppc.cursors.IntCursor;
import oadd.com.carrotsearch.hppc.predicates.IntPredicate;
import oadd.com.carrotsearch.hppc.procedures.IntProcedure;

public class IntDoubleLinkedSet
implements IntLookupContainer,
IntSet,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    public int[] dense = EmptyArrays.EMPTY_INT_ARRAY;
    public int[] sparse = EmptyArrays.EMPTY_INT_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public IntDoubleLinkedSet() {
        this(5, 0);
    }

    public IntDoubleLinkedSet(int denseCapacity, int sparseCapacity) {
        this(denseCapacity, sparseCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public IntDoubleLinkedSet(int denseCapacity, int sparseCapacity, ArraySizingStrategy resizer) {
        assert (denseCapacity >= 0) : "denseCapacity must be >= 0: " + denseCapacity;
        assert (sparseCapacity >= 0) : "sparseCapacity must be >= 0: " + sparseCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureDenseCapacity(resizer.round(denseCapacity));
        this.ensureSparseCapacity(sparseCapacity);
    }

    public IntDoubleLinkedSet(IntContainer container) {
        this(container.size(), 1 + IntDoubleLinkedSet.maxElement(container));
        for (IntCursor cursor : container) {
            this.addNoChecks(cursor.value);
        }
    }

    protected final void ensureDenseCapacity(int expectedAdditions) {
        int bufferLen = this.dense == null ? 0 : this.dense.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            int[] newBuffer = new int[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.dense, 0, newBuffer, 0, elementsCount);
            }
            this.dense = newBuffer;
        }
    }

    protected final void ensureSparseCapacity(int value) {
        assert (value >= 0) : "value must be >= 0: " + value;
        if (value >= this.sparse.length) {
            int[] newBuffer = new int[value + 1];
            if (this.sparse.length > 0) {
                System.arraycopy(this.sparse, 0, newBuffer, 0, this.sparse.length);
            }
            this.sparse = newBuffer;
        }
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int[] toArray() {
        int[] result = new int[this.size()];
        System.arraycopy(this.dense, 0, result, 0, this.size());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    @Override
    public boolean contains(int value) {
        int index;
        return value >= 0 && value < this.sparse.length && (index = this.sparse[value]) < this.elementsCount && this.dense[index] == value;
    }

    @Override
    public boolean add(int value) {
        assert (value >= 0) : "Double linked set supports values >= 0 only.";
        boolean containsAlready = this.contains(value);
        if (!containsAlready) {
            this.ensureDenseCapacity(1);
            this.ensureSparseCapacity(value);
            this.sparse[value] = this.elementsCount;
            this.dense[this.elementsCount++] = value;
        }
        return !containsAlready;
    }

    private void addNoChecks(int value) {
        assert (value >= 0) : "Double linked set supports values >= 0 only.";
        boolean containsAlready = this.contains(value);
        if (!containsAlready) {
            assert (this.size() + 1 < this.dense.length) : "Dense array too small.";
            assert (value < this.sparse.length) : "Value too large for sparse.";
            this.sparse[value] = this.elementsCount;
            this.dense[this.elementsCount++] = value;
        }
    }

    public int add(int e1, int e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(int ... elements) {
        int count = 0;
        for (int e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(IntContainer container) {
        return this.addAll((Iterable<? extends IntCursor>)container);
    }

    public final int addAll(Iterable<? extends IntCursor> iterable) {
        int count = 0;
        for (IntCursor intCursor : iterable) {
            if (!this.add(intCursor.value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int removeAllOccurrences(int value) {
        int n;
        int slot;
        if (value >= 0 && value < this.sparse.length && (slot = this.sparse[value]) <= (n = this.elementsCount - 1) && this.dense[slot] == value) {
            int lastValue = this.dense[n];
            --this.elementsCount;
            this.dense[slot] = lastValue;
            this.sparse[lastValue] = slot;
            return 1;
        }
        return 0;
    }

    public boolean remove(int key) {
        return this.removeAllOccurrences(key) == 1;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new IntArrayList.ValueIterator(this.dense, this.size());
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        int max = this.size();
        int[] dense = this.dense;
        for (int i = 0; i < max; ++i) {
            procedure.apply(dense[i]);
        }
        return procedure;
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        int max = this.size();
        int[] dense = this.dense;
        for (int i = 0; i < max && !predicate.apply(dense[i]); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(IntLookupContainer c) {
        int max = this.size();
        int removed = 0;
        int[] dense = this.dense;
        int i = 0;
        while (i < max) {
            if (c.contains(dense[i])) {
                int lastValue;
                dense[i] = lastValue = dense[--max];
                this.sparse[lastValue] = i;
                ++removed;
                continue;
            }
            ++i;
        }
        this.elementsCount = max;
        return removed;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int max = this.size();
        int removed = 0;
        int[] dense = this.dense;
        int i = 0;
        while (i < max) {
            if (predicate.apply(dense[i])) {
                int lastValue;
                dense[i] = lastValue = dense[--max];
                this.sparse[lastValue] = i;
                ++removed;
                continue;
            }
            ++i;
        }
        this.elementsCount = max;
        return removed;
    }

    @Override
    public int retainAll(IntLookupContainer c) {
        int max = this.size();
        int removed = 0;
        int[] dense = this.dense;
        int i = 0;
        while (i < max) {
            if (!c.contains(dense[i])) {
                int lastValue;
                dense[i] = lastValue = dense[--max];
                this.sparse[lastValue] = i;
                ++removed;
                continue;
            }
            ++i;
        }
        this.elementsCount = max;
        return removed;
    }

    @Override
    public int retainAll(final IntPredicate predicate) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int value) {
                return !predicate.apply(value);
            }
        });
    }

    public static IntDoubleLinkedSet from(int ... elements) {
        IntDoubleLinkedSet set = new IntDoubleLinkedSet(elements.length, 1 + IntDoubleLinkedSet.maxElement(elements));
        for (int i : elements) {
            set.addNoChecks(i);
        }
        return set;
    }

    public static IntDoubleLinkedSet from(IntContainer container) {
        return new IntDoubleLinkedSet(container);
    }

    private static int maxElement(IntContainer container) {
        int max = 0;
        for (IntCursor c : container) {
            max = Math.max(max, c.value);
        }
        return max;
    }

    private static int maxElement(int ... elements) {
        int max = 0;
        for (int c : elements) {
            max = Math.max(max, c);
        }
        return max;
    }

    public IntDoubleLinkedSet clone() {
        try {
            IntDoubleLinkedSet cloned = (IntDoubleLinkedSet)super.clone();
            cloned.dense = (int[])this.dense.clone();
            cloned.sparse = (int[])this.sparse.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

