/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractByteCollection;
import oadd.com.carrotsearch.hppc.AbstractIntCollection;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.BitUtil;
import oadd.com.carrotsearch.hppc.ByteContainer;
import oadd.com.carrotsearch.hppc.IntByteAssociativeContainer;
import oadd.com.carrotsearch.hppc.IntByteMap;
import oadd.com.carrotsearch.hppc.IntContainer;
import oadd.com.carrotsearch.hppc.IntLookupContainer;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.cursors.ByteCursor;
import oadd.com.carrotsearch.hppc.cursors.IntByteCursor;
import oadd.com.carrotsearch.hppc.cursors.IntCursor;
import oadd.com.carrotsearch.hppc.predicates.BytePredicate;
import oadd.com.carrotsearch.hppc.predicates.IntPredicate;
import oadd.com.carrotsearch.hppc.procedures.ByteProcedure;
import oadd.com.carrotsearch.hppc.procedures.IntByteProcedure;
import oadd.com.carrotsearch.hppc.procedures.IntProcedure;

public class IntByteOpenHashMap
implements IntByteMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public int[] keys;
    public byte[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public IntByteOpenHashMap() {
        this(16);
    }

    public IntByteOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntByteOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public IntByteOpenHashMap(IntByteAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public byte put(int key, byte value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                byte oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0;
    }

    @Override
    public final int putAll(IntByteAssociativeContainer container) {
        int count = this.assigned;
        for (IntByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends IntByteCursor> iterable) {
        int count = this.assigned;
        for (IntByteCursor intByteCursor : iterable) {
            this.put(intByteCursor.key, intByteCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(int key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final byte putOrAdd(int key, byte putValue, byte additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int n = slot;
                byte by = (byte)(this.values[n] + additionValue);
                this.values[n] = by;
                return by;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        byte v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        int[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            int key = oldKeys[i];
            byte value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new int[capacity];
        this.values = new byte[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public byte remove(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                byte v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(IntContainer container) {
        int before = this.assigned;
        for (IntCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(IntPredicate predicate) {
        int before = this.assigned;
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public byte get(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public byte lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public byte lset(byte key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        byte previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (IntByteCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            IntByteMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntByteMap && (other = (IntByteMap)obj).size() == this.size()) {
                for (IntByteCursor c : this) {
                    byte v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<IntByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends IntByteProcedure> T forEach(T procedure) {
        int[] keys = this.keys;
        byte[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteContainer values() {
        return new ValuesContainer();
    }

    public IntByteOpenHashMap clone() {
        try {
            IntByteOpenHashMap cloned = (IntByteOpenHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static IntByteOpenHashMap from(int[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntByteOpenHashMap map = new IntByteOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static IntByteOpenHashMap from(IntByteAssociativeContainer container) {
        return new IntByteOpenHashMap(container);
    }

    public static IntByteOpenHashMap newInstance() {
        return new IntByteOpenHashMap();
    }

    public static IntByteOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new IntByteOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            int max = IntByteOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !IntByteOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntByteOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return IntByteOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return IntByteOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            boolean[] allocated = IntByteOpenHashMap.this.allocated;
            byte[] values = IntByteOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            boolean[] allocated = IntByteOpenHashMap.this.allocated;
            byte[] values = IntByteOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            boolean[] allocated = IntByteOpenHashMap.this.allocated;
            byte[] values = IntByteOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(byte e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max = IntByteOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !IntByteOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntByteOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntByteOpenHashMap owner;

        public KeysContainer() {
            this.owner = IntByteOpenHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return IntByteOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            int[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<IntByteCursor> {
        private final IntByteCursor cursor = new IntByteCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntByteCursor fetch() {
            int i;
            int max = IntByteOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !IntByteOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = IntByteOpenHashMap.this.keys[i];
            this.cursor.value = IntByteOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

