/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import oadd.com.carrotsearch.hppc.ArraySizingStrategy;
import oadd.com.carrotsearch.hppc.FloatArrayList;
import oadd.com.carrotsearch.hppc.FloatContainer;
import oadd.com.carrotsearch.hppc.cursors.FloatCursor;

public class FloatStack
extends FloatArrayList {
    public FloatStack() {
    }

    public FloatStack(int initialCapacity) {
        super(initialCapacity);
    }

    public FloatStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public FloatStack(FloatContainer container) {
        super(container);
    }

    public final void push(float e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(float e1, float e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(float e1, float e2, float e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(float e1, float e2, float e3, float e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(float[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(float ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(FloatContainer container) {
        return this.addAll(container);
    }

    public final int pushAll(Iterable<? extends FloatCursor> iterable) {
        return this.addAll(iterable);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public final float pop() {
        assert (this.elementsCount > 0);
        float v = this.buffer[--this.elementsCount];
        return v;
    }

    public final float peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static FloatStack newInstance() {
        return new FloatStack();
    }

    public static FloatStack newInstanceWithCapacity(int initialCapacity) {
        return new FloatStack(initialCapacity);
    }

    public static FloatStack from(float ... elements) {
        FloatStack stack = new FloatStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static FloatStack from(FloatContainer container) {
        return new FloatStack(container);
    }

    @Override
    public FloatStack clone() {
        return (FloatStack)super.clone();
    }
}

