/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import oadd.com.carrotsearch.hppc.ArraySizingStrategy;
import oadd.com.carrotsearch.hppc.DoubleArrayList;
import oadd.com.carrotsearch.hppc.DoubleContainer;
import oadd.com.carrotsearch.hppc.cursors.DoubleCursor;

public class DoubleStack
extends DoubleArrayList {
    public DoubleStack() {
    }

    public DoubleStack(int initialCapacity) {
        super(initialCapacity);
    }

    public DoubleStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public DoubleStack(DoubleContainer container) {
        super(container);
    }

    public final void push(double e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(double e1, double e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(double e1, double e2, double e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(double e1, double e2, double e3, double e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(double[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(double ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(DoubleContainer container) {
        return this.addAll(container);
    }

    public final int pushAll(Iterable<? extends DoubleCursor> iterable) {
        return this.addAll(iterable);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public final double pop() {
        assert (this.elementsCount > 0);
        double v = this.buffer[--this.elementsCount];
        return v;
    }

    public final double peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static DoubleStack newInstance() {
        return new DoubleStack();
    }

    public static DoubleStack newInstanceWithCapacity(int initialCapacity) {
        return new DoubleStack(initialCapacity);
    }

    public static DoubleStack from(double ... elements) {
        DoubleStack stack = new DoubleStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static DoubleStack from(DoubleContainer container) {
        return new DoubleStack(container);
    }

    @Override
    public DoubleStack clone() {
        return (DoubleStack)super.clone();
    }
}

