/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OTriple;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeIterator;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedVertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexIterator;
import com.tinkerpop.blueprints.impls.orient.OrientVertexQuery;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrientVertex
extends OrientElement
implements OrientExtendedVertex {
    public static final String CONNECTION_OUT_PREFIX = "out_";
    public static final String CONNECTION_IN_PREFIX = "in_";
    private static final long serialVersionUID = 1L;

    public OrientVertex() {
        super(null, null);
    }

    protected OrientVertex(OrientBaseGraph graph, String className, Object ... fields) {
        super(graph, null);
        if (className != null) {
            className = this.checkForClassInSchema(OrientBaseGraph.encodeClassName(className));
        }
        this.rawElement = new ODocument(className == null ? "V" : className);
        this.setPropertiesInternal(fields);
    }

    public OrientVertex(OrientBaseGraph graph, OIdentifiable record) {
        super(graph, record);
    }

    public static String getConnectionFieldName(Direction iDirection, String iClassName, boolean useVertexFieldsForEdgeLabels) {
        if (iDirection == null || iDirection == Direction.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        if (useVertexFieldsForEdgeLabels) {
            String prefix;
            String string = prefix = iDirection == Direction.OUT ? CONNECTION_OUT_PREFIX : CONNECTION_IN_PREFIX;
            if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
                return prefix;
            }
            return prefix + iClassName;
        }
        return iDirection == Direction.OUT ? "out" : "in";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createLink(OrientBaseGraph iGraph, ODocument iFromVertex, OIdentifiable iTo, String iFieldName) {
        OIdentifiable out;
        OType propType;
        OType outType = iFromVertex.fieldType(iFieldName);
        Object found = iFromVertex.field(iFieldName);
        OImmutableClass linkClass = ODocumentInternal.getImmutableSchemaClass((ODocument)iFromVertex);
        if (linkClass == null) {
            throw new IllegalArgumentException("Class not found in source vertex: " + iFromVertex);
        }
        OProperty prop = linkClass.getProperty(iFieldName);
        OType oType = propType = prop != null && prop.getType() != OType.ANY ? prop.getType() : null;
        if (found == null) {
            if (iGraph.isAutoScaleEdgeType() && (prop == null || propType == OType.LINK || "true".equalsIgnoreCase(prop.getCustom("ordered")))) {
                out = iTo;
                outType = OType.LINK;
            } else if (propType == OType.LINKLIST || prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                ORecordLazyList coll = new ORecordLazyList(iFromVertex);
                coll.add(iTo);
                out = coll;
                outType = OType.LINKLIST;
            } else {
                if (propType != null && propType != OType.LINKBAG) throw new IllegalStateException("Type of field provided in schema '" + prop.getType() + "' cannot be used for link creation.");
                ORidBag bag = new ORidBag();
                bag.add(iTo);
                out = bag;
                outType = OType.LINKBAG;
            }
        } else if (found instanceof OIdentifiable) {
            if (prop != null && propType == OType.LINK) {
                throw new IllegalStateException("Type of field provided in schema '" + prop.getType() + "' cannot be used for creation to hold several links.");
            }
            if (prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                ORecordLazyList coll = new ORecordLazyList(iFromVertex);
                coll.add(found);
                coll.add(iTo);
                out = coll;
                outType = OType.LINKLIST;
            } else {
                ORidBag bag = new ORidBag();
                bag.add((OIdentifiable)found);
                bag.add(iTo);
                out = bag;
                outType = OType.LINKBAG;
            }
        } else if (found instanceof ORidBag) {
            out = null;
            ((ORidBag)found).add(iTo);
        } else {
            if (!(found instanceof Collection)) throw new IllegalStateException("Relationship content is invalid on field " + iFieldName + ". Found: " + found);
            out = null;
            ((Collection)found).add(iTo);
        }
        if (out == null) return out;
        iFromVertex.field(iFieldName, (Object)out, new OType[]{outType});
        return out;
    }

    public static Direction getConnectionDirection(String iConnectionField, boolean useVertexFieldsForEdgeLabels) {
        if (iConnectionField == null) {
            throw new IllegalArgumentException("Cannot return direction of NULL connection ");
        }
        if (useVertexFieldsForEdgeLabels) {
            if (iConnectionField.startsWith(CONNECTION_OUT_PREFIX)) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith(CONNECTION_IN_PREFIX)) {
                return Direction.IN;
            }
        } else {
            if (iConnectionField.equals("out")) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith("in")) {
                return Direction.IN;
            }
        }
        throw new IllegalArgumentException("Cannot return direction of connection " + iConnectionField);
    }

    public static String getInverseConnectionFieldName(String iFieldName, boolean useVertexFieldsForEdgeLabels) {
        if (useVertexFieldsForEdgeLabels) {
            if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                if (iFieldName.length() == CONNECTION_OUT_PREFIX.length()) {
                    return CONNECTION_IN_PREFIX;
                }
                return CONNECTION_IN_PREFIX + iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
            if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                if (iFieldName.length() == CONNECTION_IN_PREFIX.length()) {
                    return CONNECTION_OUT_PREFIX;
                }
                return CONNECTION_OUT_PREFIX + iFieldName.substring(CONNECTION_IN_PREFIX.length());
            }
            throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
        }
        if (iFieldName.equals("out")) {
            return "in";
        }
        if (iFieldName.equals("in")) {
            return "out";
        }
        throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
    }

    public static void replaceLinks(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, OIdentifiable iNewVertex) {
        Collection col;
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.field(iFieldName, (Object)iNewVertex);
            }
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            boolean found = false;
            Iterator it = bag.rawIterator();
            while (it.hasNext()) {
                if (!((OIdentifiable)it.next()).equals(iVertexToRemove)) continue;
                found = true;
                it.remove();
            }
            if (found) {
                bag.add(iNewVertex);
            }
        } else if (fieldValue instanceof Collection && (col = (Collection)fieldValue).remove(iVertexToRemove)) {
            col.add(iNewVertex);
        }
        iVertex.save();
    }

    protected static OrientEdge getEdge(OrientBaseGraph graph, ODocument doc, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientEdge toAdd;
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        if (fieldRecord == null) {
            return null;
        }
        OImmutableClass klass = ODocumentInternal.getImmutableSchemaClass((ODocument)fieldRecord);
        if (klass == null && ODatabaseRecordThreadLocal.instance().getIfDefined() != null) {
            ODatabaseRecordThreadLocal.instance().getIfDefined().getMetadata().reload();
            klass = fieldRecord.getSchemaClass();
        }
        if (klass.isVertexType()) {
            if (iTargetVertex != null && !iTargetVertex.equals(fieldValue)) {
                return null;
            }
            toAdd = connection.getKey() == Direction.OUT ? graph.getEdgeInstance((OIdentifiable)doc, (OIdentifiable)fieldRecord, (String)connection.getValue()) : graph.getEdgeInstance((OIdentifiable)fieldRecord, (OIdentifiable)doc, (String)connection.getValue());
        } else if (klass.isEdgeType()) {
            OIdentifiable targetVertex;
            if (iTargetVertex != null && !iTargetVertex.equals(targetVertex = OrientEdge.getConnection(fieldRecord, ((Direction)connection.getKey()).opposite()))) {
                return null;
            }
            toAdd = graph.getEdge(fieldRecord);
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        return toAdd;
    }

    @Override
    public OrientVertex copy() {
        OrientVertex v = new OrientVertex();
        super.copyTo(v);
        return v;
    }

    @Override
    public OrientVertex getVertexInstance() {
        return this;
    }

    public Object execute(OCommandPredicate iPredicate) {
        Object result = iPredicate.evaluate((OIdentifiable)this.rawElement.getRecord(), null, null);
        if (result instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)result).setAutoConvertToRecord(true);
        }
        return result;
    }

    public Set<String> getPropertyKeys() {
        OrientBaseGraph graph = this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        HashSet<String> result = new HashSet<String>();
        for (String field : doc.fieldNames()) {
            if (graph != null && this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (field.startsWith(CONNECTION_OUT_PREFIX) || field.startsWith(CONNECTION_IN_PREFIX)) continue;
                result.add(field);
                continue;
            }
            if (field.equals("out") || field.equals("in")) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.rawElement == null) {
            return null;
        }
        ODocument raw = (ODocument)this.rawElement.getRecord();
        if (raw == null) {
            return null;
        }
        OrientBaseGraph graph = this.setCurrentGraphInThreadLocal();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String field : raw.fieldNames()) {
            if (graph != null && this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (field.startsWith(CONNECTION_OUT_PREFIX) || field.startsWith(CONNECTION_IN_PREFIX)) continue;
                result.put(field, raw.field(field));
                continue;
            }
            if (field.equals("out") || field.equals("in")) continue;
            result.put(field, raw.field(field));
        }
        return result;
    }

    public Iterable<Vertex> getVertices(Direction iDirection, String ... iLabels) {
        this.setCurrentGraphInThreadLocal();
        OrientBaseGraph.getEdgeClassNames(this.getGraph(), iLabels);
        OrientBaseGraph.encodeClassNames(iLabels);
        ODocument doc = this.getRecord();
        OMultiCollectionIterator iterable = new OMultiCollectionIterator();
        for (OTriple<String, Direction, String> connectionField : this.getConnectionFields(iDirection, iLabels)) {
            String fieldName = (String)((Object)connectionField.getKey());
            OPair connection = connectionField.getValue();
            Object fieldValue = doc.rawField(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, (OPair<Direction, String>)connection, fieldValue, iLabels);
                continue;
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll.size() == 1) {
                    if (coll instanceof ORecordLazyMultiValue) {
                        this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, (OPair<Direction, String>)connection, ((ORecordLazyMultiValue)coll).rawIterator().next(), iLabels);
                        continue;
                    }
                    if (coll instanceof List) {
                        this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, (OPair<Direction, String>)connection, ((List)coll).get(0), iLabels);
                        continue;
                    }
                    this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, (OPair<Direction, String>)connection, coll.iterator().next(), iLabels);
                    continue;
                }
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add((Object)new OrientVertexIterator(this, coll, ((ORecordLazyMultiValue)coll).rawIterator(), (OPair<Direction, String>)connection, iLabels, coll.size()));
                    continue;
                }
                iterable.add((Object)new OrientVertexIterator(this, coll, coll.iterator(), (OPair<Direction, String>)connection, iLabels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add((Object)new OrientVertexIterator(this, fieldValue, ((ORidBag)fieldValue).rawIterator(), (OPair<Direction, String>)connection, iLabels, -1));
        }
        return iterable;
    }

    public OrientVertexQuery query() {
        this.setCurrentGraphInThreadLocal();
        return new OrientVertexQuery(this);
    }

    public OTraverse traverse() {
        this.setCurrentGraphInThreadLocal();
        return new OTraverse().target(new OIdentifiable[]{this.getRecord()});
    }

    public void remove() {
        this.checkClass();
        OrientBaseGraph graph = this.checkIfAttached();
        graph.setCurrentGraphInThreadLocal();
        graph.autoStartTransaction();
        ODocument doc = this.getRecord();
        if (doc == null) {
            throw ExceptionFactory.vertexWithIdDoesNotExist((Object)this.getId());
        }
        HashMap treeRidbagEdgesToRemove = new HashMap();
        if (!graph.getRawGraph().getTransaction().isActive()) {
            for (String fieldName : doc.fieldNames()) {
                Object fv;
                OPair<Direction, String> connection = this.getConnection(Direction.BOTH, fieldName, new String[0]);
                if (connection == null || !((fv = doc.field(fieldName)) instanceof ORidBag) || ((ORidBag)fv).isEmbedded()) continue;
                ArrayList<ODocument> docs = new ArrayList<ODocument>();
                for (OIdentifiable id : (ORidBag)fv) {
                    docs.add(OrientBaseGraph.getDocument(id, true));
                }
                treeRidbagEdgesToRemove.put(fieldName, docs);
            }
        }
        super.removeRecord();
        Iterator<Index<? extends Element>> it = graph.getIndices().iterator();
        if (it.hasNext()) {
            HashSet<Edge> allEdges = new HashSet<Edge>();
            for (Edge e : this.getEdges(Direction.BOTH, new String[0])) {
                allEdges.add(e);
            }
            while (it.hasNext()) {
                OrientIndex idx;
                Index<? extends Element> index = it.next();
                if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
                    idx = (OrientIndex)index;
                    idx.removeElement(this);
                }
                if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
                idx = (OrientIndex)index;
                for (Edge e : allEdges) {
                    idx.removeElement((OrientEdge)e);
                }
            }
        }
        for (Map.Entry entry : treeRidbagEdgesToRemove.entrySet()) {
            doc.removeField((String)entry.getKey());
            for (ODocument docEdge : (List)entry.getValue()) {
                OrientBaseGraph.deleteEdgeIfAny((OIdentifiable)docEdge, false);
            }
        }
        graph.removeEdgesInternal(this, doc, null, true, this.settings.isUseVertexFieldsForEdgeLabels(), this.settings.isAutoScaleEdgeType());
    }

    public ORID moveToClass(String iClassName) {
        return this.moveTo(iClassName, null);
    }

    public ORID moveToCluster(String iClusterName) {
        return this.moveTo(null, iClusterName);
    }

    public ORID moveTo(String iClassName, String iClusterName) {
        OrientEdge oe;
        ORID oldIdentity;
        ORecord oldRecord;
        OrientBaseGraph graph = this.getGraph();
        if (this.checkDeletedInTx()) {
            graph.throwRecordNotFoundException(this.getIdentity(), "The vertex " + this.getIdentity() + " has been deleted");
        }
        if ((oldRecord = (oldIdentity = this.getIdentity().copy()).getRecord()) == null) {
            graph.throwRecordNotFoundException(this.getIdentity(), "The vertex " + this.getIdentity() + " has been deleted");
        }
        ODocument doc = ((ODocument)this.rawElement.getRecord()).copy();
        Iterable<Edge> outEdges = this.getEdges(Direction.OUT, new String[0]);
        Iterable<Edge> inEdges = this.getEdges(Direction.IN, new String[0]);
        this.copyRidBags(oldRecord, doc);
        oldRecord.delete();
        if (iClassName != null) {
            doc.setClassName(iClassName);
        }
        doc.setDirty();
        ORecordInternal.setIdentity((ORecord)doc, (ORecordId)new ORecordId());
        if (iClusterName != null) {
            doc.save(iClusterName);
        } else {
            doc.save();
        }
        ORID newIdentity = doc.getIdentity();
        for (Edge e : outEdges) {
            oe = (OrientEdge)e;
            if (oe.isLightweight()) {
                OrientVertex inV = oe.getVertex(Direction.IN);
                String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, oe.getLabel(), graph.isUseVertexFieldsForEdgeLabels());
                OrientVertex.replaceLinks(inV.getRecord(), inFieldName, (OIdentifiable)oldIdentity, (OIdentifiable)newIdentity);
                continue;
            }
            oe.vOut = newIdentity;
            oe.getRecord().field("out", (Object)newIdentity);
            oe.save();
        }
        for (Edge e : inEdges) {
            oe = (OrientEdge)e;
            if (oe.isLightweight()) {
                OrientVertex outV = oe.getVertex(Direction.OUT);
                String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, oe.getLabel(), graph.isUseVertexFieldsForEdgeLabels());
                OrientVertex.replaceLinks(outV.getRecord(), outFieldName, (OIdentifiable)oldIdentity, (OIdentifiable)newIdentity);
                continue;
            }
            oe.vIn = newIdentity;
            oe.getRecord().field("in", (Object)newIdentity);
            oe.save();
        }
        doc.save();
        return newIdentity;
    }

    private void copyRidBags(ORecord oldRecord, ODocument newDoc) {
        ODocument oldDoc = (ODocument)oldRecord;
        for (String field : oldDoc.fieldNames()) {
            ORidBag bag;
            Object val;
            if (!field.equalsIgnoreCase("out") && !field.equalsIgnoreCase("in") && !field.startsWith(CONNECTION_OUT_PREFIX) && !field.startsWith(CONNECTION_IN_PREFIX) && !field.startsWith("OUT_") && !field.startsWith("IN_") || !((val = oldDoc.rawField(field)) instanceof ORidBag) || (bag = (ORidBag)val).isEmbedded()) continue;
            ORidBag newBag = new ORidBag();
            Iterator rawIter = bag.rawIterator();
            while (rawIter.hasNext()) {
                newBag.add((OIdentifiable)rawIter.next());
            }
            newDoc.field(field, (Object)newBag);
        }
    }

    public Edge addEdge(String label, Vertex inVertex) {
        if (inVertex instanceof PartitionVertex) {
            inVertex = ((PartitionVertex)inVertex).getBaseVertex();
        }
        return this.addEdge(label, (OrientVertex)inVertex, null, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName) {
        return this.addEdge(label, inVertex, iClassName, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, Object[] fields) {
        return this.addEdge(label, inVertex, null, null, fields);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        if (inVertex == null) {
            throw new IllegalArgumentException("destination vertex is null");
        }
        OrientBaseGraph graph = this.getGraph();
        if (graph != null) {
            return graph.addEdgeInternal(this, label, inVertex, iClassName, iClusterName, fields);
        }
        return OrientGraphNoTx.addEdgeInternal(null, this, label, inVertex, iClassName, iClusterName, fields);
    }

    public long countEdges(Direction iDirection, String ... iLabels) {
        this.checkIfAttached();
        long counter = 0L;
        OrientBaseGraph.getEdgeClassNames(this.getGraph(), iLabels);
        OrientBaseGraph.encodeClassNames(iLabels);
        if (this.settings.isUseVertexFieldsForEdgeLabels() || iLabels == null || iLabels.length == 0) {
            ODocument doc = this.getRecord();
            for (String fieldName : doc.fieldNames()) {
                Object fieldValue;
                OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
                if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
                if (fieldValue instanceof Collection) {
                    counter += (long)((Collection)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof Map) {
                    counter += (long)((Map)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof ORidBag) {
                    counter += (long)((ORidBag)fieldValue).size();
                    continue;
                }
                ++counter;
            }
        } else {
            for (Edge e : this.getEdges(iDirection, iLabels)) {
                if (e == null) continue;
                ++counter;
            }
        }
        return counter;
    }

    public Iterable<Edge> getEdges(Direction iDirection, String ... iLabels) {
        return this.getEdges(null, iDirection, iLabels);
    }

    public Iterable<Edge> getEdges(OrientVertex iDestination, Direction iDirection, String ... iLabels) {
        this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        OrientBaseGraph.getEdgeClassNames(this.getGraph(), iLabels);
        OrientBaseGraph.encodeClassNames(iLabels);
        OMultiCollectionIterator iterable = new OMultiCollectionIterator().setEmbedded(true);
        for (OTriple<String, Direction, String> connectionField : this.getConnectionFields(iDirection, iLabels)) {
            OIdentifiable destinationVId;
            String fieldName = (String)((Object)connectionField.getKey());
            OPair connection = connectionField.getValue();
            Object fieldValue = doc.rawField(fieldName);
            if (fieldValue == null) continue;
            OIdentifiable oIdentifiable = destinationVId = iDestination != null ? (OIdentifiable)iDestination.getId() : null;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, (OPair<Direction, String>)connection, fieldValue, destinationVId, iLabels);
                continue;
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll.size() == 1) {
                    if (coll instanceof ORecordLazyMultiValue) {
                        this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, (OPair<Direction, String>)connection, ((ORecordLazyMultiValue)coll).rawIterator().next(), destinationVId, iLabels);
                        continue;
                    }
                    if (coll instanceof List) {
                        this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, (OPair<Direction, String>)connection, ((List)coll).get(0), destinationVId, iLabels);
                        continue;
                    }
                    this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, (OPair<Direction, String>)connection, coll.iterator().next(), destinationVId, iLabels);
                    continue;
                }
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add((Object)new OrientEdgeIterator(this, iDestination, coll, ((ORecordLazyMultiValue)coll).rawIterator(), (OPair<Direction, String>)connection, iLabels, coll.size()));
                    continue;
                }
                iterable.add((Object)new OrientEdgeIterator(this, iDestination, coll, coll.iterator(), (OPair<Direction, String>)connection, iLabels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add((Object)new OrientEdgeIterator(this, iDestination, fieldValue, ((ORidBag)fieldValue).rawIterator(), (OPair<Direction, String>)connection, iLabels, ((ORidBag)fieldValue).size()));
        }
        return iterable;
    }

    @Override
    public String getLabel() {
        String clsName;
        this.setCurrentGraphInThreadLocal();
        if (this.settings.isUseClassForVertexLabel() && !"V".equals(clsName = this.getRecord().getClassName())) {
            return clsName;
        }
        return (String)this.getRecord().field("label");
    }

    @Override
    public String getBaseClassName() {
        return "V";
    }

    @Override
    public String getElementType() {
        return "Vertex";
    }

    @Override
    public OrientVertexType getType() {
        OrientBaseGraph graph = this.getGraph();
        return new OrientVertexType(graph, this.getRecord().getSchemaClass());
    }

    public String toString() {
        this.setCurrentGraphInThreadLocal();
        ODocument record = this.getRecord();
        if (record == null) {
            return "<invalid record " + this.rawElement.getIdentity() + ">";
        }
        String clsName = record.getClassName();
        if ("V".equals(clsName)) {
            return StringFactory.vertexString((Vertex)this);
        }
        return "v(" + clsName + ")" + "[" + this.getId() + "]";
    }

    public String getConnectionClass(Direction iDirection, String iFieldName) {
        if (iDirection == Direction.OUT) {
            if (iFieldName.length() > CONNECTION_OUT_PREFIX.length()) {
                return iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
        } else if (iDirection == Direction.IN && iFieldName.length() > CONNECTION_IN_PREFIX.length()) {
            return iFieldName.substring(CONNECTION_IN_PREFIX.length());
        }
        return "E";
    }

    protected OPair<Direction, String> getConnection(Direction iDirection, String iFieldName, String ... iClassNames) {
        OrientEdgeType edgeType;
        String connClass;
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        OrientBaseGraph graph = this.getGraph();
        if (iDirection == Direction.OUT || iDirection == Direction.BOTH) {
            if (this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                    connClass = this.getConnectionClass(Direction.OUT, iFieldName);
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair((Comparable)Direction.OUT, (Object)connClass);
                    }
                    edgeType = graph.getEdgeType(connClass);
                    if (edgeType != null) {
                        for (String clsName : iClassNames) {
                            if (!edgeType.isSubClassOf(clsName)) continue;
                            return new OPair((Comparable)Direction.OUT, (Object)connClass);
                        }
                    }
                }
            } else if (iFieldName.equals("out")) {
                return new OPair((Comparable)Direction.OUT, null);
            }
        }
        if (iDirection == Direction.IN || iDirection == Direction.BOTH) {
            if (this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                    connClass = this.getConnectionClass(Direction.IN, iFieldName);
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair((Comparable)Direction.IN, (Object)connClass);
                    }
                    edgeType = graph.getEdgeType(connClass);
                    if (edgeType != null) {
                        for (String clsName : iClassNames) {
                            if (!edgeType.isSubClassOf(clsName)) continue;
                            return new OPair((Comparable)Direction.IN, (Object)connClass);
                        }
                    }
                }
            } else if (iFieldName.equals("in")) {
                return new OPair((Comparable)Direction.IN, null);
            }
        }
        return null;
    }

    private List<OTriple<String, Direction, String>> getConnectionFields(Direction iDirection, String ... iClassNames) {
        ODocument doc = this.getRecord();
        ArrayList<OTriple<String, Direction, String>> result = new ArrayList<OTriple<String, Direction, String>>();
        if (this.settings.isUseVertexFieldsForEdgeLabels()) {
            if (iClassNames == null || iClassNames.length == 0 || iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
                for (String string : doc.fieldNames()) {
                    OPair<Direction, String> connection = this.getConnection(iDirection, string, iClassNames);
                    if (connection == null) continue;
                    result.add((OTriple<String, Direction, String>)new OTriple((Comparable)((Object)string), connection.getKey(), connection.getValue()));
                }
            } else {
                OSchema schema = this.getGraph().getRawGraph().getMetadata().getSchema();
                HashSet<String> allClassNames = new HashSet<String>();
                for (String className : iClassNames) {
                    allClassNames.add(className);
                    OClass clazz = schema.getClass(className);
                    if (clazz == null) continue;
                    Collection subClasses = clazz.getAllSubclasses();
                    for (OClass subClass : subClasses) {
                        allClassNames.add(subClass.getName());
                    }
                }
                for (String string : allClassNames) {
                    switch (iDirection) {
                        case OUT: {
                            result.add((OTriple<String, Direction, String>)new OTriple((Comparable)((Object)(CONNECTION_OUT_PREFIX + string)), (Comparable)Direction.OUT, (Object)string));
                            break;
                        }
                        case IN: {
                            result.add((OTriple<String, Direction, String>)new OTriple((Comparable)((Object)(CONNECTION_IN_PREFIX + string)), (Comparable)Direction.IN, (Object)string));
                            break;
                        }
                        case BOTH: {
                            result.add((OTriple<String, Direction, String>)new OTriple((Comparable)((Object)(CONNECTION_OUT_PREFIX + string)), (Comparable)Direction.OUT, (Object)string));
                            result.add((OTriple<String, Direction, String>)new OTriple((Comparable)((Object)(CONNECTION_IN_PREFIX + string)), (Comparable)Direction.IN, (Object)string));
                        }
                    }
                }
            }
        } else if (iDirection == Direction.OUT) {
            result.add(new OTriple((Comparable)((Object)"out"), (Comparable)Direction.OUT, null));
        } else if (iDirection == Direction.IN) {
            result.add(new OTriple((Comparable)((Object)"in"), (Comparable)Direction.IN, null));
        } else {
            result.add(new OTriple((Comparable)((Object)"out"), (Comparable)Direction.OUT, null));
            result.add(new OTriple((Comparable)((Object)"in"), (Comparable)Direction.IN, null));
        }
        String[] fieldNames = new String[result.size()];
        int i = 0;
        for (OTriple oTriple : result) {
            fieldNames[i++] = (String)((Object)oTriple.getKey());
        }
        doc.deserializeFields(fieldNames);
        return result;
    }

    protected void addSingleEdge(ODocument doc, OMultiCollectionIterator<Edge> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientBaseGraph graph = this.getGraph();
        OrientEdge toAdd = OrientVertex.getEdge(graph, doc, fieldName, connection, fieldValue, iTargetVertex, iLabels);
        if (toAdd != null && (this.settings.isUseVertexFieldsForEdgeLabels() || toAdd.isLabeled(iLabels))) {
            iterable.add((Object)toAdd);
        }
    }

    boolean canCreateDynamicEdge(ODocument iFromVertex, ODocument iToVertex, String iOutFieldName, String iInFieldName, Object[] fields, String label) {
        this.checkIfAttached();
        OrientBaseGraph graph = this.getGraph();
        if (!this.settings.isUseVertexFieldsForEdgeLabels() && label != null) {
            return false;
        }
        if (this.settings.isUseLightweightEdges() && (fields == null || fields.length == 0 || fields[0] == null || fields[0] instanceof Map && ((Map)fields[0]).isEmpty())) {
            OrientEdgeType cls;
            Object field = iFromVertex.field(iOutFieldName);
            if (field != null && field instanceof Collection && ((Collection)field).contains(iToVertex)) {
                graph.getEdgeInstance((OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                return false;
            }
            field = iToVertex.field(iInFieldName);
            if (field != null && field instanceof Collection && ((Collection)field).contains(iFromVertex)) {
                graph.getEdgeInstance((OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                return false;
            }
            if (this.settings.isUseClassForEdgeLabel() && (cls = graph.getEdgeType(label)) != null) {
                for (OProperty p : cls.properties()) {
                    if (!p.isMandatory() && !p.isNotNull() && p.getOwnerClass().getInvolvedIndexes(new String[]{p.getName()}).isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void addSingleVertex(ODocument doc, OMultiCollectionIterator<Vertex> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, String[] iLabels) {
        OrientVertex toAdd;
        OrientBaseGraph graph = this.getGraph();
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        OImmutableClass klass = ODocumentInternal.getImmutableSchemaClass((ODocument)fieldRecord);
        if (klass == null && ODatabaseRecordThreadLocal.instance().getIfDefined() != null) {
            ODatabaseRecordThreadLocal.instance().getIfDefined().getMetadata().reload();
            klass = fieldRecord.getSchemaClass();
        }
        if (klass.isVertexType()) {
            toAdd = graph.getVertex(fieldRecord);
        } else if (klass.isEdgeType()) {
            if (this.settings.isUseVertexFieldsForEdgeLabels() || OrientEdge.isLabeled(OrientEdge.getRecordLabel((OIdentifiable)fieldRecord), iLabels)) {
                OIdentifiable vertexDoc = OrientEdge.getConnection(fieldRecord, ((Direction)connection.getKey()).opposite());
                if (vertexDoc == null) {
                    fieldRecord.reload();
                    vertexDoc = OrientEdge.getConnection(fieldRecord, ((Direction)connection.getKey()).opposite());
                    if (vertexDoc == null) {
                        OLogManager.instance().warn((Object)this, "Cannot load edge " + fieldRecord + " to get the " + ((Direction)connection.getKey()).opposite() + " vertex", new Object[0]);
                        return;
                    }
                }
                toAdd = graph.getVertex(vertexDoc);
            } else {
                toAdd = null;
            }
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        if (toAdd != null) {
            iterable.add((Object)toAdd);
        }
    }

    private Direction decodeODirection(ODirection direction) {
        if (direction == null) {
            return null;
        }
        switch (direction) {
            case OUT: {
                return Direction.OUT;
            }
            case IN: {
                return Direction.IN;
            }
            case BOTH: {
                return Direction.BOTH;
            }
        }
        return null;
    }

    private String[] toClassNames(OClass[] type) {
        if (type == null) {
            return null;
        }
        String[] result = new String[type.length];
        for (int i = 0; i < type.length; ++i) {
            result[i] = type[i].getName();
        }
        return result;
    }
}

