/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.orientechnologies.orient.graph.script.OScriptGraphOrientWrapper;
import com.orientechnologies.orient.graph.server.command.OServerCommandPostCommandGraph;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class OGraphServerHandler
extends OServerPluginAbstract
implements OScriptInjection {
    private boolean enabled = true;
    private int graphPoolMax;
    private OServer server;

    public void config(OServer server, OServerParameterConfiguration[] iParams) {
        this.graphPoolMax = server.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (!param.name.equalsIgnoreCase("graph.pool.max")) continue;
            this.graphPoolMax = Integer.parseInt(param.value);
        }
        if (OGremlinHelper.isGremlinAvailable()) {
            this.enabled = true;
            OLogManager.instance().info((Object)this, "Installed GREMLIN language v.%s - graph.pool.max=%d", new Object[]{OGremlinHelper.getEngineVersion(), this.graphPoolMax});
            Orient.instance().getScriptManager().registerInjection((OScriptInjection)this);
        } else {
            this.enabled = false;
        }
        this.server = server;
    }

    public String getName() {
        return "graph";
    }

    public void startup() {
        OServerNetworkListener listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (listener != null) {
            listener.registerStatelessCommand((OServerCommand)new OServerCommandPostCommandGraph());
        }
        if (!this.enabled) {
            return;
        }
        OGremlinHelper.global().setMaxGraphPool(this.graphPoolMax).create();
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        OGremlinHelper.global().destroy();
    }

    public void bind(ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        Object scriptGraph = binding.get("orient");
        if (scriptGraph == null || !(scriptGraph instanceof OScriptGraphOrientWrapper)) {
            binding.put("orient", (Object)new OScriptGraphOrientWrapper());
        }
    }

    public void unbind(ScriptEngine engine, Bindings binding) {
        binding.put("orient", (Object)null);
    }

    public void onAfterClientRequest(OClientConnection connection, byte requestType) {
        super.onAfterClientRequest(connection, requestType);
        OrientBaseGraph.clearInitStack();
    }
}

