/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.SegmentIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmenterFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmenterPrototypeBuiltins;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.EnumSet;
import java.util.Locale;

public final class JSSegmenter
extends JSBuiltinObject
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "Segmenter";
    public static final String PROTOTYPE_NAME = "Segmenter.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    public static final String ITERATOR_CLASS_NAME = "Segment Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Segment Iterator.prototype";
    public static final HiddenKey SEGMENT_ITERATOR_GRANULARITY_ID;
    public static final HiddenKey SEGMENT_ITERATOR_SEGMENTER_ID;
    public static final HiddenKey SEGMENT_ITERATOR_INDEX_ID;
    public static final HiddenKey SEGMENT_ITERATOR_BREAK_TYPE_ID;
    public static final Property ITERATED_OBJECT_PROPERTY;
    public static final Property SEGMENTER_PROPERTY;
    public static final Property ITER_GRANULARITY_PROPERTY;
    public static final Property BREAK_TYPE_PROPERTY;
    public static final Property INDEX_PROPERTY;
    public static final JSSegmenter INSTANCE;

    private JSSegmenter() {
    }

    public static boolean isJSSegmenter(Object obj) {
        return JSObject.isDynamicObject(obj) && JSSegmenter.isJSSegmenter((DynamicObject)obj);
    }

    public static boolean isJSSegmenter(DynamicObject obj) {
        return JSSegmenter.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject segmenterPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, segmenterPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, segmenterPrototype, SegmenterPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(ctx, segmenterPrototype, Symbol.SYMBOL_TO_STRING_TAG, "Intl.Segmenter", JSAttributes.configurableNotEnumerableNotWritable());
        return segmenterPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, SegmenterFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getSegmenterFactory(), state);
        assert (JSSegmenter.isJSSegmenter(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setLocale(JSContext ctx, InternalState state, String[] locales) {
        String selectedTag = IntlUtil.selectedLocale(ctx, locales);
        Locale selectedLocale = selectedTag != null ? Locale.forLanguageTag(selectedTag) : ctx.getLocale();
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        state.locale = strippedLocale.toLanguageTag();
        state.javaLocale = strippedLocale;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalBreakIterator(InternalState state, String granularity) {
        state.javaLocale = Locale.forLanguageTag(state.locale);
        switch (granularity) {
            case "grapheme": {
                state.granularity = Granularity.GRAPHEME;
                break;
            }
            case "word": {
                state.granularity = Granularity.WORD;
                break;
            }
            case "sentence": {
                state.granularity = Granularity.SENTENCE;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(String.format("Segmenter with granularity, %s, is not supported", granularity));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static BreakIterator createBreakIterator(DynamicObject segmenterObj, String text) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        ULocale ulocale = ULocale.forLocale((Locale)state.javaLocale);
        BreakIterator icuIterator = state.granularity.getIterator(ulocale);
        icuIterator.setText(text);
        return icuIterator;
    }

    public static Granularity getGranularity(DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        return state.granularity;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject segmenterObj) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(segmenterObj, JSSegmenter.isJSSegmenter(segmenterObj));
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSegmenterPrototype();
    }

    public static Shape makeInitialSegmentIteratorShape(JSContext ctx, DynamicObject prototype) {
        Shape iteratorShape = JSObjectUtil.getProtoChildShape(prototype, JSUserObject.INSTANCE, ctx);
        iteratorShape = iteratorShape.addProperty(ITERATED_OBJECT_PROPERTY);
        iteratorShape = iteratorShape.addProperty(SEGMENTER_PROPERTY);
        iteratorShape = iteratorShape.addProperty(ITER_GRANULARITY_PROPERTY);
        iteratorShape = iteratorShape.addProperty(BREAK_TYPE_PROPERTY);
        iteratorShape = iteratorShape.addProperty(INDEX_PROPERTY);
        return iteratorShape;
    }

    private static CallTarget createPropertyGetterCallTarget(JSContext context, final Property property) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private HasHiddenKeyCacheNode isSegmentIteratorNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.isSegmentIteratorNode = HasHiddenKeyCacheNode.create(SEGMENT_ITERATOR_GRANULARITY_ID);
            }

            public Object execute(VirtualFrame frame) {
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (this.isSegmentIteratorNode.executeHasHiddenKey(obj)) {
                    DynamicObject iteratorObj = (DynamicObject)obj;
                    Object result = property.get(iteratorObj, true);
                    return result == null ? Undefined.instance : result;
                }
                throw Errors.createTypeErrorTypeXExpected(JSSegmenter.ITERATOR_CLASS_NAME);
            }
        });
    }

    public static DynamicObject createSegmentIteratorPrototype(JSContext context, JSRealm realm) {
        DynamicObject prototype = JSObject.createInit(realm, realm.getIteratorPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SegmentIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(context, prototype, Symbol.SYMBOL_TO_STRING_TAG, ITERATOR_CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSFunctionData breakTypeFd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SegmeterBreakType, c -> {
            CallTarget ct = JSSegmenter.createPropertyGetterCallTarget(context, BREAK_TYPE_PROPERTY);
            return JSFunctionData.createCallOnly(c, ct, 0, "get breakType");
        });
        DynamicObject breakTypeGetter = JSFunction.create(realm, breakTypeFd);
        JSObjectUtil.putConstantAccessorProperty(context, prototype, "breakType", breakTypeGetter, Undefined.instance);
        JSFunctionData positionFd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SegmeterPosition, c -> JSFunctionData.createCallOnly(context, JSSegmenter.createPropertyGetterCallTarget(context, INDEX_PROPERTY), 0, "get index"));
        DynamicObject positionGetter = JSFunction.create(realm, positionFd);
        JSObjectUtil.putConstantAccessorProperty(context, prototype, "index", positionGetter, Undefined.instance);
        return prototype;
    }

    static {
        SEGMENT_ITERATOR_GRANULARITY_ID = new HiddenKey("granularity");
        SEGMENT_ITERATOR_SEGMENTER_ID = new HiddenKey("segmenter");
        SEGMENT_ITERATOR_INDEX_ID = new HiddenKey("index");
        SEGMENT_ITERATOR_BREAK_TYPE_ID = new HiddenKey("breakType");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
        Shape.Allocator iterAllocator = JSShape.makeAllocator(JSObject.LAYOUT);
        ITERATED_OBJECT_PROPERTY = JSObjectUtil.makeHiddenProperty(JSRuntime.ITERATED_OBJECT_ID, iterAllocator.locationForType(String.class));
        SEGMENTER_PROPERTY = JSObjectUtil.makeHiddenProperty(SEGMENT_ITERATOR_SEGMENTER_ID, iterAllocator.locationForType(BreakIterator.class));
        ITER_GRANULARITY_PROPERTY = JSObjectUtil.makeHiddenProperty(SEGMENT_ITERATOR_GRANULARITY_ID, iterAllocator.locationForType(Granularity.class));
        BREAK_TYPE_PROPERTY = JSObjectUtil.makeHiddenProperty(SEGMENT_ITERATOR_BREAK_TYPE_ID, iterAllocator.locationForType(String.class));
        INDEX_PROPERTY = JSObjectUtil.makeHiddenProperty(SEGMENT_ITERATOR_INDEX_ID, iterAllocator.locationForType(Integer.class));
        INSTANCE = new JSSegmenter();
    }

    public static class InternalState {
        private boolean initialized = false;
        private String locale;
        private Locale javaLocale;
        public Granularity granularity = Granularity.GRAPHEME;

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSUserObject.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "granularity", this.granularity.getName(), JSAttributes.getDefault());
            return result;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }
    }

    public static enum Granularity implements IcuIteratorHelper
    {
        GRAPHEME("grapheme"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getCharacterInstance((ULocale)locale);
            }

            @Override
            public String getBreakType(int icuStatus) {
                return null;
            }
        }
        ,
        WORD("word"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getWordInstance((ULocale)locale);
            }

            @Override
            public String getBreakType(int icuStatus) {
                return icuStatus == 0 ? "none" : "word";
            }
        }
        ,
        SENTENCE("sentence"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getSentenceInstance((ULocale)locale);
            }

            @Override
            public String getBreakType(int icuStatus) {
                return icuStatus == 0 ? "sep" : "term";
            }
        };

        private String name;

        private Granularity(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static interface IcuIteratorHelper {
        public BreakIterator getIterator(ULocale var1);

        public String getBreakType(int var1);
    }
}

