/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceFieldsNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import com.oracle.truffle.js.nodes.function.DefineMethodNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Null;

public class ClassDefinitionNode
extends JavaScriptNode
implements FunctionNameHolder {
    private final JSContext context;
    @Node.Child
    private JavaScriptNode constructorFunctionNode;
    @Node.Child
    private JavaScriptNode classHeritageNode;
    @Node.Children
    private final ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes;
    @Node.Child
    private PropertyGetNode getPrototypeNode;
    @Node.Child
    private CreateMethodPropertyNode setConstructorNode;
    @Node.Child
    private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
    @Node.Child
    private DefineMethodNode defineConstructorMethodNode;
    @Node.Child
    private PropertySetNode setFieldsNode;
    @Node.Child
    private InitializeInstanceFieldsNode staticFieldsNode;
    private final boolean hasName;
    private final int instanceFieldCount;
    private final int staticFieldCount;

    protected ClassDefinitionNode(JSContext context, JSFunctionExpressionNode constructorFunctionNode, JavaScriptNode classHeritageNode, ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes, boolean hasName, int instanceFieldCount, int staticFieldCount) {
        this.context = context;
        this.constructorFunctionNode = constructorFunctionNode;
        this.classHeritageNode = classHeritageNode;
        this.memberNodes = memberNodes;
        this.hasName = hasName;
        this.instanceFieldCount = instanceFieldCount;
        this.staticFieldCount = staticFieldCount;
        this.getPrototypeNode = PropertyGetNode.create("prototype", false, context);
        this.setConstructorNode = CreateMethodPropertyNode.create(context, "constructor");
        this.createObjectNode = CreateObjectNode.createWithPrototype(context, null);
        this.defineConstructorMethodNode = DefineMethodNode.create(context, constructorFunctionNode);
        this.setFieldsNode = instanceFieldCount != 0 ? PropertySetNode.createSetHidden(JSFunction.CLASS_FIELDS_ID, context) : null;
    }

    public static ClassDefinitionNode create(JSContext context, JSFunctionExpressionNode constructorFunction, JavaScriptNode classHeritage, ObjectLiteralNode.ObjectLiteralMemberNode[] members, boolean hasName, int instanceFieldCount, int staticFieldCount) {
        return new ClassDefinitionNode(context, constructorFunction, classHeritage, members, hasName, instanceFieldCount, staticFieldCount);
    }

    public DynamicObject execute(VirtualFrame frame) {
        JSRealm realm = this.context.getRealm();
        Object protoParent = realm.getObjectPrototype();
        Object constructorParent = realm.getFunctionPrototype();
        if (this.classHeritageNode != null) {
            Object superclass = this.classHeritageNode.execute(frame);
            if (superclass == Null.instance) {
                protoParent = Null.instance;
            } else {
                if (!JSRuntime.isConstructor(superclass)) {
                    throw Errors.createTypeError("not a constructor", this);
                }
                if (JSRuntime.isGenerator(superclass)) {
                    throw Errors.createTypeError("class cannot extend a generator function", this);
                }
                protoParent = this.getPrototypeNode.getValue(superclass);
                if (protoParent != Null.instance && !JSRuntime.isObject(protoParent)) {
                    throw Errors.createTypeError("protoParent is neither Object nor Null", this);
                }
                constructorParent = superclass;
            }
        }
        DynamicObject proto = this.createObjectNode.executeDynamicObject(frame, (DynamicObject)protoParent);
        DynamicObject constructor = this.defineConstructorMethodNode.execute(frame, proto, (DynamicObject)constructorParent);
        JSFunction.setClassPrototype(constructor, proto);
        this.setConstructorNode.executeVoid(proto, constructor);
        Object[][] instanceFields = this.instanceFieldCount == 0 ? (Object[][])null : new Object[this.instanceFieldCount][];
        Object[][] staticFields = this.staticFieldCount == 0 ? (Object[][])null : new Object[this.staticFieldCount][];
        this.initializeMembers(frame, proto, constructor, instanceFields, staticFields);
        if (this.setFieldsNode != null) {
            this.setFieldsNode.setValue(constructor, instanceFields);
        }
        if (this.staticFieldCount != 0) {
            InitializeInstanceFieldsNode defineStaticFields = this.staticFieldsNode;
            if (defineStaticFields == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.staticFieldsNode = defineStaticFields = InitializeInstanceFieldsNode.create(this.context);
            }
            defineStaticFields.executeEvaluated(constructor, staticFields);
        }
        return constructor;
    }

    @ExplodeLoop
    private void initializeMembers(VirtualFrame frame, DynamicObject proto, DynamicObject constructor, Object[][] instanceFields, Object[][] staticFields) {
        int instanceFieldIndex = 0;
        int staticFieldIndex = 0;
        for (ObjectLiteralNode.ObjectLiteralMemberNode memberNode : this.memberNodes) {
            DynamicObject homeObject;
            DynamicObject dynamicObject = homeObject = memberNode.isStatic() ? constructor : proto;
            if (memberNode.isField()) {
                Object key = memberNode.executeKey(frame);
                Object value = memberNode.executeValue(frame, homeObject);
                Object[] field = new Object[]{key, value, memberNode.isAnonymousFunctionDefinition()};
                if (memberNode.isStatic()) {
                    staticFields[staticFieldIndex++] = field;
                    continue;
                }
                instanceFields[instanceFieldIndex++] = field;
                continue;
            }
            memberNode.executeVoid(frame, homeObject, this.context);
        }
        assert (instanceFieldIndex == this.instanceFieldCount && staticFieldIndex == this.staticFieldCount);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == DynamicObject.class;
    }

    @Override
    public String getFunctionName() {
        return this.hasName ? ((FunctionNameHolder)((Object)this.constructorFunctionNode)).getFunctionName() : "";
    }

    @Override
    public void setFunctionName(String name) {
        ((FunctionNameHolder)((Object)this.constructorFunctionNode)).setFunctionName(name);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return ClassDefinitionNode.create(this.context, (JSFunctionExpressionNode)ClassDefinitionNode.cloneUninitialized(this.constructorFunctionNode), ClassDefinitionNode.cloneUninitialized(this.classHeritageNode), ObjectLiteralNode.ObjectLiteralMemberNode.cloneUninitialized(this.memberNodes), this.hasName, this.instanceFieldCount, this.staticFieldCount);
    }
}

