/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNodeGen;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class InstanceofNode
extends JSBinaryNode {
    protected final JSContext context;
    @Node.Child
    private OrdinaryHasInstanceNode ordinaryHasInstanceNode;

    protected InstanceofNode(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
        this.context = context;
    }

    public static InstanceofNode create(JSContext context) {
        return InstanceofNode.create(context, null, null);
    }

    public static InstanceofNode create(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        return InstanceofNodeGen.create(context, left, right);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    GetMethodNode createGetMethodHasInstance() {
        return GetMethodNode.create(this.context, null, Symbol.SYMBOL_HAS_INSTANCE);
    }

    @Specialization
    protected boolean doGeneric(Object obj, DynamicObject target, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="createGetMethodHasInstance()") GetMethodNode getMethodHasInstanceNode, @Cached(value="create()") JSToBooleanNode toBooleanNode, @Cached(value="createCall()") JSFunctionCallNode callHasInstanceNode, @Cached(value="createBinaryProfile()") ConditionProfile hasInstanceProfile, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="create()") BranchProfile proxyBranch) {
        if (!isObjectNode.executeBoolean(target)) {
            errorBranch.enter();
            throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
        }
        Object hasInstance = getMethodHasInstanceNode.executeWithTarget(target);
        if (hasInstanceProfile.profile(hasInstance != Undefined.instance)) {
            Object res = callHasInstanceNode.executeCall(JSArguments.createOneArg(target, hasInstance, obj));
            return toBooleanNode.executeBoolean(res);
        }
        if (!InstanceofNode.isCallable(target, proxyBranch)) {
            errorBranch.enter();
            throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
        }
        if (this.ordinaryHasInstanceNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ordinaryHasInstanceNode = (OrdinaryHasInstanceNode)this.insert(OrdinaryHasInstanceNode.create(this.context));
        }
        return this.ordinaryHasInstanceNode.executeBoolean(obj, target);
    }

    private static boolean isCallable(DynamicObject target, BranchProfile proxyBranch) {
        if (JSFunction.isJSFunction(target)) {
            return true;
        }
        if (JSProxy.isProxy(target)) {
            proxyBranch.enter();
            return JSRuntime.isCallableProxy(target);
        }
        return false;
    }

    @Specialization(guards={"!isJavaObject(obj)", "isJavaInteropClass(clazz)"})
    protected boolean instanceofJavaClass(Object obj, Object clazz) {
        TruffleLanguage.Env env = this.context.getRealm().getEnv();
        return ((Class)env.asHostObject(clazz)).isInstance(obj);
    }

    @Specialization(guards={"isJavaObject(obj)", "isJavaInteropClass(clazz)"})
    protected boolean instanceofJavaClassUnwrap(Object obj, Object clazz) {
        TruffleLanguage.Env env = this.context.getRealm().getEnv();
        return ((Class)env.asHostObject(clazz)).isInstance(env.asHostObject(obj));
    }

    protected final boolean isJavaObject(Object obj) {
        TruffleLanguage.Env env = this.context.getRealm().getEnv();
        return env.isHostObject(obj);
    }

    protected final boolean isJavaInteropClass(Object obj) {
        TruffleLanguage.Env env = this.context.getRealm().getEnv();
        return env.isHostObject(obj) && env.asHostObject(obj) instanceof Class;
    }

    @Specialization(guards={"!isDynamicObject(target)"})
    protected boolean doRHSNotAnObject(Object obj, Object target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @CompilerDirectives.TruffleBoundary
    private static String functionToString(DynamicObject fnObj) {
        assert (JSFunction.isJSFunction(fnObj));
        RootCallTarget dct = (RootCallTarget)JSFunction.getCallTarget(fnObj);
        RootNode rn = dct.getRootNode();
        SourceSection ssect = rn.getSourceSection();
        return ssect == null || !ssect.isAvailable() ? "function " + JSFunction.getName(fnObj) + "() { [native code] }" : ssect.getCharacters().toString();
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return InstanceofNodeGen.create(this.context, InstanceofNode.cloneUninitialized(this.getLeft()), InstanceofNode.cloneUninitialized(this.getRight()));
    }

    public static abstract class IsBoundFunctionCacheNode
    extends JavaScriptBaseNode {
        final boolean multiContext;

        public abstract boolean executeBoolean(DynamicObject var1);

        protected IsBoundFunctionCacheNode(boolean multiContext) {
            this.multiContext = multiContext;
        }

        public static IsBoundFunctionCacheNode create(JSContext context) {
            return InstanceofNodeGen.IsBoundFunctionCacheNodeGen.create(context.isMultiContext());
        }

        @Specialization(guards={"!multiContext", "func == cachedFunction"}, limit="1")
        protected static boolean doCachedInstance(DynamicObject func, @Cached(value="func") DynamicObject cachedFunction, @Cached(value="isBoundFunction(func)") boolean cachedIsBound) {
            assert (IsBoundFunctionCacheNode.isBoundFunction(func) == cachedIsBound);
            return cachedIsBound;
        }

        @Specialization(guards={"cachedShape.check(func)"}, replaces={"doCachedInstance"})
        protected static boolean doCachedShape(DynamicObject func, @Cached(value="func.getShape()") Shape cachedShape, @Cached(value="isBoundFunction(func)") boolean cachedIsBound) {
            assert (IsBoundFunctionCacheNode.isBoundFunction(func) == cachedIsBound);
            return cachedIsBound;
        }

        @Specialization(replaces={"doCachedShape"})
        protected static boolean isBoundFunction(DynamicObject func) {
            assert (JSFunction.isJSFunction(func));
            return JSFunction.isBoundFunction(func);
        }
    }

    public static abstract class OrdinaryHasInstanceNode
    extends JavaScriptBaseNode {
        protected final JSContext context;
        @CompilerDirectives.CompilationFinal
        private boolean lessThan4 = true;
        @Node.Child
        private PropertyGetNode getPrototypeNode;
        @Node.Child
        private IsBoundFunctionCacheNode boundFuncCacheNode;
        @Node.Child
        private IsJSObjectNode isObjectNode;

        public abstract boolean executeBoolean(Object var1, Object var2);

        protected OrdinaryHasInstanceNode(JSContext context) {
            this.context = context;
            this.boundFuncCacheNode = IsBoundFunctionCacheNode.create(context);
        }

        public static OrdinaryHasInstanceNode create(JSContext context) {
            return InstanceofNodeGen.OrdinaryHasInstanceNodeGen.create(context);
        }

        boolean isObjectLocal(DynamicObject lhs) {
            if (this.isObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isObjectNode = (IsJSObjectNode)this.insert(IsJSObjectNode.create());
            }
            return this.isObjectNode.executeBoolean(lhs);
        }

        private DynamicObject getConstructorPrototype(DynamicObject rhs, BranchProfile invalidPrototypeBranch) {
            Object proto;
            if (this.getPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getPrototypeNode = (PropertyGetNode)this.insert(PropertyGetNode.create("prototype", this.context));
            }
            if (!JSRuntime.isObject(proto = this.getPrototypeNode.getValue(rhs))) {
                invalidPrototypeBranch.enter();
                throw this.createTypeErrorInvalidPrototype(rhs, proto);
            }
            return (DynamicObject)proto;
        }

        @Specialization(guards={"!isCallable(check)"})
        protected boolean doNotCallable(Object obj, Object check) {
            return false;
        }

        @Specialization(guards={"isJSFunction(check)", "isBoundFunction(check)"})
        protected boolean doIsBound(Object obj, DynamicObject check, @Cached(value="create(context)") InstanceofNode instanceofNode) {
            DynamicObject boundTargetFunction = JSFunction.getBoundTargetFunction(check);
            return instanceofNode.executeBoolean(obj, boundTargetFunction);
        }

        @Specialization(guards={"!isJSObject(left)", "isJSFunction(right)", "!isBoundFunction(right)"})
        protected boolean doNotAnObject(Object left, DynamicObject right) {
            return false;
        }

        @Specialization(guards={"!isJSObject(left)", "isJSProxy(right)", "isCallableProxy(right)"})
        protected boolean doNotAnObjectProxy(Object left, DynamicObject right) {
            return false;
        }

        @Specialization(guards={"isObjectLocal(left)", "isJSFunction(right)", "!isBoundFunction(right)"})
        protected boolean doJSObject(DynamicObject left, DynamicObject right, @Cached(value="create()") GetPrototypeNode getPrototype1Node, @Cached(value="create()") GetPrototypeNode getPrototype2Node, @Cached(value="create()") GetPrototypeNode getPrototype3Node, @Cached(value="create()") BranchProfile firstTrue, @Cached(value="create()") BranchProfile firstFalse, @Cached(value="create()") BranchProfile need2Hops, @Cached(value="create()") BranchProfile need3Hops, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="create()") BranchProfile invalidPrototypeBranch) {
            DynamicObject ctorPrototype = this.getConstructorPrototype(right, invalidPrototypeBranch);
            if (this.lessThan4) {
                DynamicObject proto = getPrototype1Node.executeJSObject(left);
                if (proto == ctorPrototype) {
                    firstTrue.enter();
                    return true;
                }
                if (proto == Null.instance) {
                    firstFalse.enter();
                    return false;
                }
                need2Hops.enter();
                proto = getPrototype2Node.executeJSObject(proto);
                if (proto == ctorPrototype) {
                    return true;
                }
                if (proto == Null.instance) {
                    return false;
                }
                need3Hops.enter();
                proto = getPrototype3Node.executeJSObject(proto);
                if (proto == ctorPrototype) {
                    return true;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lessThan4 = false;
            }
            return OrdinaryHasInstanceNode.doJSObject4(left, ctorPrototype, getPrototype3Node, errorBranch);
        }

        @Specialization(guards={"isObjectLocal(left)", "isJSProxy(right)", "isCallableProxy(right)"})
        protected boolean doJSObjectProxy(DynamicObject left, DynamicObject right, @Cached(value="create()") GetPrototypeNode getPrototype1Node, @Cached(value="create()") GetPrototypeNode getPrototype2Node, @Cached(value="create()") GetPrototypeNode getPrototype3Node, @Cached(value="create()") BranchProfile firstTrue, @Cached(value="create()") BranchProfile firstFalse, @Cached(value="create()") BranchProfile need2Hops, @Cached(value="create()") BranchProfile need3Hops, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="create()") BranchProfile invalidPrototypeBranch) {
            return this.doJSObject(left, right, getPrototype1Node, getPrototype2Node, getPrototype3Node, firstTrue, firstFalse, need2Hops, need3Hops, errorBranch, invalidPrototypeBranch);
        }

        private static boolean doJSObject4(DynamicObject obj, DynamicObject check, GetPrototypeNode getPrototypeNode, BranchProfile errorBranch) {
            DynamicObject proto = obj;
            int counter = 0;
            while ((proto = getPrototypeNode.executeJSObject(proto)) != Null.instance) {
                if (++counter > JSTruffleOptions.MaxExpectedPrototypeChainLength) {
                    errorBranch.enter();
                    throw Errors.createRangeError("prototype chain length exceeded");
                }
                if (proto != check) continue;
                return true;
            }
            return false;
        }

        protected boolean isBoundFunction(DynamicObject func) {
            assert (JSFunction.isJSFunction(func));
            return this.boundFuncCacheNode.executeBoolean(func);
        }

        @CompilerDirectives.TruffleBoundary
        private JSException createTypeErrorInvalidPrototype(DynamicObject obj, Object proto) {
            return Errors.createTypeError("\"prototype\" of " + JSRuntime.safeToString(obj) + " is not an Object, it is " + JSRuntime.safeToString(proto), this);
        }
    }
}

