/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldSetNodeGen;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;

public abstract class PrivateFieldSetNode
extends JSTargetableNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode keyNode;
    @Node.Child
    @Executed
    protected JavaScriptNode valueNode;
    protected final JSContext context;

    public static PrivateFieldSetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        return PrivateFieldSetNodeGen.create(targetNode, keyNode, valueNode, context);
    }

    protected PrivateFieldSetNode(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        this.targetNode = targetNode;
        this.keyNode = keyNode;
        this.valueNode = valueNode;
        this.context = context;
    }

    public abstract Object execute(Object var1, Object var2, Object var3);

    @Specialization(guards={"key == cachedKey", "isJSObject(target)"}, limit="1")
    Object doCachedKey(DynamicObject target, HiddenKey key, Object value, @Cached(value="key") HiddenKey cachedKey, @Cached(value="create(key)") HasHiddenKeyCacheNode hasNode, @Cached(value="createSetHidden(key, context)") PropertySetNode setNode) {
        if (hasNode.executeHasHiddenKey(target)) {
            setNode.setValue(target, value);
        } else {
            this.missing(key);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJSObject(target)"}, replaces={"doCachedKey"})
    Object doUncachedKey(DynamicObject target, HiddenKey key, Object value) {
        if (!target.set((Object)key, value)) {
            this.missing(key);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    private Object missing(HiddenKey key) {
        throw Errors.createTypeErrorCannotSetPrivateMember(key.getName(), this);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    Object doFallback(Object target, Object key, Object value) {
        throw Errors.createTypeErrorCannotSetProperty(this.keyAsString(), target, this);
    }

    @CompilerDirectives.TruffleBoundary
    private String keyAsString() {
        return this.keyNode.expressionToString();
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return PrivateFieldSetNode.create(PrivateFieldSetNode.cloneUninitialized(this.targetNode), PrivateFieldSetNode.cloneUninitialized(this.keyNode), PrivateFieldSetNode.cloneUninitialized(this.valueNode), this.context);
    }
}

