/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.PropertyReference;

@GeneratedBy(value=JSTypes.class)
public final class JSTypesGen
extends JSTypes {
    @Deprecated
    public static final JSTypesGen J_S_TYPES = new JSTypesGen();

    protected JSTypesGen() {
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean asBoolean(Object value) {
        assert (value instanceof Boolean) : "JSTypesGen.asBoolean: boolean expected";
        return (Boolean)value;
    }

    public static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer;
    }

    public static int asInteger(Object value) {
        assert (value instanceof Integer) : "JSTypesGen.asInteger: int expected";
        return (Integer)value;
    }

    public static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isDouble(Object value) {
        return value instanceof Double;
    }

    public static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return JSTypes.asDouble(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLong(Object value) {
        return value instanceof Long;
    }

    public static long asLong(Object value) {
        assert (value instanceof Long) : "JSTypesGen.asLong: long expected";
        return (Long)value;
    }

    public static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLargeInteger(Object value) {
        return value instanceof LargeInteger;
    }

    public static LargeInteger asLargeInteger(Object value) {
        assert (value instanceof LargeInteger) : "JSTypesGen.asLargeInteger: LargeInteger expected";
        return (LargeInteger)value;
    }

    public static LargeInteger expectLargeInteger(Object value) throws UnexpectedResultException {
        if (value instanceof LargeInteger) {
            return (LargeInteger)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isBigInt(Object value) {
        return value instanceof BigInt;
    }

    public static BigInt asBigInt(Object value) {
        assert (value instanceof BigInt) : "JSTypesGen.asBigInt: BigInt expected";
        return (BigInt)value;
    }

    public static BigInt expectBigInt(Object value) throws UnexpectedResultException {
        if (value instanceof BigInt) {
            return (BigInt)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isString(Object value) {
        return value instanceof String;
    }

    public static String asString(Object value) {
        assert (value instanceof String) : "JSTypesGen.asString: String expected";
        return (String)value;
    }

    public static String expectString(Object value) throws UnexpectedResultException {
        if (value instanceof String) {
            return (String)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static DynamicObject asDynamicObject(Object value) {
        assert (JSTypes.isDynamicObject(value)) : "JSTypesGen.asDynamicObject: DynamicObject expected";
        return (DynamicObject)value;
    }

    public static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
        if (JSTypes.isDynamicObject(value)) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isObjectArray(Object value) {
        return value instanceof Object[];
    }

    public static Object[] asObjectArray(Object value) {
        assert (value instanceof Object[]) : "JSTypesGen.asObjectArray: Object[] expected";
        return (Object[])value;
    }

    public static Object[] expectObjectArray(Object value) throws UnexpectedResultException {
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        throw new UnexpectedResultException(value);
    }

    public static double expectImplicitDouble(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof Long) {
            return JSTypesGen.longToDouble((Long)value);
        }
        if ((state & 2) != 0 && value instanceof Integer) {
            return JSTypesGen.intToDouble((Integer)value);
        }
        if ((state & 4) != 0 && value instanceof Double) {
            return JSTypes.asDouble(value);
        }
        if ((state & 8) != 0 && value instanceof LargeInteger) {
            return JSTypesGen.largeIntegerToDouble((LargeInteger)value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitDouble(int state, Object value) {
        return (state & 1) != 0 && value instanceof Long || (state & 2) != 0 && value instanceof Integer || (state & 4) != 0 && value instanceof Double || (state & 8) != 0 && value instanceof LargeInteger;
    }

    public static boolean isImplicitDouble(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Double || value instanceof LargeInteger;
    }

    public static double asImplicitDouble(int state, Object value) {
        if ((state & 1) != 0 && value instanceof Long) {
            return JSTypesGen.longToDouble((Long)value);
        }
        if ((state & 2) != 0 && value instanceof Integer) {
            return JSTypesGen.intToDouble((Integer)value);
        }
        if ((state & 4) != 0 && value instanceof Double) {
            return JSTypes.asDouble(value);
        }
        if ((state & 8) != 0 && value instanceof LargeInteger) {
            return JSTypesGen.largeIntegerToDouble((LargeInteger)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static double asImplicitDouble(Object value) {
        if (value instanceof Long) {
            return JSTypesGen.longToDouble((Long)value);
        }
        if (value instanceof Integer) {
            return JSTypesGen.intToDouble((Integer)value);
        }
        if (value instanceof Double) {
            return JSTypes.asDouble(value);
        }
        if (value instanceof LargeInteger) {
            return JSTypesGen.largeIntegerToDouble((LargeInteger)value);
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitDouble(Object value) {
        if (value instanceof Long) {
            return 1;
        }
        if (value instanceof Integer) {
            return 2;
        }
        if (value instanceof Double) {
            return 4;
        }
        if (value instanceof LargeInteger) {
            return 8;
        }
        return 0;
    }

    public static String expectImplicitString(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof String) {
            return (String)value;
        }
        if ((state & 2) != 0 && value instanceof PropertyReference) {
            return JSTypesGen.castString((PropertyReference)value);
        }
        if ((state & 4) != 0 && JSTypes.isLazyStringRaw(value)) {
            return JSTypesGen.convertLazyStringRaw(JSTypes.asLazyStringRaw(value));
        }
        if ((state & 8) != 0 && JSTypes.isLazyStringFlattened(value)) {
            return JSTypesGen.convertLazyStringFlattened(JSTypes.asLazyStringFlattened(value));
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitString(int state, Object value) {
        return (state & 1) != 0 && value instanceof String || (state & 2) != 0 && value instanceof PropertyReference || (state & 4) != 0 && JSTypes.isLazyStringRaw(value) || (state & 8) != 0 && JSTypes.isLazyStringFlattened(value);
    }

    public static boolean isImplicitString(Object value) {
        return value instanceof String || value instanceof PropertyReference || JSTypes.isLazyStringRaw(value) || JSTypes.isLazyStringFlattened(value);
    }

    public static String asImplicitString(int state, Object value) {
        if ((state & 1) != 0 && value instanceof String) {
            return (String)value;
        }
        if ((state & 2) != 0 && value instanceof PropertyReference) {
            return JSTypesGen.castString((PropertyReference)value);
        }
        if ((state & 4) != 0 && JSTypes.isLazyStringRaw(value)) {
            return JSTypesGen.convertLazyStringRaw(JSTypes.asLazyStringRaw(value));
        }
        if ((state & 8) != 0 && JSTypes.isLazyStringFlattened(value)) {
            return JSTypesGen.convertLazyStringFlattened(JSTypes.asLazyStringFlattened(value));
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static String asImplicitString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof PropertyReference) {
            return JSTypesGen.castString((PropertyReference)value);
        }
        if (JSTypes.isLazyStringRaw(value)) {
            return JSTypesGen.convertLazyStringRaw(JSTypes.asLazyStringRaw(value));
        }
        if (JSTypes.isLazyStringFlattened(value)) {
            return JSTypesGen.convertLazyStringFlattened(JSTypes.asLazyStringFlattened(value));
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitString(Object value) {
        if (value instanceof String) {
            return 1;
        }
        if (value instanceof PropertyReference) {
            return 2;
        }
        if (JSTypes.isLazyStringRaw(value)) {
            return 4;
        }
        if (JSTypes.isLazyStringFlattened(value)) {
            return 8;
        }
        return 0;
    }

    public static CharSequence expectImplicitCharSequence(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof String) {
            return JSTypesGen.castCharSequence((String)value);
        }
        if ((state & 2) != 0 && value instanceof PropertyReference) {
            return JSTypesGen.castCharSequence((PropertyReference)value);
        }
        if ((state & 4) != 0 && value instanceof JSLazyString) {
            return JSTypesGen.castCharSequence((JSLazyString)value);
        }
        if ((state & 8) != 0 && JSTypes.isCharSequence(value)) {
            return (CharSequence)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitCharSequence(int state, Object value) {
        return (state & 1) != 0 && value instanceof String || (state & 2) != 0 && value instanceof PropertyReference || (state & 4) != 0 && value instanceof JSLazyString || (state & 8) != 0 && JSTypes.isCharSequence(value);
    }

    public static boolean isImplicitCharSequence(Object value) {
        return value instanceof String || value instanceof PropertyReference || value instanceof JSLazyString || JSTypes.isCharSequence(value);
    }

    public static CharSequence asImplicitCharSequence(int state, Object value) {
        if ((state & 1) != 0 && value instanceof String) {
            return JSTypesGen.castCharSequence((String)value);
        }
        if ((state & 2) != 0 && value instanceof PropertyReference) {
            return JSTypesGen.castCharSequence((PropertyReference)value);
        }
        if ((state & 4) != 0 && value instanceof JSLazyString) {
            return JSTypesGen.castCharSequence((JSLazyString)value);
        }
        if ((state & 8) != 0 && JSTypes.isCharSequence(value)) {
            return (CharSequence)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static CharSequence asImplicitCharSequence(Object value) {
        if (value instanceof String) {
            return JSTypesGen.castCharSequence((String)value);
        }
        if (value instanceof PropertyReference) {
            return JSTypesGen.castCharSequence((PropertyReference)value);
        }
        if (value instanceof JSLazyString) {
            return JSTypesGen.castCharSequence((JSLazyString)value);
        }
        if (JSTypes.isCharSequence(value)) {
            return (CharSequence)value;
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitCharSequence(Object value) {
        if (value instanceof String) {
            return 1;
        }
        if (value instanceof PropertyReference) {
            return 2;
        }
        if (value instanceof JSLazyString) {
            return 4;
        }
        if (JSTypes.isCharSequence(value)) {
            return 8;
        }
        return 0;
    }
}

