/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.simd.SIMDTypeFunctionBuiltins;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.SIMDType;

public final class SIMDFloatFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<SIMDTypeFunction> {
    protected final SIMDType simdContext;

    public SIMDFloatFunctionBuiltins(String typeName, SIMDType simdContext) {
        super(typeName, SIMDTypeFunction.class);
        this.simdContext = simdContext;
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SIMDTypeFunction builtinEnum) {
        switch (builtinEnum) {
            case abs: {
                return SIMDTypeFunctionBuiltins.SIMDAbsNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case add: {
                return SIMDTypeFunctionBuiltins.SIMDAddNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case check: {
                return SIMDTypeFunctionBuiltins.SIMDCheckNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case div: {
                return SIMDTypeFunctionBuiltins.SIMDDivNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case equal: {
                return SIMDTypeFunctionBuiltins.SIMDEqualNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case extractLane: {
                return SIMDTypeFunctionBuiltins.SIMDExtractLaneNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromInt32x4Bits: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.INT32X4_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromUint32x4Bits: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.UINT32X4_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromInt16x8Bits: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.INT16X8_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromUint16x8Bits: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.UINT16X8_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromInt8x16Bits: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.INT8X16_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromUint8x16Bits: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.UINT8X16_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromInt32x4: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.INT32X4_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromUint32x4: {
                return SIMDTypeFunctionBuiltins.SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.UINT32X4_FACTORY.createSimdType(), SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case greaterThan: {
                return SIMDTypeFunctionBuiltins.SIMDGreaterThanNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case greaterThanOrEqual: {
                return SIMDTypeFunctionBuiltins.SIMDGreaterThanOrEqualNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case lessThan: {
                return SIMDTypeFunctionBuiltins.SIMDLessThanNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case lessThanOrEqual: {
                return SIMDTypeFunctionBuiltins.SIMDLessThanOrEqualNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load1: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, 1, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load2: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, 2, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load3: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, 3, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case max: {
                return SIMDTypeFunctionBuiltins.SIMDMaxNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case maxNum: {
                return SIMDTypeFunctionBuiltins.SIMDMaxNumNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case min: {
                return SIMDTypeFunctionBuiltins.SIMDMinNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case minNum: {
                return SIMDTypeFunctionBuiltins.SIMDMinNumNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case mul: {
                return SIMDTypeFunctionBuiltins.SIMDMulNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case neg: {
                return SIMDTypeFunctionBuiltins.SIMDNegNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case notEqual: {
                return SIMDTypeFunctionBuiltins.SIMDNotEqualNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case reciprocalApproximation: {
                return SIMDTypeFunctionBuiltins.SIMDreciprocalApproximationNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case reciprocalSqrtApproximation: {
                return SIMDTypeFunctionBuiltins.SIMDreciprocalSqrtApproximationNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case replaceLane: {
                return SIMDTypeFunctionBuiltins.SIMDReplaceLaneNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case select: {
                return SIMDTypeFunctionBuiltins.SIMDSelectNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case shuffle: {
                return SIMDTypeFunctionBuiltins.SIMDShuffleNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case splat: {
                return SIMDTypeFunctionBuiltins.SIMDSplatNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case sqrt: {
                return SIMDTypeFunctionBuiltins.SIMDSqrtNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case store: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store1: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, 1, SIMDFloatFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store2: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, 2, SIMDFloatFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store3: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, 3, SIMDFloatFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case sub: {
                return SIMDTypeFunctionBuiltins.SIMDSubNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case swizzle: {
                return SIMDTypeFunctionBuiltins.SIMDSwizzleNode.create(context, builtin, this.simdContext, SIMDFloatFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum SIMDTypeFunction implements BuiltinEnum<SIMDTypeFunction>
    {
        splat(1),
        check(1),
        add(2),
        sub(2),
        mul(2),
        div(2),
        max(2),
        min(2),
        maxNum(2),
        minNum(2),
        neg(1),
        sqrt(1),
        reciprocalApproximation(1),
        reciprocalSqrtApproximation(1),
        abs(1),
        lessThan(2),
        lessThanOrEqual(2),
        greaterThan(2),
        greaterThanOrEqual(2),
        equal(2),
        notEqual(2),
        select(3),
        extractLane(2),
        replaceLane(3),
        store(3),
        store1(3),
        store2(3),
        store3(3),
        load(2),
        load1(2),
        load2(2),
        load3(2),
        fromInt32x4Bits(1),
        fromUint32x4Bits(1),
        fromInt16x8Bits(1),
        fromUint16x8Bits(1),
        fromInt8x16Bits(1),
        fromUint8x16Bits(1),
        fromInt32x4(1),
        fromUint32x4(1),
        swizzle(1),
        shuffle(2);

        private final int length;

        private SIMDTypeFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

