/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.DateFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.NumberPrototypeBuiltins;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;

public final class DateFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<DateFunction> {
    public static final JSBuiltinsContainer BUILTINS = new DateFunctionBuiltins();

    protected DateFunctionBuiltins() {
        super("Date", DateFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DateFunction builtinEnum) {
        switch (builtinEnum) {
            case parse: {
                return DateFunctionBuiltinsFactory.DateParseNodeGen.create(context, builtin, DateFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case now: {
                return DateFunctionBuiltinsFactory.DateNowNodeGen.create(context, builtin, DateFunctionBuiltins.args().createArgumentNodes(context));
            }
            case UTC: {
                return DateFunctionBuiltinsFactory.DateUTCNodeGen.create(context, builtin, DateFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class DateUTCNode
    extends NumberPrototypeBuiltins.JSNumberOperation {
        public DateUTCNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double utc(Object ... args) {
            double[] argsEvaluated = new double[args.length];
            boolean isNaN = false;
            for (int i = 0; i < args.length; ++i) {
                double d = JSRuntime.doubleValue(this.toNumber(args[i]));
                if (Double.isNaN(d)) {
                    isNaN = true;
                }
                argsEvaluated[i] = d;
            }
            if (isNaN) {
                return Double.NaN;
            }
            return JSDate.executeConstructor(argsEvaluated, true, this.getContext());
        }
    }

    public static abstract class DateNowNode
    extends JSBuiltinNode {
        public DateNowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected double now() {
            return this.getContext().getRealm().currentTimeMillis();
        }
    }

    public static abstract class DateParseNode
    extends NumberPrototypeBuiltins.JSNumberOperation {
        private final ConditionProfile gotFieldsProfile = ConditionProfile.createBinaryProfile();

        public DateParseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double parse(Object parseDate) {
            String dateString = this.toString(parseDate);
            Integer[] fields = this.getContext().getEvaluator().parseDate(this.getContext().getRealm(), dateString.trim());
            if (this.gotFieldsProfile.profile(fields != null)) {
                return JSDate.makeDate(fields[0].intValue(), fields[1].intValue(), fields[2].intValue(), fields[3].intValue(), fields[4].intValue(), fields[5].intValue(), fields[6].intValue(), fields[7], this.getContext());
            }
            return Double.NaN;
        }
    }

    public static enum DateFunction implements BuiltinEnum<DateFunction>
    {
        parse(1),
        now(0),
        UTC(7);

        private final int length;

        private DateFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

