/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.update.Update;

public class UpdateDeParser {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;

    public UpdateDeParser() {
    }

    public UpdateDeParser(ExpressionVisitor expressionVisitor, StringBuffer buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void deParse(Update update) {
        this.buffer.append("UPDATE " + update.getTable().getWholeTableName() + " SET ");
        for (int i = 0; i < update.getColumns().size(); ++i) {
            Column column = (Column)update.getColumns().get(i);
            this.buffer.append(column.getWholeColumnName() + "=");
            Expression expression = (Expression)update.getExpressions().get(i);
            expression.accept(this.expressionVisitor);
            if (i >= update.getColumns().size() - 1) continue;
            this.buffer.append(", ");
        }
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor);
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

