/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.WrappingCloseableIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OrientIndex<T extends OrientElement>
implements Index<T> {
    public static final String CONFIG_CLASSNAME = "blueprintsIndexClass";
    public static final String CONFIG_RECORD_MAP_NAME = "record_map_name";
    protected static final String VERTEX = "Vertex";
    protected static final String EDGE = "Edge";
    protected static final String SEPARATOR = "!=!";
    protected OrientBaseGraph graph;
    protected OIndex<?> underlying;
    protected OIndex<?> recordKeyValueIndex;
    protected Class<? extends Element> indexClass;

    protected OrientIndex(OrientBaseGraph graph, String indexName, Class<? extends Element> indexClass, OType iType) {
        this.graph = graph;
        this.indexClass = indexClass;
        this.create(indexName, this.indexClass, iType);
    }

    protected OrientIndex(OrientBaseGraph orientGraph, OIndex<?> rawIndex) {
        this.graph = orientGraph;
        this.underlying = rawIndex instanceof OIndexTxAwareMultiValue ? rawIndex : new OIndexTxAwareMultiValue((ODatabaseDocumentInternal)orientGraph.getRawGraph(), (OIndex)rawIndex);
        ODocument metadata = rawIndex.getMetadata();
        if (metadata == null) {
            this.load(rawIndex.getConfiguration());
        } else {
            this.load(metadata);
        }
    }

    public String getIndexName() {
        return this.underlying.getName();
    }

    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    public void put(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        ODocument doc = ((OrientElement)element).getRecord();
        if (!doc.getIdentity().isValid()) {
            doc.save();
        }
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        this.underlying.put((Object)keyTemp, (OIdentifiable)doc);
        this.recordKeyValueIndex.put((Object)new OCompositeKey(new Object[]{doc.getIdentity(), keyTemp}), (OIdentifiable)doc.getIdentity());
    }

    public CloseableIterable<T> get(String key, Object iValue) {
        String keyTemp = key + SEPARATOR + iValue;
        Collection records = (Collection)this.underlying.get((Object)keyTemp);
        if (records == null || records.isEmpty()) {
            return new WrappingCloseableIterable(Collections.emptySet());
        }
        return new OrientElementIterable(this.graph, records);
    }

    public CloseableIterable<T> query(String key, Object query) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public long count(String key, Object value) {
        String keyTemp = key + SEPARATOR + value;
        Collection records = (Collection)this.underlying.get((Object)keyTemp);
        if (records == null) {
            return 0L;
        }
        return records.size();
    }

    public void remove(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        try {
            this.underlying.remove((Object)keyTemp, (OIdentifiable)((OrientElement)element).getRecord());
            this.recordKeyValueIndex.remove((Object)new OCompositeKey(new Object[]{((OrientElement)element).getIdentity(), keyTemp}), (OIdentifiable)((OrientElement)element).getIdentity());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        return StringFactory.indexString((Index)this);
    }

    public OIndex<?> getUnderlying() {
        return this.underlying;
    }

    public void close() {
        if (this.underlying != null) {
            this.underlying.flush();
            this.underlying = null;
        }
        this.graph = null;
    }

    protected void removeElement(T element) {
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        OSQLSynchQuery query = new OSQLSynchQuery("select from index:" + this.recordKeyValueIndex.getName() + " where key between [" + ((OrientElement)element).getIdentity() + "] and [" + ((OrientElement)element).getIdentity() + "]");
        List entries = this.graph.getRawGraph().query((OQuery)query, new Object[0]);
        for (ODocument entry : entries) {
            OCompositeKey key = (OCompositeKey)entry.field("key");
            List keys = key.getKeys();
            this.underlying.remove((Object)keys.get(1).toString(), (OIdentifiable)((OrientElement)element).getIdentity());
            this.recordKeyValueIndex.remove((Object)key, (OIdentifiable)((OrientElement)element).getIdentity());
        }
    }

    private void create(String indexName, Class<? extends Element> indexClass, OType iKeyType) {
        this.indexClass = indexClass;
        if (iKeyType == null) {
            iKeyType = OType.STRING;
        }
        OIndexFactory factory = OIndexes.getFactory((String)OClass.INDEX_TYPE.DICTIONARY.toString(), null);
        this.recordKeyValueIndex = new OIndexTxAwareOneValue((ODatabaseDocumentInternal)this.graph.getRawGraph(), this.graph.getRawGraph().getMetadata().getIndexManager().createIndex("__@recordmap@___" + indexName, OClass.INDEX_TYPE.DICTIONARY.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(new OType[]{OType.LINK, OType.STRING}), null, null, null));
        String className = Vertex.class.isAssignableFrom(indexClass) ? VERTEX : (Edge.class.isAssignableFrom(indexClass) ? EDGE : indexClass.getName());
        ODocument metadata = new ODocument();
        metadata.field(CONFIG_CLASSNAME, (Object)className);
        metadata.field(CONFIG_RECORD_MAP_NAME, (Object)this.recordKeyValueIndex.getName());
        this.underlying = new OIndexTxAwareMultiValue((ODatabaseDocumentInternal)this.graph.getRawGraph(), this.graph.getRawGraph().getMetadata().getIndexManager().createIndex(indexName, OClass.INDEX_TYPE.NOTUNIQUE.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(new OType[]{iKeyType}), null, null, metadata));
    }

    private void load(ODocument metadata) {
        String indexClassName = (String)metadata.field(CONFIG_CLASSNAME);
        String recordKeyValueMap = (String)metadata.field(CONFIG_RECORD_MAP_NAME);
        if (VERTEX.equals(indexClassName)) {
            this.indexClass = Vertex.class;
        } else if (EDGE.equals(indexClassName)) {
            this.indexClass = Edge.class;
        } else {
            try {
                this.indexClass = Class.forName(indexClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Index class '" + indexClassName + "' is not registered. Supported ones: Vertex, Edge and custom class that extends them", e);
            }
        }
        this.recordKeyValueIndex = recordKeyValueMap == null ? this.buildKeyValueIndex(metadata) : new OIndexTxAwareOneValue((ODatabaseDocumentInternal)this.graph.getRawGraph(), this.graph.getRawGraph().getMetadata().getIndexManager().getIndex(recordKeyValueMap));
    }

    private OIndex<?> buildKeyValueIndex(ODocument metadata) {
        OIndexTxAwareOneValue recordKeyValueIndex = new OIndexTxAwareOneValue((ODatabaseDocumentInternal)this.graph.getRawGraph(), this.graph.getRawGraph().getMetadata().getIndexManager().createIndex("__@recordmap@___" + this.underlying.getName(), OClass.INDEX_TYPE.DICTIONARY.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(new OType[]{OType.LINK, OType.STRING}), null, null, null));
        List entries = this.graph.getRawGraph().query((OQuery)new OSQLSynchQuery("select  from index:" + this.underlying.getName()), new Object[0]);
        for (ODocument entry : entries) {
            OIdentifiable rid = (OIdentifiable)entry.field("rid");
            if (rid == null) continue;
            recordKeyValueIndex.put((Object)new OCompositeKey(new Object[]{rid, entry.field("key")}), rid);
        }
        metadata.field(CONFIG_RECORD_MAP_NAME, (Object)recordKeyValueIndex.getName());
        return recordKeyValueIndex;
    }
}

