/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.OrientDB;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;

public class OrientGraphFactoryV2 {
    private final OrientDB orientDB;
    String dbName;
    ODatabasePool pool;

    public OrientGraphFactoryV2(OrientDB orientDB, String dbName, String username, String password) {
        this.orientDB = orientDB;
        this.dbName = dbName;
        this.pool = new ODatabasePool(orientDB, dbName, username, password);
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
        this.pool = null;
    }

    public void drop() {
        this.orientDB.drop(this.dbName);
    }

    public OrientGraph getTx() {
        if (this.pool == null) {
            throw new IllegalStateException();
        }
        return new OrientGraph((ODatabaseDocumentInternal)this.pool.acquire());
    }

    public OrientGraphNoTx getNoTx() {
        if (this.pool == null) {
            throw new IllegalStateException();
        }
        return new OrientGraphNoTx((ODatabaseDocumentInternal)this.pool.acquire());
    }

    public boolean exists() {
        return this.orientDB.exists(this.dbName);
    }
}

