/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OrientEdge
extends OrientElement
implements Edge {
    private static final long serialVersionUID = 1L;
    protected OIdentifiable vOut;
    protected OIdentifiable vIn;
    protected String label;

    public OrientEdge() {
        super(null, null);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, OIdentifiable rawEdge) {
        super(rawGraph, rawEdge);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, OIdentifiable rawEdge, String iLabel) {
        super(rawGraph, rawEdge);
        this.label = iLabel;
    }

    protected OrientEdge(OrientBaseGraph rawGraph, String iLabel, Object ... fields) {
        super(rawGraph, null);
        this.rawElement = this.createDocument(iLabel);
        this.setPropertiesInternal(fields);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, OIdentifiable out, OIdentifiable in, String iLabel) {
        super(rawGraph, null);
        this.vOut = out;
        this.vIn = in;
        this.label = iLabel;
    }

    public static OIdentifiable getConnection(ODocument iEdgeRecord, Direction iDirection) {
        return (OIdentifiable)iEdgeRecord.rawField(iDirection == Direction.OUT ? "out" : "in");
    }

    public static boolean isLabeled(String iEdgeLabel, String[] iLabels) {
        if (iLabels != null && iLabels.length > 0) {
            if (iEdgeLabel != null) {
                for (String l : iLabels) {
                    if (!l.equals(iEdgeLabel)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static String getRecordLabel(OIdentifiable iEdge) {
        if (iEdge == null) {
            return null;
        }
        ODocument edge = (ODocument)iEdge.getRecord();
        if (edge == null) {
            return null;
        }
        return (String)edge.field("label");
    }

    private static void removeLightweightConnection(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove) {
        if (iVertex == null || iVertexToRemove == null) {
            return;
        }
        Object fieldValue = iVertex.field(iFieldName);
        if (fieldValue instanceof OIdentifiable) {
            if (fieldValue.equals(iVertexToRemove)) {
                iVertex.removeField(iFieldName);
            }
        } else if (fieldValue instanceof ORidBag) {
            ((ORidBag)fieldValue).remove(iVertexToRemove);
        }
    }

    public OrientEdgeType getType() {
        OrientBaseGraph graph = this.getGraph();
        return this.isLightweight() ? null : new OrientEdgeType(graph, ((ODocument)this.rawElement.getRecord()).getSchemaClass());
    }

    public OrientVertex getVertex(Direction direction) {
        OrientBaseGraph graph = this.setCurrentGraphInThreadLocal();
        if (direction.equals((Object)Direction.OUT)) {
            return graph.getVertex(this.getOutVertex());
        }
        if (direction.equals((Object)Direction.IN)) {
            return graph.getVertex(this.getInVertex());
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public OIdentifiable getOutVertex() {
        if (this.vOut != null) {
            return this.vOut;
        }
        this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        if (doc == null) {
            return null;
        }
        if (this.settings != null && this.settings.isKeepInMemoryReferences()) {
            return (OIdentifiable)doc.rawField("out");
        }
        return (OIdentifiable)doc.field("out");
    }

    public OIdentifiable getInVertex() {
        if (this.vIn != null) {
            return this.vIn;
        }
        this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        if (doc == null) {
            return null;
        }
        if (this.settings != null && this.settings.isKeepInMemoryReferences()) {
            return (OIdentifiable)doc.rawField("in");
        }
        return (OIdentifiable)doc.field("in");
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.rawElement != null) {
            String clsName;
            if (this.settings != null && this.settings.isUseClassForEdgeLabel() && !"E".equals(clsName = this.getRecord().getClassName())) {
                return OrientBaseGraph.decodeClassName(clsName);
            }
            this.setCurrentGraphInThreadLocal();
            ODocument doc = (ODocument)this.rawElement.getRecord();
            if (doc == null) {
                return null;
            }
            String label = (String)doc.field("label");
            if (label != null) {
                return OrientBaseGraph.decodeClassName(label);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this.rawElement == null && object instanceof OrientEdge) {
            OrientEdge other = (OrientEdge)object;
            return this.vOut.equals(other.vOut) && this.vIn.equals(other.vIn) && this.label != null && this.label.equals(other.label);
        }
        return super.equals(object);
    }

    @Override
    public Object getId() {
        if (this.rawElement == null) {
            return this.vOut.getIdentity() + "->" + this.vIn.getIdentity();
        }
        this.setCurrentGraphInThreadLocal();
        return super.getId();
    }

    @Override
    public <T> T getProperty(String key) {
        this.setCurrentGraphInThreadLocal();
        if (this.rawElement == null) {
            return null;
        }
        return super.getProperty(key);
    }

    public boolean isLightweight() {
        return this.rawElement == null;
    }

    public Set<String> getPropertyKeys() {
        if (this.rawElement == null) {
            return Collections.emptySet();
        }
        this.setCurrentGraphInThreadLocal();
        HashSet<String> result = new HashSet<String>();
        for (String field : this.getRecord().fieldNames()) {
            if (field.equals("out") || field.equals("in") || !this.settings.isUseClassForEdgeLabel() && field.equals("label")) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.rawElement == null) {
            return null;
        }
        ODocument raw = (ODocument)this.rawElement.getRecord();
        if (raw == null) {
            return null;
        }
        OrientBaseGraph graph = this.setCurrentGraphInThreadLocal();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String field : raw.fieldNames()) {
            if (field.equals("out") || field.equals("in") || !this.settings.isUseClassForEdgeLabel() && field.equals("label")) continue;
            result.put(field, raw.field(field));
        }
        return result;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.setCurrentGraphInThreadLocal();
        if (this.rawElement == null) {
            this.convertToDocument();
        }
        super.setProperty(key, value);
    }

    @Override
    public <T> T removeProperty(String key) {
        this.setCurrentGraphInThreadLocal();
        if (this.rawElement != null) {
            return super.removeProperty(key);
        }
        return null;
    }

    public void remove() {
        OrientBaseGraph graph = this.getGraph();
        if (!this.isLightweight()) {
            this.checkClass();
        }
        graph.setCurrentGraphInThreadLocal();
        graph.autoStartTransaction();
        for (Index<? extends Element> index : graph.getIndices()) {
            if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
            OrientIndex idx = (OrientIndex)index;
            idx.removeElement(this);
        }
        if (graph != null) {
            graph.removeEdgeInternal(this);
        } else {
            OrientGraphNoTx.removeEdgeInternal(null, this);
        }
    }

    @Override
    public final String getBaseClassName() {
        return "E";
    }

    @Override
    public String getElementType() {
        return "Edge";
    }

    public String toString() {
        if (this.setCurrentGraphInThreadLocal() != null) {
            if (this.getLabel() == null) {
                return "e[" + this.getId() + "]" + "[" + this.getVertex(Direction.OUT).getId() + "->" + this.getVertex(Direction.IN).getId() + "]";
            }
            return StringFactory.edgeString((Edge)this);
        }
        return "e[" + this.getId();
    }

    @Override
    public ODocument getRecord() {
        if (this.rawElement == null) {
            ODocument tmp = new ODocument(this.getClassName(this.label)).setTrackingChanges(false);
            tmp.field("in", (Object)this.vIn.getIdentity());
            tmp.field("out", (Object)this.vOut.getIdentity());
            if (this.label != null && this.settings != null && !this.settings.isUseClassForEdgeLabel()) {
                tmp.field("label", (Object)this.label);
            }
            return tmp;
        }
        return super.getRecord();
    }

    public void convertToDocument() {
        OrientBaseGraph graph = this.checkIfAttached();
        if (this.rawElement != null) {
            return;
        }
        graph.setCurrentGraphInThreadLocal();
        graph.autoStartTransaction();
        ODocument vOutRecord = (ODocument)this.vOut.getRecord();
        ODocument vInRecord = (ODocument)this.vIn.getRecord();
        ODocument doc = this.createDocument(this.label);
        doc.field("out", this.settings.isKeepInMemoryReferences() ? vOutRecord.getIdentity() : vOutRecord);
        doc.field("in", this.settings.isKeepInMemoryReferences() ? vInRecord.getIdentity() : vInRecord);
        this.rawElement = doc;
        boolean useVertexFieldsForEdgeLabels = this.settings.isUseVertexFieldsForEdgeLabels();
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, this.label, useVertexFieldsForEdgeLabels);
        OrientEdge.removeLightweightConnection(vOutRecord, outFieldName, (OIdentifiable)vInRecord);
        OrientVertex.createLink(graph, vOutRecord, (OIdentifiable)doc, outFieldName);
        vOutRecord.save();
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, this.label, useVertexFieldsForEdgeLabels);
        OrientEdge.removeLightweightConnection(vInRecord, inFieldName, (OIdentifiable)vOutRecord);
        OrientVertex.createLink(graph, vInRecord, (OIdentifiable)doc, inFieldName);
        vInRecord.save();
        this.vOut = null;
        this.vIn = null;
        this.label = null;
    }

    public String getClassName(String iLabel) {
        if (iLabel != null && (this.settings == null || this.settings.isUseClassForEdgeLabel())) {
            return this.checkForClassInSchema(iLabel);
        }
        return "E";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.vOut != null ? this.vOut.getIdentity() : null);
        out.writeObject(this.vIn != null ? this.vIn.getIdentity() : null);
        out.writeUTF(this.label != null ? this.label : "");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.vOut = (OIdentifiable)in.readObject();
        this.vIn = (OIdentifiable)in.readObject();
        this.label = in.readUTF();
        if (this.label.isEmpty()) {
            this.label = null;
        }
    }

    public boolean isLabeled(String[] iLabels) {
        return OrientEdge.isLabeled(this.getLabel(), iLabels);
    }

    protected ODocument createDocument(String iLabel) {
        String className = this.getClassName(iLabel);
        ODocument doc = new ODocument(className);
        if (iLabel != null && !this.settings.isUseClassForEdgeLabel()) {
            doc.field("label", (Object)iLabel);
        }
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean dropEdgeFromVertex(OIdentifiable iEdge, ODocument iVertex, String iFieldName, Object iFieldValue) {
        if (iFieldValue == null) {
            OLogManager.instance().debug((Object)this, "Edge not found in vertex's property %s.%s while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            return false;
        }
        if (iFieldValue instanceof OIdentifiable) {
            if (iFieldValue.equals(iEdge)) {
                iVertex.removeField(iFieldName);
                return true;
            }
            OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s link while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            return false;
        }
        if (iFieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)iFieldValue;
            bag.remove(iEdge);
            return true;
        }
        if (!(iFieldValue instanceof Collection)) throw new IllegalStateException("Wrong type found in the field '" + iFieldName + "': " + iFieldValue.getClass());
        Collection coll = (Collection)iFieldValue;
        if (!coll.remove(iEdge)) {
            OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s set while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            return false;
        }
        if (coll.size() == 1) {
            iVertex.field(iFieldName, coll.iterator().next());
            return true;
        }
        if (coll.size() != 0) return true;
        iVertex.removeField(iFieldName);
        return true;
    }
}

