/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag.sbtree;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.AbsoluteChange;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.DiffChange;
import java.util.HashMap;
import java.util.Map;

public class ChangeSerializationHelper {
    public static final ChangeSerializationHelper INSTANCE = new ChangeSerializationHelper();

    public static Change createChangeInstance(byte type, int value) {
        switch (type) {
            case 1: {
                return new AbsoluteChange(value);
            }
            case 0: {
                return new DiffChange(value);
            }
        }
        throw new IllegalArgumentException("Change type is incorrect");
    }

    public Change deserializeChange(byte[] stream, int offset) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset + 1);
        return ChangeSerializationHelper.createChangeInstance(OByteSerializer.INSTANCE.deserializeLiteral(stream, offset), value);
    }

    public Map<OIdentifiable, Change> deserializeChanges(byte[] stream, int offset) {
        int count = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset);
        offset += 4;
        HashMap<OIdentifiable, Change> res = new HashMap<OIdentifiable, Change>();
        for (int i = 0; i < count; ++i) {
            ORecordId rid = OLinkSerializer.INSTANCE.deserialize(stream, offset);
            Change change = INSTANCE.deserializeChange(stream, offset += 10);
            offset += 5;
            ORecordId identifiable = rid.isTemporary() && rid.getRecord() != null ? rid.getRecord() : rid;
            res.put(identifiable, change);
        }
        return res;
    }

    public <K extends OIdentifiable> void serializeChanges(Map<K, Change> changes, OBinarySerializer<K> keySerializer, byte[] stream, int offset) {
        OIntegerSerializer.INSTANCE.serializeLiteral(changes.size(), stream, offset);
        offset += 4;
        for (Map.Entry<K, Change> entry : changes.entrySet()) {
            OIdentifiable key = (OIdentifiable)entry.getKey();
            if (key.getIdentity().isTemporary()) {
                key = key.getRecord();
            }
            keySerializer.serialize(key, stream, offset, new Object[0]);
            offset += keySerializer.getObjectSize(key, new Object[0]);
            offset += entry.getValue().serialize(stream, offset);
        }
    }

    public int getChangesSerializedSize(int changesCount) {
        return changesCount * 15;
    }
}

