/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag.sbtree;

import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;

public class AbsoluteChange
implements Change {
    public static final byte TYPE = 1;
    private int value;

    AbsoluteChange(int value) {
        this.value = value;
        this.checkPositive();
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void increment() {
        ++this.value;
    }

    @Override
    public void decrement() {
        --this.value;
        this.checkPositive();
    }

    @Override
    public int applyTo(Integer value) {
        return this.value;
    }

    @Override
    public boolean isUndefined() {
        return true;
    }

    @Override
    public void applyDiff(int delta) {
        this.value += delta;
        this.checkPositive();
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public int serialize(byte[] stream, int offset) {
        OByteSerializer.INSTANCE.serializeLiteral((byte)1, stream, offset);
        OIntegerSerializer.INSTANCE.serializeLiteral(this.value, stream, offset + 1);
        return 5;
    }

    private void checkPositive() {
        if (this.value < 0) {
            this.value = 0;
        }
    }
}

