/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;

final class ONullBucket
extends ODurablePage {
    ONullBucket(OCacheEntry cacheEntry, boolean isNew) {
        super(cacheEntry);
        if (isNew) {
            this.setByteValue(28, (byte)0);
        }
    }

    public void setValue(ORID value) {
        this.setByteValue(28, (byte)1);
        this.setShortValue(29, (short)value.getClusterId());
        this.setLongValue(31, value.getClusterPosition());
    }

    public ORID getValue() {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        short clusterId = this.getShortValue(29);
        long clusterPosition = this.getLongValue(31);
        return new ORecordId(clusterId, clusterPosition);
    }

    void removeValue() {
        this.setByteValue(28, (byte)0);
    }
}

