/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v1;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.util.ArrayList;
import java.util.List;

final class ONullBucket
extends ODurablePage {
    private static final int RID_SIZE = 10;
    private static final int NEXT_FREE_LIST_OFFSET = 28;
    private static final int NEXT_OFFSET = 32;
    private static final int RIDS_SIZE_OFFSET = 36;
    private static final int RIDS_OFFSET = 40;

    ONullBucket(OCacheEntry cacheEntry, boolean isNew) {
        super(cacheEntry);
        if (isNew) {
            this.setIntValue(36, 0);
            this.setIntValue(28, -1);
            this.setIntValue(32, -1);
        }
    }

    void setNext(int pageIndex) {
        this.setIntValue(32, pageIndex);
    }

    int getNext() {
        return this.getIntValue(32);
    }

    void setNextFreeList(int pageIndex) {
        this.setIntValue(28, pageIndex);
    }

    int getNextFreeList() {
        return this.getIntValue(28);
    }

    boolean addValue(ORID rid) {
        int size = this.getIntValue(36);
        int position = size * 10 + 40;
        if (position + 10 > MAX_PAGE_SIZE_BYTES) {
            return false;
        }
        this.setShortValue(position, (short)rid.getClusterId());
        this.setLongValue(position + 2, rid.getClusterPosition());
        this.setIntValue(36, size + 1);
        return true;
    }

    public List<ORID> getValues() {
        ArrayList<ORID> rids = new ArrayList<ORID>();
        int size = this.getIntValue(36);
        int end = size * 10 + 40;
        for (int position = 40; position < end; position += 10) {
            short clusterId = this.getShortValue(position);
            long clusterPosition = this.getLongValue(position + 2);
            rids.add(new ORecordId(clusterId, clusterPosition));
        }
        return rids;
    }

    public int getSize() {
        return this.getIntValue(36);
    }

    boolean removeValue(ORID rid) {
        int size = this.getIntValue(36);
        int end = size * 10 + 40;
        for (int position = 40; position < end; position += 10) {
            long clusterPosition;
            short clusterId = this.getShortValue(position);
            if (clusterId != rid.getClusterId() || (clusterPosition = this.getLongValue(position + 2)) != rid.getClusterPosition()) continue;
            this.moveData(position + 10, position, end - (position + 10));
            this.setIntValue(36, size - 1);
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.getIntValue(36) == 0;
    }

    boolean isFull() {
        int size = this.getIntValue(36);
        int position = size * 10 + 40;
        return position + 10 > MAX_PAGE_SIZE_BYTES;
    }
}

