/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OLocalHashTableException;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashIndexFileLevelMetadataPage;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashTable;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashTableDirectory;
import com.orientechnologies.orient.core.storage.index.hashindex.local.ONullBucket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class OLocalHashTable<K, V>
extends ODurableComponent
implements OHashTable<K, V> {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final long HASH_CODE_MIN_VALUE = 0L;
    private static final long HASH_CODE_MAX_VALUE = -1L;
    private static final int OFFSET_MASK = 255;
    private final String metadataConfigurationFileExtension;
    private final String treeStateFileExtension;
    static final int HASH_CODE_SIZE = 64;
    private static final int MAX_LEVEL_DEPTH = 8;
    static final int MAX_LEVEL_SIZE = 256;
    private static final int LEVEL_MASK = 255;
    private OHashFunction<K> keyHashFunction;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private OType[] keyTypes;
    private OHashTable.KeyHashCodeComparator<K> comparator;
    private boolean nullKeyIsSupported;
    private long nullBucketFileId = -1L;
    private final String nullBucketFileExtension;
    private long fileStateId;
    private long fileId;
    private long hashStateEntryIndex;
    private OHashTableDirectory directory;
    private OEncryption encryption;

    public OLocalHashTable(String name, String metadataConfigurationFileExtension, String treeStateFileExtension, String bucketFileExtension, String nullBucketFileExtension, OAbstractPaginatedStorage abstractPaginatedStorage) {
        super(abstractPaginatedStorage, name, bucketFileExtension, name + bucketFileExtension);
        this.metadataConfigurationFileExtension = metadataConfigurationFileExtension;
        this.treeStateFileExtension = treeStateFileExtension;
        this.nullBucketFileExtension = nullBucketFileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, OEncryption encryption, OHashFunction<K> keyHashFunction, boolean nullKeyIsSupported) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.keyHashFunction = keyHashFunction;
                this.comparator = new OHashTable.KeyHashCodeComparator<K>(this.keyHashFunction);
                this.encryption = encryption;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.nullKeyIsSupported = nullKeyIsSupported;
                this.directory = new OHashTableDirectory(this.treeStateFileExtension, this.getName(), this.getFullName(), this.storage);
                this.fileStateId = this.addFile(atomicOperation, this.getName() + this.metadataConfigurationFileExtension);
                this.directory.create(atomicOperation);
                OCacheEntry hashStateEntry = this.addPage(atomicOperation, this.fileStateId);
                this.pinPage(atomicOperation, hashStateEntry);
                try {
                    OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, true);
                    this.hashStateEntryIndex = hashStateEntry.getPageIndex();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, hashStateEntry);
                }
                String fileName = this.getFullName();
                this.fileId = this.addFile(atomicOperation, fileName);
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.initHashTreeState(atomicOperation);
                if (nullKeyIsSupported) {
                    this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullBucketFileExtension);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isNullKeyIsSupported() {
        this.acquireSharedLock();
        try {
            boolean bl = this.nullKeyIsSupported;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void put(K key, V value) throws IOException {
        this.put(key, value, null);
    }

    @Override
    public boolean validatedPut(K key, V value, OBaseIndexEngine.Validator<K, V> validator) throws IOException {
        return this.put(key, value, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            V removed;
            int sizeDiff;
            block27: {
                block25: {
                    V v;
                    this.acquireExclusiveLock();
                    try {
                        V removed2;
                        boolean found;
                        this.checkNullSupport(key);
                        sizeDiff = 0;
                        if (key == null) break block25;
                        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                        long hashCode = this.keyHashFunction.hashCode(key);
                        OHashTable.BucketPath nodePath = this.getBucket(hashCode, atomicOperation);
                        long bucketPointer = this.directory.getNodePointer(nodePath.nodeIndex, nodePath.itemIndex + nodePath.hashMapOffset, atomicOperation);
                        long pageIndex = OLocalHashTable.getPageIndex(bucketPointer);
                        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                        try {
                            OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.encryption);
                            int positionIndex = bucket.getIndex(hashCode, key);
                            boolean bl = found = positionIndex >= 0;
                            if (found) {
                                removed2 = bucket.deleteEntry((int)positionIndex).value;
                                --sizeDiff;
                            } else {
                                removed2 = null;
                            }
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                        if (found) {
                            if (nodePath.parent != null) {
                                int hashMapSize = 1 << nodePath.nodeLocalDepth;
                                boolean allMapsContainSameBucket = OLocalHashTable.checkAllMapsContainSameBucket(this.directory.getNode(nodePath.nodeIndex, atomicOperation), hashMapSize);
                                if (allMapsContainSameBucket) {
                                    this.mergeNodeToParent(nodePath, atomicOperation);
                                }
                            }
                            this.changeSize(sizeDiff, atomicOperation);
                        }
                        v = removed2;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.releaseExclusiveLock();
                            throw throwable;
                        }
                        catch (Exception e) {
                            rollback = true;
                            throw e;
                        }
                    }
                    this.releaseExclusiveLock();
                    return v;
                }
                if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) != 0L) break block27;
                V hashCode = null;
                this.releaseExclusiveLock();
                return hashCode;
            }
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
            if (cacheEntry == null) {
                cacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
            }
            try {
                ONullBucket<V> nullBucket = new ONullBucket<V>(cacheEntry, this.valueSerializer, false);
                removed = nullBucket.getValue();
                if (removed != null) {
                    nullBucket.removeValue();
                    --sizeDiff;
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            this.changeSize(sizeDiff, atomicOperation);
            V v = removed;
            this.releaseExclusiveLock();
            return v;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSize(int sizeDiff, OAtomicOperation atomicOperation) throws IOException {
        if (sizeDiff != 0) {
            OCacheEntry hashStateEntry = this.loadPageForWrite(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, true);
            try {
                OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, false);
                page.setRecordsCount(page.getRecordsCount() + (long)sizeDiff);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, hashStateEntry);
            }
        }
    }

    @Override
    public void clear() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            this.acquireExclusiveLock();
            try {
                if (this.nullKeyIsSupported) {
                    this.truncateFile(atomicOperation, this.nullBucketFileId);
                }
                this.initHashTreeState(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    @Override
    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key) {
        return this.higherEntries(key, -1);
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String name, OType[] keyTypes, boolean nullKeyIsSupported, OEncryption encryption, OHashFunction<K> keyHashFunction, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.acquireExclusiveLock();
        try {
            this.keyHashFunction = keyHashFunction;
            this.comparator = new OHashTable.KeyHashCodeComparator<K>(this.keyHashFunction);
            this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
            this.encryption = encryption;
            this.nullKeyIsSupported = nullKeyIsSupported;
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileStateId = this.openFile(atomicOperation, name + this.metadataConfigurationFileExtension);
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.directory = new OHashTableDirectory(this.treeStateFileExtension, name, this.getFullName(), this.storage);
            this.directory.open(atomicOperation);
            OCacheEntry hashStateEntry = this.loadPageForRead(atomicOperation, this.fileStateId, 0L, true);
            try {
                this.hashStateEntryIndex = hashStateEntry.getPageIndex();
                this.pinPage(atomicOperation, hashStateEntry);
            }
            finally {
                this.releasePageFromRead(atomicOperation, hashStateEntry);
            }
            if (nullKeyIsSupported) {
                this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullBucketFileExtension);
            }
            this.fileId = this.openFile(atomicOperation, this.getFullName());
        }
        catch (IOException e) {
            throw OException.wrapException(new OLocalHashTableException("Exception during hash table loading", this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWithoutLoad(String name) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, name + this.metadataConfigurationFileExtension)) {
                    this.fileStateId = this.openFile(atomicOperation, name + this.metadataConfigurationFileExtension);
                    this.deleteFile(atomicOperation, this.fileStateId);
                }
                this.directory = new OHashTableDirectory(this.treeStateFileExtension, name, this.getFullName(), this.storage);
                this.directory.deleteWithoutOpen(atomicOperation);
                if (this.isFileExists(atomicOperation, name + this.nullBucketFileExtension)) {
                    long nullBucketId = this.openFile(atomicOperation, name + this.nullBucketFileExtension);
                    this.deleteFile(atomicOperation, nullBucketId);
                }
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    private OHashIndexBucket.Entry<K, V>[] convertBucketToEntries(OHashIndexBucket<K, V> bucket, int startIndex, int endIndex) {
        OHashIndexBucket.Entry[] entries = new OHashIndexBucket.Entry[endIndex - startIndex];
        Iterator<OHashIndexBucket.Entry<K, V>> iterator = bucket.iterator(startIndex);
        int i = 0;
        for (int k = startIndex; k < endIndex; ++k) {
            entries[i] = iterator.next();
            ++i;
        }
        return entries;
    }

    private OHashTable.BucketPath nextBucketToFind(OHashTable.BucketPath bucketPath, int bucketDepth, OAtomicOperation atomicOperation) throws IOException {
        OHashTable.BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        OHashTable.BucketPath currentNode = bucketPath;
        int nodeLocalDepth = this.directory.getNodeLocalDepth(bucketPath.nodeIndex, atomicOperation);
        assert (this.directory.getNodeLocalDepth(bucketPath.nodeIndex, atomicOperation) == bucketPath.nodeLocalDepth);
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
            assert (this.directory.getNodeLocalDepth(currentNode.nodeIndex, atomicOperation) == currentNode.nodeLocalDepth);
        }
        int diff = bucketDepth - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int interval = 1 << nodeLocalDepth - diff;
        int globalIndex = firstStartIndex + interval + currentNode.hashMapOffset;
        if (globalIndex >= 256) {
            bucketPathToFind = this.nextLevelUp(currentNode, atomicOperation);
        } else {
            int hashMapSize = 1 << currentNode.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new OHashTable.BucketPath(currentNode.parent, hashMapOffset, startIndex, currentNode.nodeIndex, currentNode.nodeLocalDepth, currentNode.nodeGlobalDepth);
        }
        return this.nextNonEmptyNode(bucketPathToFind, atomicOperation);
    }

    private OHashTable.BucketPath nextNonEmptyNode(OHashTable.BucketPath bucketPath, OAtomicOperation atomicOperation) throws IOException {
        block0: while (bucketPath != null) {
            long[] node = this.directory.getNode(bucketPath.nodeIndex, atomicOperation);
            int startIndex = bucketPath.itemIndex + bucketPath.hashMapOffset;
            int endIndex = 256;
            for (int i = startIndex; i < 256; ++i) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << bucketPath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new OHashTable.BucketPath(bucketPath.parent, hashMapOffset, itemIndex, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                }
                if (position >= 0L) continue;
                int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                int childItemOffset = (int)position & 0xFF;
                OHashTable.BucketPath parent = new OHashTable.BucketPath(bucketPath.parent, 0, i, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                byte childLocalDepth = this.directory.getNodeLocalDepth(childNodeIndex, atomicOperation);
                bucketPath = new OHashTable.BucketPath(parent, childItemOffset, 0, childNodeIndex, childLocalDepth, bucketPath.nodeGlobalDepth + childLocalDepth);
                continue block0;
            }
            bucketPath = this.nextLevelUp(bucketPath, atomicOperation);
        }
        return null;
    }

    private OHashTable.BucketPath nextLevelUp(OHashTable.BucketPath bucketPath, OAtomicOperation atomicOperation) throws IOException {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        assert (this.directory.getNodeLocalDepth(bucketPath.nodeIndex, atomicOperation) == bucketPath.nodeLocalDepth);
        int pointersSize = 1 << 8 - nodeLocalDepth;
        OHashTable.BucketPath parent = bucketPath.parent;
        if (parent.itemIndex < 128) {
            int nextParentIndex = (parent.itemIndex / pointersSize + 1) * pointersSize;
            return new OHashTable.BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int nextParentIndex = ((parent.itemIndex - 128) / pointersSize + 1) * pointersSize + 128;
        if (nextParentIndex < 256) {
            return new OHashTable.BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.nextLevelUp(new OHashTable.BucketPath(parent.parent, 0, 255, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth), atomicOperation);
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] ceilingEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V> firstEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V> lastEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] lowerEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] floorEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OHashTable.BucketPath prevBucketToFind(OHashTable.BucketPath bucketPath, int bucketDepth, OAtomicOperation atomicOperation) throws IOException {
        OHashTable.BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        OHashTable.BucketPath currentBucket = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentBucket = bucketPath.parent;
            nodeLocalDepth = currentBucket.nodeLocalDepth;
        }
        int diff = bucketDepth - (currentBucket.nodeGlobalDepth - nodeLocalDepth);
        int firstStartIndex = currentBucket.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int globalIndex = firstStartIndex + currentBucket.hashMapOffset - 1;
        if (globalIndex < 0) {
            bucketPathToFind = OLocalHashTable.prevLevelUp(bucketPath);
        } else {
            int hashMapSize = 1 << currentBucket.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new OHashTable.BucketPath(currentBucket.parent, hashMapOffset, startIndex, currentBucket.nodeIndex, currentBucket.nodeLocalDepth, currentBucket.nodeGlobalDepth);
        }
        return this.prevNonEmptyNode(bucketPathToFind, atomicOperation);
    }

    private OHashTable.BucketPath prevNonEmptyNode(OHashTable.BucketPath nodePath, OAtomicOperation atomicOperation) throws IOException {
        block0: while (nodePath != null) {
            int endIndex;
            long[] node = this.directory.getNode(nodePath.nodeIndex, atomicOperation);
            boolean startIndex = false;
            for (int i = endIndex = nodePath.itemIndex + nodePath.hashMapOffset; i >= 0; --i) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << nodePath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new OHashTable.BucketPath(nodePath.parent, hashMapOffset, itemIndex, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                }
                if (position >= 0L) continue;
                int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                int childItemOffset = (int)position & 0xFF;
                byte nodeLocalDepth = this.directory.getNodeLocalDepth(childNodeIndex, atomicOperation);
                int endChildIndex = (1 << nodeLocalDepth) - 1;
                OHashTable.BucketPath parent = new OHashTable.BucketPath(nodePath.parent, 0, i, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                nodePath = new OHashTable.BucketPath(parent, childItemOffset, endChildIndex, childNodeIndex, nodeLocalDepth, parent.nodeGlobalDepth + nodeLocalDepth);
                continue block0;
            }
            nodePath = OLocalHashTable.prevLevelUp(nodePath);
        }
        return null;
    }

    private static OHashTable.BucketPath prevLevelUp(OHashTable.BucketPath bucketPath) {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        int pointersSize = 1 << 8 - nodeLocalDepth;
        OHashTable.BucketPath parent = bucketPath.parent;
        if (parent.itemIndex > 128) {
            int prevParentIndex = (parent.itemIndex - 128) / pointersSize * pointersSize + 128 - 1;
            return new OHashTable.BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int prevParentIndex = parent.itemIndex / pointersSize * pointersSize - 1;
        if (prevParentIndex >= 0) {
            return new OHashTable.BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return OLocalHashTable.prevLevelUp(new OHashTable.BucketPath(parent.parent, 0, 0, parent.nodeIndex, parent.nodeLocalDepth, -1));
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.flush();
            this.directory.close();
            this.readCache.closeFile(this.fileStateId, true, this.writeCache);
            this.readCache.closeFile(this.fileId, true, this.writeCache);
        }
        catch (IOException e) {
            throw OException.wrapException(new OLocalHashTableException("Error during hash table close", this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void delete() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.directory.delete(atomicOperation);
                this.deleteFile(atomicOperation, this.fileStateId);
                this.deleteFile(atomicOperation, this.fileId);
                if (this.nullKeyIsSupported) {
                    this.deleteFile(atomicOperation, this.nullBucketFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    private void mergeNodeToParent(OHashTable.BucketPath nodePath, OAtomicOperation atomicOperation) throws IOException {
        byte maxChildDepth;
        int startIndex = OLocalHashTable.findParentNodeStartIndex(nodePath);
        int localNodeDepth = nodePath.nodeLocalDepth;
        int hashMapSize = 1 << localNodeDepth;
        int parentIndex = nodePath.parent.nodeIndex;
        int i = 0;
        int k = startIndex;
        while (i < 256) {
            this.directory.setNodePointer(parentIndex, k, this.directory.getNodePointer(nodePath.nodeIndex, i, atomicOperation), atomicOperation);
            i += hashMapSize;
            ++k;
        }
        this.directory.deleteNode(nodePath.nodeIndex, atomicOperation);
        if (nodePath.parent.itemIndex < 128) {
            maxChildDepth = this.directory.getMaxLeftChildDepth(parentIndex, atomicOperation);
            if (maxChildDepth == localNodeDepth) {
                this.directory.setMaxLeftChildDepth(parentIndex, (byte)this.getMaxLevelDepth(parentIndex, 0, 128, atomicOperation), atomicOperation);
            }
        } else {
            maxChildDepth = this.directory.getMaxRightChildDepth(parentIndex, atomicOperation);
            if (maxChildDepth == localNodeDepth) {
                this.directory.setMaxRightChildDepth(parentIndex, (byte)this.getMaxLevelDepth(parentIndex, 128, 256, atomicOperation), atomicOperation);
            }
        }
    }

    @Override
    public void flush() {
        this.acquireExclusiveLock();
        try {
            this.writeCache.flush(this.fileStateId);
            this.writeCache.flush(this.fileId);
            this.directory.flush();
            if (this.nullKeyIsSupported) {
                this.writeCache.flush(this.nullBucketFileId);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(K key, V value, OBaseIndexEngine.Validator<K, V> validator) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            int keySize;
            this.acquireExclusiveLock();
            try {
                this.checkNullSupport(key);
                if (key != null && (keySize = this.keySerializer.getObjectSize(key, (Object[])this.keyTypes)) > MAX_KEY_SIZE) {
                    throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + (int)keySize + ", allowed  " + MAX_KEY_SIZE, this.getName());
                }
                key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                keySize = this.doPut(key, value, validator, atomicOperation) ? 1 : 0;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                catch (Exception e) {
                    rollback = true;
                    throw e;
                }
            }
            this.releaseExclusiveLock();
            return keySize;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPut(K key, V value, OBaseIndexEngine.Validator<K, V> validator, OAtomicOperation atomicOperation) throws IOException {
        int sizeDiff = 0;
        if (key == null) {
            boolean isNew;
            OCacheEntry cacheEntry;
            if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                cacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                isNew = true;
            } else {
                cacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                isNew = false;
            }
            try {
                ONullBucket<V> nullBucket = new ONullBucket<V>(cacheEntry, this.valueSerializer, isNew);
                V oldValue = nullBucket.getValue();
                if (validator != null) {
                    Object result = validator.validate(null, oldValue, value);
                    if (result == OBaseIndexEngine.Validator.IGNORE) {
                        boolean bl = false;
                        return bl;
                    }
                    value = result;
                }
                if (oldValue != null) {
                    --sizeDiff;
                }
                nullBucket.setValue(value);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            this.changeSize(++sizeDiff, atomicOperation);
            return true;
        }
        long hashCode = this.keyHashFunction.hashCode(key);
        OHashTable.BucketPath bucketPath = this.getBucket(hashCode, atomicOperation);
        long bucketPointer = this.directory.getNodePointer(bucketPath.nodeIndex, bucketPath.itemIndex + bucketPath.hashMapOffset, atomicOperation);
        if (bucketPointer == 0L) {
            throw new IllegalStateException("In this version of hash table buckets are added through split only.");
        }
        long pageIndex = OLocalHashTable.getPageIndex(bucketPointer);
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.encryption);
            int index = bucket.getIndex(hashCode, key);
            if (validator != null) {
                Object oldValue = index > -1 ? (Object)bucket.getValue(index) : null;
                Object result = validator.validate(key, oldValue, value);
                if (result == OBaseIndexEngine.Validator.IGNORE) {
                    boolean bl = false;
                    return bl;
                }
                value = result;
            }
            if (index > -1) {
                int updateResult = bucket.updateEntry(index, value);
                if (updateResult == 0) {
                    this.changeSize(sizeDiff, atomicOperation);
                    boolean result = true;
                    return result;
                }
                if (updateResult == 1) {
                    this.changeSize(sizeDiff, atomicOperation);
                    boolean result = true;
                    return result;
                }
                assert (updateResult == -1);
                bucket.deleteEntry(index);
                --sizeDiff;
            }
            if (bucket.addEntry(hashCode, key, value)) {
                this.changeSize(++sizeDiff, atomicOperation);
                boolean updateResult = true;
                return updateResult;
            }
            OHashTable.BucketSplitResult splitResult = this.splitBucket(bucket, pageIndex, atomicOperation);
            long updatedBucketPointer = splitResult.updatedBucketPointer;
            long newBucketPointer = splitResult.newBucketPointer;
            int bucketDepth = splitResult.newDepth;
            if (bucketDepth <= bucketPath.nodeGlobalDepth) {
                this.updateNodeAfterBucketSplit(bucketPath, bucketDepth, newBucketPointer, updatedBucketPointer, atomicOperation);
            } else if (bucketPath.nodeLocalDepth < 8) {
                OHashTable.NodeSplitResult nodeSplitResult = this.splitNode(bucketPath, atomicOperation);
                assert (!nodeSplitResult.allLeftHashMapsEqual || !nodeSplitResult.allRightHashMapsEqual);
                long[] newNode = nodeSplitResult.newNode;
                int nodeLocalDepth = bucketPath.nodeLocalDepth + 1;
                int hashMapSize = 1 << nodeLocalDepth;
                assert (nodeSplitResult.allRightHashMapsEqual == OLocalHashTable.checkAllMapsContainSameBucket(newNode, hashMapSize));
                int newNodeIndex = -1;
                if (!nodeSplitResult.allRightHashMapsEqual || bucketPath.itemIndex >= 128) {
                    newNodeIndex = this.directory.addNewNode((byte)0, (byte)0, (byte)nodeLocalDepth, newNode, atomicOperation);
                }
                int updatedItemIndex = bucketPath.itemIndex << 1;
                int updatedOffset = bucketPath.hashMapOffset << 1;
                int updatedGlobalDepth = bucketPath.nodeGlobalDepth + 1;
                boolean allLeftHashMapsEqual = nodeSplitResult.allLeftHashMapsEqual;
                boolean allRightHashMapsEqual = nodeSplitResult.allRightHashMapsEqual;
                if (updatedOffset < 256) {
                    allLeftHashMapsEqual = false;
                    OHashTable.BucketPath updatedBucketPath = new OHashTable.BucketPath(bucketPath.parent, updatedOffset, updatedItemIndex, bucketPath.nodeIndex, nodeLocalDepth, updatedGlobalDepth);
                    this.updateNodeAfterBucketSplit(updatedBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer, atomicOperation);
                } else {
                    allRightHashMapsEqual = false;
                    OHashTable.BucketPath newBucketPath = new OHashTable.BucketPath(bucketPath.parent, updatedOffset - 256, updatedItemIndex, newNodeIndex, nodeLocalDepth, updatedGlobalDepth);
                    this.updateNodeAfterBucketSplit(newBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer, atomicOperation);
                }
                this.updateNodesAfterSplit(bucketPath, bucketPath.nodeIndex, newNode, nodeLocalDepth, hashMapSize, allLeftHashMapsEqual, allRightHashMapsEqual, newNodeIndex, atomicOperation);
                if (allLeftHashMapsEqual) {
                    this.directory.deleteNode(bucketPath.nodeIndex, atomicOperation);
                }
            } else {
                this.addNewLevelNode(bucketPath, bucketPath.nodeIndex, newBucketPointer, updatedBucketPointer, atomicOperation);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
        this.changeSize(sizeDiff, atomicOperation);
        this.doPut(key, value, null, atomicOperation);
        return true;
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullKeyIsSupported) {
            throw new OLocalHashTableException("Null keys are not supported.", this);
        }
    }

    private void updateNodesAfterSplit(OHashTable.BucketPath bucketPath, int nodeIndex, long[] newNode, int nodeLocalDepth, int hashMapSize, boolean allLeftHashMapEquals, boolean allRightHashMapsEquals, int newNodeIndex, OAtomicOperation atomicOperation) throws IOException {
        long position;
        int i;
        int startIndex = OLocalHashTable.findParentNodeStartIndex(bucketPath);
        int parentNodeIndex = bucketPath.parent.nodeIndex;
        assert (OLocalHashTable.assertParentNodeStartIndex(bucketPath, this.directory.getNode(parentNodeIndex, atomicOperation), startIndex));
        int pointersSize = 1 << 8 - nodeLocalDepth;
        if (allLeftHashMapEquals) {
            for (i = 0; i < pointersSize; ++i) {
                position = this.directory.getNodePointer(nodeIndex, i * hashMapSize, atomicOperation);
                this.directory.setNodePointer(parentNodeIndex, startIndex + i, position, atomicOperation);
            }
        } else {
            for (i = 0; i < pointersSize; ++i) {
                this.directory.setNodePointer(parentNodeIndex, startIndex + i, (long)(bucketPath.nodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE, atomicOperation);
            }
        }
        if (allRightHashMapsEquals) {
            for (i = 0; i < pointersSize; ++i) {
                position = newNode[i * hashMapSize];
                this.directory.setNodePointer(parentNodeIndex, startIndex + pointersSize + i, position, atomicOperation);
            }
        } else {
            for (i = 0; i < pointersSize; ++i) {
                this.directory.setNodePointer(parentNodeIndex, startIndex + pointersSize + i, (long)(newNodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE, atomicOperation);
            }
        }
        this.updateMaxChildDepth(bucketPath.parent, bucketPath.nodeLocalDepth + 1, atomicOperation);
    }

    private void updateMaxChildDepth(OHashTable.BucketPath parentPath, int childDepth, OAtomicOperation atomicOperation) throws IOException {
        if (parentPath == null) {
            return;
        }
        if (parentPath.itemIndex < 128) {
            byte maxChildDepth = this.directory.getMaxLeftChildDepth(parentPath.nodeIndex, atomicOperation);
            if (childDepth > maxChildDepth) {
                this.directory.setMaxLeftChildDepth(parentPath.nodeIndex, (byte)childDepth, atomicOperation);
            }
        } else {
            byte maxChildDepth = this.directory.getMaxRightChildDepth(parentPath.nodeIndex, atomicOperation);
            if (childDepth > maxChildDepth) {
                this.directory.setMaxRightChildDepth(parentPath.nodeIndex, (byte)childDepth, atomicOperation);
            }
        }
    }

    private static boolean assertParentNodeStartIndex(OHashTable.BucketPath bucketPath, long[] parentNode, int calculatedIndex) {
        int startIndex = -1;
        for (int i = 0; i < parentNode.length; ++i) {
            if (parentNode[i] >= 0L || (parentNode[i] & Long.MAX_VALUE) >>> 8 != (long)bucketPath.nodeIndex) continue;
            startIndex = i;
            break;
        }
        return startIndex == calculatedIndex;
    }

    private static int findParentNodeStartIndex(OHashTable.BucketPath bucketPath) {
        OHashTable.BucketPath parentBucketPath = bucketPath.parent;
        int pointersSize = 1 << 8 - bucketPath.nodeLocalDepth;
        if (parentBucketPath.itemIndex < 128) {
            return parentBucketPath.itemIndex / pointersSize * pointersSize;
        }
        return (parentBucketPath.itemIndex - 128) / pointersSize * pointersSize + 128;
    }

    private void addNewLevelNode(OHashTable.BucketPath bucketPath, int nodeIndex, long newBucketPointer, long updatedBucketPointer, OAtomicOperation atomicOperation) throws IOException {
        int newNodeStartIndex;
        int mapInterval;
        byte newNodeDepth;
        byte maxDepth;
        if (bucketPath.itemIndex < 128) {
            maxDepth = this.directory.getMaxLeftChildDepth(bucketPath.nodeIndex, atomicOperation);
            assert (this.getMaxLevelDepth(bucketPath.nodeIndex, 0, 128, atomicOperation) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : (byte)1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = bucketPath.itemIndex / mapInterval * mapInterval;
        } else {
            maxDepth = this.directory.getMaxRightChildDepth(bucketPath.nodeIndex, atomicOperation);
            assert (this.getMaxLevelDepth(bucketPath.nodeIndex, 128, 256, atomicOperation) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : (byte)1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = (bucketPath.itemIndex - 128) / mapInterval * mapInterval + 128;
        }
        int newNodeIndex = this.directory.addNewNode((byte)0, (byte)0, newNodeDepth, new long[256], atomicOperation);
        int mapSize = 1 << newNodeDepth;
        for (int i = 0; i < mapInterval; ++i) {
            int n;
            int nodeOffset = i + newNodeStartIndex;
            long bucketPointer = this.directory.getNodePointer(nodeIndex, nodeOffset, atomicOperation);
            if (nodeOffset != bucketPath.itemIndex) {
                for (n = i << newNodeDepth; n < i + 1 << newNodeDepth; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, bucketPointer, atomicOperation);
                }
            } else {
                for (n = i << newNodeDepth; n < 2 * i + 1 << newNodeDepth - 1; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, updatedBucketPointer, atomicOperation);
                }
                for (n = 2 * i + 1 << newNodeDepth - 1; n < i + 1 << newNodeDepth; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, newBucketPointer, atomicOperation);
                }
            }
            this.directory.setNodePointer(nodeIndex, nodeOffset, (long)(newNodeIndex << 8 | i * mapSize) | Long.MIN_VALUE, atomicOperation);
        }
        this.updateMaxChildDepth(bucketPath, newNodeDepth, atomicOperation);
    }

    private int getMaxLevelDepth(int nodeIndex, int start, int end, OAtomicOperation atomicOperation) throws IOException {
        int currentIndex = -1;
        byte maxDepth = 0;
        for (int i = start; i < end; ++i) {
            int index;
            long nodePosition = this.directory.getNodePointer(nodeIndex, i, atomicOperation);
            if (nodePosition >= 0L || (index = (int)((nodePosition & Long.MAX_VALUE) >>> 8)) == currentIndex) continue;
            currentIndex = index;
            byte nodeLocalDepth = this.directory.getNodeLocalDepth(index, atomicOperation);
            if (maxDepth >= nodeLocalDepth) continue;
            maxDepth = nodeLocalDepth;
        }
        return maxDepth;
    }

    private void updateNodeAfterBucketSplit(OHashTable.BucketPath bucketPath, int bucketDepth, long newBucketPointer, long updatedBucketPointer, OAtomicOperation atomicOperation) throws IOException {
        int i;
        int firstEndIndex;
        int offset = bucketPath.nodeGlobalDepth - (bucketDepth - 1);
        OHashTable.BucketPath currentNode = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
        }
        int diff = bucketDepth - 1 - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff - 1;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int secondStartIndex = firstEndIndex = firstStartIndex + interval;
        int secondEndIndex = secondStartIndex + interval;
        for (i = firstStartIndex; i < firstEndIndex; ++i) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, updatedBucketPointer, atomicOperation);
        }
        for (i = secondStartIndex; i < secondEndIndex; ++i) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, newBucketPointer, atomicOperation);
        }
    }

    private static boolean checkAllMapsContainSameBucket(long[] newNode, int hashMapSize) {
        boolean allHashMapsEquals = true;
        block0: for (int n = 0; n < newNode.length; n += hashMapSize) {
            boolean allHashBucketEquals = true;
            for (int i = 0; i < hashMapSize - 1; ++i) {
                if (newNode[i + n] == newNode[i + n + 1]) continue;
                allHashBucketEquals = false;
                continue block0;
            }
            if (allHashBucketEquals) continue;
            allHashMapsEquals = false;
            break;
        }
        assert (OLocalHashTable.assertAllNodesAreFilePointers(allHashMapsEquals, newNode, hashMapSize));
        return allHashMapsEquals;
    }

    private static boolean assertAllNodesAreFilePointers(boolean allHashMapsEquals, long[] newNode, int hashMapSize) {
        if (allHashMapsEquals) {
            for (int n = 0; n < newNode.length; n += hashMapSize) {
                for (int i = 0; i < hashMapSize; ++i) {
                    if (newNode[i] >= 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private OHashTable.NodeSplitResult splitNode(OHashTable.BucketPath bucketPath, OAtomicOperation atomicOperation) throws IOException {
        long[] newNode = new long[256];
        int hashMapSize = 1 << bucketPath.nodeLocalDepth + 1;
        boolean hashMapItemsAreEqual = true;
        int mapCounter = 0;
        long firstPosition = -1L;
        long[] node = this.directory.getNode(bucketPath.nodeIndex, atomicOperation);
        for (int i = 128; i < 256; ++i) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            newNode[2 * (i - 128)] = position;
            newNode[2 * (i - 128) + 1] = position;
            if (!hashMapItemsAreEqual) continue;
            boolean bl = hashMapItemsAreEqual = firstPosition == position;
            if ((mapCounter += 2) < hashMapSize) continue;
            mapCounter = 0;
        }
        mapCounter = 0;
        boolean allRightItemsAreEqual = hashMapItemsAreEqual;
        hashMapItemsAreEqual = true;
        long[] updatedNode = new long[node.length];
        for (int i = 0; i < 128; ++i) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            updatedNode[2 * i] = position;
            updatedNode[2 * i + 1] = position;
            if (!hashMapItemsAreEqual) continue;
            boolean bl = hashMapItemsAreEqual = firstPosition == position;
            if ((mapCounter += 2) < hashMapSize) continue;
            mapCounter = 0;
        }
        boolean allLeftItemsAreEqual = hashMapItemsAreEqual;
        this.directory.setNode(bucketPath.nodeIndex, updatedNode, atomicOperation);
        this.directory.setNodeLocalDepth(bucketPath.nodeIndex, (byte)(this.directory.getNodeLocalDepth(bucketPath.nodeIndex, atomicOperation) + 1), atomicOperation);
        return new OHashTable.NodeSplitResult(newNode, allLeftItemsAreEqual, allRightItemsAreEqual);
    }

    private void splitBucketContent(OHashIndexBucket<K, V> bucket, OHashIndexBucket<K, V> newBucket, int newBucketDepth) throws IOException {
        assert (this.checkBucketDepth(bucket));
        ArrayList<OHashIndexBucket.Entry<K, V>> entries = new ArrayList<OHashIndexBucket.Entry<K, V>>(bucket.size());
        for (OHashIndexBucket.Entry<K, V> entry : bucket) {
            entries.add(entry);
        }
        bucket.init(newBucketDepth);
        for (OHashIndexBucket.Entry<K, V> entry : entries) {
            if ((this.keyHashFunction.hashCode(entry.key) >>> 64 - newBucketDepth & 1L) == 0L) {
                bucket.appendEntry(entry.hashCode, entry.key, entry.value);
                continue;
            }
            newBucket.appendEntry(entry.hashCode, entry.key, entry.value);
        }
        assert (this.checkBucketDepth(bucket));
        assert (this.checkBucketDepth(newBucket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OHashTable.BucketSplitResult splitBucket(OHashIndexBucket<K, V> bucket, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        int bucketDepth = bucket.getDepth();
        int newBucketDepth = bucketDepth + 1;
        long updatedBucketIndex = pageIndex;
        OCacheEntry newBucketCacheEntry = this.addPage(atomicOperation, this.fileId);
        try {
            OHashIndexBucket<K, V> newBucket = new OHashIndexBucket<K, V>(newBucketDepth, newBucketCacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.encryption);
            this.splitBucketContent(bucket, newBucket, newBucketDepth);
            long updatedBucketPointer = OLocalHashTable.createBucketPointer(updatedBucketIndex);
            long newBucketPointer = OLocalHashTable.createBucketPointer(newBucketCacheEntry.getPageIndex());
            OHashTable.BucketSplitResult bucketSplitResult = new OHashTable.BucketSplitResult(updatedBucketPointer, newBucketPointer, newBucketDepth);
            return bucketSplitResult;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, newBucketCacheEntry);
        }
    }

    private boolean checkBucketDepth(OHashIndexBucket<K, V> bucket) {
        int bucketDepth = bucket.getDepth();
        if (bucket.size() == 0) {
            return true;
        }
        Iterator<OHashIndexBucket.Entry<K, V>> positionIterator = bucket.iterator();
        long firstValue = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
        while (positionIterator.hasNext()) {
            long value = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
            if (value == firstValue) continue;
            return false;
        }
        return true;
    }

    private void updateBucket(int nodeIndex, int itemIndex, int offset, long newBucketPointer, OAtomicOperation atomicOperation) throws IOException {
        long position = this.directory.getNodePointer(nodeIndex, itemIndex + offset, atomicOperation);
        if (position >= 0L) {
            this.directory.setNodePointer(nodeIndex, itemIndex + offset, newBucketPointer, atomicOperation);
        } else {
            int childNodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            int childOffset = (int)(position & 0xFFL);
            byte childNodeDepth = this.directory.getNodeLocalDepth(childNodeIndex, atomicOperation);
            int interval = 1 << childNodeDepth;
            for (int i = 0; i < interval; ++i) {
                this.updateBucket(childNodeIndex, i, childOffset, newBucketPointer, atomicOperation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHashTreeState(OAtomicOperation atomicOperation) throws IOException {
        this.truncateFile(atomicOperation, this.fileId);
        for (long pageIndex = 0L; pageIndex < 256L; ++pageIndex) {
            OCacheEntry cacheEntry = this.addPage(atomicOperation, this.fileId);
            assert (cacheEntry.getPageIndex() == pageIndex);
            try {
                OHashIndexBucket<K, V> oHashIndexBucket = new OHashIndexBucket<K, V>(8, cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.encryption);
                continue;
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
        }
        long[] rootTree = new long[256];
        for (int pageIndex = 0; pageIndex < 256; ++pageIndex) {
            rootTree[pageIndex] = OLocalHashTable.createBucketPointer(pageIndex);
        }
        this.directory.clear(atomicOperation);
        this.directory.addNewNode((byte)0, (byte)0, (byte)8, rootTree, atomicOperation);
        OCacheEntry hashStateEntry = this.loadPageForWrite(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true, true);
        try {
            OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, false);
            metadataPage.setRecordsCount(0L);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, hashStateEntry);
        }
    }

    private static long createBucketPointer(long pageIndex) {
        return pageIndex + 1L;
    }

    private static long getPageIndex(long bucketPointer) {
        return bucketPointer - 1L;
    }

    private OHashTable.BucketPath getBucket(long hashCode, OAtomicOperation atomicOperation) throws IOException {
        int localNodeDepth;
        int nodeDepth = localNodeDepth = this.directory.getNodeLocalDepth(0, atomicOperation);
        int nodeIndex = 0;
        int offset = 0;
        int index = (int)(hashCode >>> 64 - nodeDepth & (long)(255 >>> 8 - localNodeDepth));
        OHashTable.BucketPath currentNode = new OHashTable.BucketPath(null, 0, index, 0, localNodeDepth, nodeDepth);
        do {
            long position;
            if ((position = this.directory.getNodePointer(nodeIndex, index + offset, atomicOperation)) >= 0L) {
                return currentNode;
            }
            nodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            offset = (int)(position & 0xFFL);
            localNodeDepth = this.directory.getNodeLocalDepth(nodeIndex, atomicOperation);
            index = (int)(hashCode >>> 64 - (nodeDepth += localNodeDepth) & (long)(255 >>> 8 - localNodeDepth));
            OHashTable.BucketPath parentNode = currentNode;
            currentNode = new OHashTable.BucketPath(parentNode, offset, index, nodeIndex, localNodeDepth, nodeDepth);
        } while (nodeDepth <= 64);
        throw new IllegalStateException("Extendible hashing tree in corrupted state.");
    }
}

