/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.hashindex.local.ODirectoryFirstPage;
import com.orientechnologies.orient.core.storage.index.hashindex.local.ODirectoryPage;
import java.io.IOException;

public class OHashTableDirectory
extends ODurableComponent {
    static final int ITEM_SIZE = 8;
    private static final int LEVEL_SIZE = 256;
    static final int BINARY_LEVEL_SIZE = 2051;
    private long fileId;
    private final long firstEntryIndex;

    OHashTableDirectory(String defaultExtension, String name, String lockName, OAbstractPaginatedStorage storage) {
        super(storage, name, defaultExtension, lockName);
        this.firstEntryIndex = 0L;
    }

    public void create(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.addFile(atomicOperation, this.getFullName());
        this.init(atomicOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry firstEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true);
        if (firstEntry == null) {
            firstEntry = this.addPage(atomicOperation, this.fileId);
            assert (firstEntry.getPageIndex() == 0L);
        }
        this.pinPage(atomicOperation, firstEntry);
        try {
            ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, firstEntry);
            firstPage.setTreeSize(0);
            firstPage.setTombstone(-1);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, firstEntry);
        }
    }

    public void open(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.openFile(atomicOperation, this.getFullName());
        int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
        for (int i = 0; i < filledUpTo; ++i) {
            OCacheEntry entry = this.loadPageForRead(atomicOperation, this.fileId, i, true);
            assert (entry != null);
            this.pinPage(atomicOperation, entry);
            this.releasePageFromRead(atomicOperation, entry);
        }
    }

    public void close() throws IOException {
        this.readCache.closeFile(this.fileId, true, this.writeCache);
    }

    public void delete(OAtomicOperation atomicOperation) throws IOException {
        this.deleteFile(atomicOperation, this.fileId);
    }

    void deleteWithoutOpen(OAtomicOperation atomicOperation) throws IOException {
        if (this.isFileExists(atomicOperation, this.getFullName())) {
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            this.deleteFile(atomicOperation, this.fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addNewNode(byte maxLeftChildDepth, byte maxRightChildDepth, byte nodeLocalDepth, long[] newNode, OAtomicOperation atomicOperation) throws IOException {
        int nodeIndex;
        block15: {
            OCacheEntry firstEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true);
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, firstEntry);
                int tombstone = firstPage.getTombstone();
                if (tombstone >= 0) {
                    nodeIndex = tombstone;
                } else {
                    nodeIndex = firstPage.getTreeSize();
                    firstPage.setTreeSize(nodeIndex + 1);
                }
                if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                    int localNodeIndex = nodeIndex;
                    firstPage.setMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth);
                    firstPage.setMaxRightChildDepth(localNodeIndex, maxRightChildDepth);
                    firstPage.setNodeLocalDepth(localNodeIndex, nodeLocalDepth);
                    if (tombstone >= 0) {
                        firstPage.setTombstone((int)firstPage.getPointer(nodeIndex, 0));
                    }
                    for (int i = 0; i < newNode.length; ++i) {
                        firstPage.setPointer(localNodeIndex, i, newNode[i]);
                    }
                    break block15;
                }
                int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                int localLevel = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true, true);
                while (cacheEntry == null || cacheEntry.getPageIndex() < (long)pageIndex) {
                    if (cacheEntry != null) {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    cacheEntry = this.addPage(atomicOperation, this.fileId);
                }
                try {
                    ODirectoryPage page = new ODirectoryPage(cacheEntry, cacheEntry);
                    page.setMaxLeftChildDepth(localLevel, maxLeftChildDepth);
                    page.setMaxRightChildDepth(localLevel, maxRightChildDepth);
                    page.setNodeLocalDepth(localLevel, nodeLocalDepth);
                    if (tombstone >= 0) {
                        firstPage.setTombstone((int)page.getPointer(localLevel, 0));
                    }
                    for (int i = 0; i < newNode.length; ++i) {
                        page.setPointer(localLevel, i, newNode[i]);
                    }
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, firstEntry);
            }
        }
        return nodeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteNode(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        block7: {
            OCacheEntry firstEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true);
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, firstEntry);
                if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                    firstPage.setPointer(nodeIndex, 0, firstPage.getTombstone());
                    firstPage.setTombstone(nodeIndex);
                    break block7;
                }
                int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                int localNodeIndex = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true, true);
                try {
                    ODirectoryPage page = new ODirectoryPage(cacheEntry, cacheEntry);
                    page.setPointer(localNodeIndex, 0, firstPage.getTombstone());
                    firstPage.setTombstone(nodeIndex);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, firstEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getMaxLeftChildDepth(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            byte by = page.getMaxLeftChildDepth(OHashTableDirectory.getLocalNodeIndex(nodeIndex));
            return by;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxLeftChildDepth(int nodeIndex, byte maxLeftChildDepth, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setMaxLeftChildDepth(OHashTableDirectory.getLocalNodeIndex(nodeIndex), maxLeftChildDepth);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getMaxRightChildDepth(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            byte by = page.getMaxRightChildDepth(OHashTableDirectory.getLocalNodeIndex(nodeIndex));
            return by;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxRightChildDepth(int nodeIndex, byte maxRightChildDepth, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setMaxRightChildDepth(OHashTableDirectory.getLocalNodeIndex(nodeIndex), maxRightChildDepth);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getNodeLocalDepth(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            byte by = page.getNodeLocalDepth(OHashTableDirectory.getLocalNodeIndex(nodeIndex));
            return by;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeLocalDepth(int nodeIndex, byte localNodeDepth, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setNodeLocalDepth(OHashTableDirectory.getLocalNodeIndex(nodeIndex), localNodeDepth);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getNode(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        long[] node = new long[256];
        ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            int localNodeIndex = OHashTableDirectory.getLocalNodeIndex(nodeIndex);
            for (int i = 0; i < 256; ++i) {
                node[i] = page.getPointer(localNodeIndex, i);
            }
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNode(int nodeIndex, long[] node, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            int localNodeIndex = OHashTableDirectory.getLocalNodeIndex(nodeIndex);
            for (int i = 0; i < 256; ++i) {
                page.setPointer(localNodeIndex, i, node[i]);
            }
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNodePointer(int nodeIndex, int index, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            long l = page.getPointer(OHashTableDirectory.getLocalNodeIndex(nodeIndex), index);
            return l;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodePointer(int nodeIndex, int index, long pointer, OAtomicOperation atomicOperation) throws IOException {
        ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setPointer(OHashTableDirectory.getLocalNodeIndex(nodeIndex), index, pointer);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    public void clear(OAtomicOperation atomicOperation) throws IOException {
        this.truncateFile(atomicOperation, this.fileId);
        this.init(atomicOperation);
    }

    public void flush() {
        this.writeCache.flush(this.fileId);
    }

    private ODirectoryPage loadPage(int nodeIndex, boolean exclusiveLock, OAtomicOperation atomicOperation) throws IOException {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            OCacheEntry cacheEntry = exclusiveLock ? this.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true) : this.loadPageForRead(atomicOperation, this.fileId, this.firstEntryIndex, true);
            return new ODirectoryFirstPage(cacheEntry, cacheEntry);
        }
        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
        OCacheEntry cacheEntry = exclusiveLock ? this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true, true) : this.loadPageForRead(atomicOperation, this.fileId, pageIndex, true);
        return new ODirectoryPage(cacheEntry, cacheEntry);
    }

    private void releasePage(ODirectoryPage page, boolean exclusiveLock, OAtomicOperation atomicOperation) {
        OCacheEntry cacheEntry = page.getEntry();
        if (exclusiveLock) {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        } else {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private static int getLocalNodeIndex(int nodeIndex) {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            return nodeIndex;
        }
        return (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
    }
}

