/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas;

import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWALChannelFile;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWALFdFile;
import com.sun.jna.LastErrorException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public interface OWALFile
extends Closeable {
    public void force(boolean var1) throws IOException;

    public int write(ByteBuffer var1) throws IOException;

    public long position() throws IOException;

    public void position(long var1) throws IOException;

    public void readBuffer(ByteBuffer var1) throws IOException;

    public static OWALFile createWriteWALFile(Path path, boolean allowDirectIO, int blockSize) throws IOException {
        if (allowDirectIO) {
            try {
                int fd = ONative.instance().open(path.toAbsolutePath().toString(), 17601);
                return new OWALFdFile(fd, blockSize);
            }
            catch (LastErrorException e) {
                OLogManager.instance().errorNoDb(OWALFile.class, "Can not open file using Linux API, Java FileChannel will be used instead", e, new Object[0]);
            }
        }
        Files.deleteIfExists(path);
        return new OWALChannelFile(FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND));
    }

    public static OWALFile createReadWALFile(Path path, boolean allowDirectIO, int blockSize) throws IOException {
        if (allowDirectIO) {
            try {
                int fd = ONative.instance().open(path.toAbsolutePath().toString(), 16384);
                return new OWALFdFile(fd, blockSize);
            }
            catch (LastErrorException e) {
                OLogManager.instance().errorNoDb(OWALFile.class, "Can not open file using Linux API, Java FileChannel will be used instead", e, new Object[0]);
            }
        }
        return new OWALChannelFile(FileChannel.open(path, StandardOpenOption.READ));
    }
}

