/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWriteableWALRecord;
import com.sun.jna.Native;
import java.nio.ByteBuffer;

public abstract class OAbstractWALRecord
implements OWriteableWALRecord {
    protected volatile OLogSequenceNumber lsn;
    private int distance = 0;
    private int diskSize = 0;
    private ByteBuffer binaryContent;
    private int binaryContentLen = -1;
    private long pointer;
    private boolean written;

    protected OAbstractWALRecord() {
    }

    protected OAbstractWALRecord(OLogSequenceNumber previousCheckpoint) {
        this.lsn = previousCheckpoint;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    @Override
    public void setBinaryContent(ByteBuffer buffer, long pointer) {
        this.binaryContent = buffer;
        this.pointer = pointer;
        this.binaryContentLen = buffer.limit();
    }

    @Override
    public ByteBuffer getBinaryContent() {
        return this.binaryContent;
    }

    @Override
    public void freeBinaryContent() {
        if (this.pointer > 0L) {
            Native.free((long)this.pointer);
        }
        this.pointer = 0L;
        this.binaryContent = null;
    }

    @Override
    public int getBinaryContentLen() {
        return this.binaryContentLen;
    }

    @Override
    public void setDistance(int distance) {
        this.distance = distance;
    }

    @Override
    public void setDiskSize(int diskSize) {
        this.diskSize = diskSize;
    }

    @Override
    public int getDistance() {
        if (this.distance <= 0) {
            throw new IllegalStateException("Record distance is not set");
        }
        return this.distance;
    }

    @Override
    public int getDiskSize() {
        if (this.diskSize <= 0) {
            throw new IllegalStateException("Record disk size is not set");
        }
        return this.diskSize;
    }

    @Override
    public void written() {
        this.written = true;
    }

    @Override
    public boolean isWritten() {
        return this.written;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAbstractWALRecord that = (OAbstractWALRecord)o;
        return !(this.lsn != null ? !this.lsn.equals(that.lsn) : that.lsn != null);
    }

    public int hashCode() {
        return this.lsn != null ? this.lsn.hashCode() : 0;
    }

    public String toString() {
        return this.toString(null);
    }

    protected String toString(String iToAppend) {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append("{lsn=").append(this.lsn);
        if (iToAppend != null) {
            buffer.append(", ");
            buffer.append(iToAppend);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

