/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.config;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationUpdateListener;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPaginatedClusterFactory;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OCellBTreeSingleValue;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public final class OClusterBasedStorageConfiguration
implements OStorageConfiguration {
    public static final String MAP_FILE_EXTENSION = ".ccm";
    public static final String DATA_FILE_EXTENSION = ".cd";
    public static final String TREE_DATA_FILE_EXTENSION = ".bd";
    public static final String TREE_NULL_FILE_EXTENSION = ".nd";
    public static final String COMPONENT_NAME = "config";
    private static final String VERSION_PROPERTY = "version";
    private static final String SCHEMA_RECORD_ID_PROPERTY = "schemaRecordId";
    private static final String INDEX_MANAGER_RECORD_ID_PROPERTY = "indexManagerRecordId";
    private static final String LOCALE_LANGUAGE_PROPERTY = "localeLanguage";
    private static final String LOCALE_COUNTRY_PROPERTY = "localeCountry";
    private static final String LOCALE_PROPERTY_INSTANCE = "localeInstance";
    private static final String DATE_FORMAT_PROPERTY = "dateFormat";
    private static final String DATE_TIME_FORMAT_PROPERTY = "dateTimeFormat";
    private static final String TIME_ZONE_PROPERTY = "timeZone";
    private static final String CHARSET_PROPERTY = "charset";
    private static final String CONFLICT_STRATEGY_PROPERTY = "conflictStrategy";
    private static final String BINARY_FORMAT_VERSION_PROPERTY = "binaryFormatVersion";
    private static final String CLUSTER_SELECTION_PROPERTY = "clusterSelection";
    private static final String MINIMUM_CLUSTERS_PROPERTY = "minimumClusters";
    private static final String RECORD_SERIALIZER_PROPERTY = "recordSerializer";
    private static final String RECORD_SERIALIZER_VERSION_PROPERTY = "recordSerializerVersion";
    private static final String CONFIGURATION_PROPERTY = "configuration";
    private static final String CREATED_AT_VERSION_PROPERTY = "createAtVersion";
    private static final String PAGE_SIZE_PROPERTY = "pageSize";
    private static final String FREE_LIST_BOUNDARY_PROPERTY = "freeListBoundary";
    private static final String MAX_KEY_SIZE_PROPERTY = "maxKeySize";
    private static final String CLUSTERS_PREFIX_PROPERTY = "cluster_";
    private static final String PROPERTY_PREFIX_PROPERTY = "property_";
    private static final String ENGINE_PREFIX_PROPERTY = "engine_";
    private static final String PROPERTIES = "properties";
    private static final String CLUSTERS = "clusters";
    private static final String[] INT_PROPERTIES = new String[]{"minimumClusters", "version", "binaryFormatVersion", "recordSerializerVersion", "pageSize", "freeListBoundary", "maxKeySize"};
    private static final String[] STRING_PROPERTIES = new String[]{"schemaRecordId", "indexManagerRecordId", "localeLanguage", "localeCountry", "dateFormat", "dateTimeFormat", "timeZone", "charset", "conflictStrategy", "clusterSelection", "recordSerializer", "createAtVersion"};
    private OContextConfiguration configuration;
    private boolean validation;
    private final OCellBTreeSingleValue<String> btree;
    private final OPaginatedCluster cluster;
    private final OAbstractPaginatedStorage storage;
    private final OAtomicOperationsManager atomicOperationsManager;
    private final OReadersWriterSpinLock lock = new OReadersWriterSpinLock();
    private final HashMap<String, Object> cache = new HashMap();
    private OStorageConfigurationUpdateListener updateListener;
    private final ThreadLocal<PausedNotificationsState> pauseNotifications = ThreadLocal.withInitial(() -> new PausedNotificationsState());

    public static boolean exists(OWriteCache writeCache) {
        return writeCache.exists("config.cd");
    }

    public OClusterBasedStorageConfiguration(OAbstractPaginatedStorage storage) {
        this.cluster = OPaginatedClusterFactory.createCluster(COMPONENT_NAME, OPaginatedCluster.getLatestBinaryVersion(), storage, DATA_FILE_EXTENSION, MAP_FILE_EXTENSION);
        this.btree = new OCellBTreeSingleValue(COMPONENT_NAME, TREE_DATA_FILE_EXTENSION, TREE_NULL_FILE_EXTENSION, storage);
        this.atomicOperationsManager = storage.getAtomicOperationsManager();
        this.storage = storage;
    }

    public void create(OContextConfiguration contextConfiguration) throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.cluster.create(-1);
            this.btree.create(OStringSerializer.INSTANCE, null, 1, null);
            this.configuration = contextConfiguration;
            this.init();
            this.preloadIntProperties();
            this.preloadStringProperties();
            this.preloadClusters();
            this.preloadConfigurationProperties();
            this.setValidation(this.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.DB_VALIDATION));
            this.recalculateLocale();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void create(OContextConfiguration contextConfiguration, OStorageConfiguration source) throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.create(contextConfiguration);
            this.copy(source);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void delete() throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.updateListener = null;
            this.cluster.delete();
            this.btree.delete();
            this.cache.clear();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void close() {
        this.lock.acquireWriteLock();
        try {
            this.updateListener = null;
            this.updateConfigurationProperty();
            this.updateMinimumClusters();
            this.cache.clear();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void load(OContextConfiguration configuration) throws OSerializationException, IOException {
        this.lock.acquireWriteLock();
        try {
            this.configuration = configuration;
            this.cluster.open();
            this.btree.load(COMPONENT_NAME, 1, null, OStringSerializer.INSTANCE, null);
            this.readConfiguration();
            this.readMinimumClusters();
            this.preloadIntProperties();
            this.preloadStringProperties();
            this.preloadConfigurationProperties();
            this.preloadClusters();
            this.recalculateLocale();
            this.validation = "true".equalsIgnoreCase(this.getProperty("validation"));
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void pauseUpdateNotifications() {
        this.lock.acquireWriteLock();
        try {
            PausedNotificationsState pausedNotificationsState = this.pauseNotifications.get();
            pausedNotificationsState.notificationsPaused = true;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void fireUpdateNotifications() {
        this.lock.acquireWriteLock();
        try {
            PausedNotificationsState pausedNotificationsState = this.pauseNotifications.get();
            if (pausedNotificationsState.pendingChanges > 0L && this.updateListener != null) {
                this.updateListener.onUpdate(this);
                pausedNotificationsState.pendingChanges = 0L;
            }
            pausedNotificationsState.notificationsPaused = false;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void setMinimumClusters(int minimumClusters) {
        this.lock.acquireWriteLock();
        try {
            this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)minimumClusters);
            this.autoInitClusters();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void updateMinimumClusters() {
        this.updateIntProperty(MINIMUM_CLUSTERS_PROPERTY, this.getMinimumClusters());
    }

    private void readMinimumClusters() {
        if (this.containsProperty(MINIMUM_CLUSTERS_PROPERTY)) {
            this.setMinimumClusters(this.readIntProperty(MINIMUM_CLUSTERS_PROPERTY, false));
        }
    }

    @Override
    public int getMinimumClusters() {
        this.lock.acquireReadLock();
        try {
            int mc = this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS);
            if (mc == 0) {
                this.autoInitClusters();
                int n = (Integer)this.getContextConfiguration().getValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS);
                return n;
            }
            int n = mc;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public OContextConfiguration getContextConfiguration() {
        this.lock.acquireReadLock();
        try {
            OContextConfiguration oContextConfiguration = this.configuration;
            return oContextConfiguration;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toStream(int iNetworkVersion, Charset charset) throws OSerializationException {
        this.lock.acquireReadLock();
        try {
            StringBuilder buffer = new StringBuilder(8192);
            OClusterBasedStorageConfiguration.write(buffer, 22);
            OClusterBasedStorageConfiguration.write(buffer, null);
            OClusterBasedStorageConfiguration.write(buffer, this.getSchemaRecordId());
            OClusterBasedStorageConfiguration.write(buffer, "");
            OClusterBasedStorageConfiguration.write(buffer, this.getIndexMgrRecordId());
            OClusterBasedStorageConfiguration.write(buffer, this.getLocaleLanguage());
            OClusterBasedStorageConfiguration.write(buffer, this.getLocaleCountry());
            OClusterBasedStorageConfiguration.write(buffer, this.getDateFormat());
            OClusterBasedStorageConfiguration.write(buffer, this.getDateFormat());
            TimeZone timeZone = this.getTimeZone();
            assert (timeZone != null);
            OClusterBasedStorageConfiguration.write(buffer, timeZone);
            OClusterBasedStorageConfiguration.write(buffer, charset);
            if (iNetworkVersion > 24) {
                OClusterBasedStorageConfiguration.write(buffer, this.getConflictStrategy());
            }
            OClusterBasedStorageConfiguration.phySegmentToStream(buffer, new OStorageSegmentConfiguration());
            List<OStorageClusterConfiguration> clusters = this.getClusters();
            OClusterBasedStorageConfiguration.write(buffer, clusters.size());
            for (OStorageClusterConfiguration oStorageClusterConfiguration : clusters) {
                if (oStorageClusterConfiguration == null) {
                    OClusterBasedStorageConfiguration.write(buffer, -1);
                    continue;
                }
                OClusterBasedStorageConfiguration.write(buffer, oStorageClusterConfiguration.getId());
                OClusterBasedStorageConfiguration.write(buffer, oStorageClusterConfiguration.getName());
                OClusterBasedStorageConfiguration.write(buffer, oStorageClusterConfiguration.getDataSegmentId());
                if (!(oStorageClusterConfiguration instanceof OStoragePaginatedClusterConfiguration)) continue;
                OClusterBasedStorageConfiguration.write(buffer, "d");
                OStoragePaginatedClusterConfiguration paginatedClusterConfiguration = (OStoragePaginatedClusterConfiguration)oStorageClusterConfiguration;
                OClusterBasedStorageConfiguration.write(buffer, paginatedClusterConfiguration.useWal);
                OClusterBasedStorageConfiguration.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordOverflowGrowFactor));
                OClusterBasedStorageConfiguration.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordGrowFactor));
                OClusterBasedStorageConfiguration.write(buffer, paginatedClusterConfiguration.compression);
                if (iNetworkVersion >= 31) {
                    OClusterBasedStorageConfiguration.write(buffer, paginatedClusterConfiguration.encryption);
                }
                if (iNetworkVersion > 24) {
                    OClusterBasedStorageConfiguration.write(buffer, paginatedClusterConfiguration.conflictStrategy);
                }
                if (iNetworkVersion > 25) {
                    OClusterBasedStorageConfiguration.write(buffer, paginatedClusterConfiguration.getStatus().name());
                }
                if (iNetworkVersion < Integer.MAX_VALUE) continue;
                OClusterBasedStorageConfiguration.write(buffer, paginatedClusterConfiguration.getBinaryVersion());
            }
            if (iNetworkVersion <= 25) {
                OClusterBasedStorageConfiguration.write(buffer, 0);
                OClusterBasedStorageConfiguration.write(buffer, "");
                OClusterBasedStorageConfiguration.write(buffer, "");
                OClusterBasedStorageConfiguration.write(buffer, 0);
                OClusterBasedStorageConfiguration.write(buffer, false);
                OClusterBasedStorageConfiguration.write(buffer, false);
            }
            List<OStorageEntryConfiguration> properties = this.getProperties();
            OClusterBasedStorageConfiguration.write(buffer, properties.size());
            for (OStorageEntryConfiguration e : properties) {
                OClusterBasedStorageConfiguration.entryToStream(buffer, e);
            }
            OClusterBasedStorageConfiguration.write(buffer, this.getBinaryFormatVersion());
            OClusterBasedStorageConfiguration.write(buffer, this.getClusterSelection());
            OClusterBasedStorageConfiguration.write(buffer, this.getMinimumClusters());
            if (iNetworkVersion > 24) {
                OClusterBasedStorageConfiguration.write(buffer, this.getRecordSerializer());
                OClusterBasedStorageConfiguration.write(buffer, this.getRecordSerializerVersion());
                OClusterBasedStorageConfiguration.write(buffer, this.configuration.getContextSize());
                for (String k : this.configuration.getContextKeys()) {
                    OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(k);
                    OClusterBasedStorageConfiguration.write(buffer, k);
                    if (cfg != null) {
                        OClusterBasedStorageConfiguration.write(buffer, cfg.isHidden() ? null : this.configuration.getValueAsString(cfg));
                        continue;
                    }
                    OClusterBasedStorageConfiguration.write(buffer, null);
                    OLogManager.instance().warn((Object)this, "Storing configuration for property:'" + k + "' not existing in current version", new Object[0]);
                }
            }
            List<OStorageConfiguration.IndexEngineData> list = this.loadIndexEngines();
            OClusterBasedStorageConfiguration.write(buffer, list.size());
            for (OStorageConfiguration.IndexEngineData engineData : list) {
                OClusterBasedStorageConfiguration.write(buffer, engineData.getName());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getAlgorithm());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getIndexType() == null ? "" : engineData.getIndexType());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getValueSerializerId());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getKeySerializedId());
                OClusterBasedStorageConfiguration.write(buffer, engineData.isAutomatic());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getDurableInNonTxMode());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getVersion());
                OClusterBasedStorageConfiguration.write(buffer, engineData.isNullValuesSupport());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getKeySize());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getEncryption());
                OClusterBasedStorageConfiguration.write(buffer, engineData.getEncryptionOptions());
                if (engineData.getKeyTypes() != null) {
                    OClusterBasedStorageConfiguration.write(buffer, engineData.getKeyTypes().length);
                    for (OType type : engineData.getKeyTypes()) {
                        OClusterBasedStorageConfiguration.write(buffer, type.name());
                    }
                } else {
                    OClusterBasedStorageConfiguration.write(buffer, 0);
                }
                if (engineData.getEngineProperties() == null) {
                    OClusterBasedStorageConfiguration.write(buffer, 0);
                } else {
                    OClusterBasedStorageConfiguration.write(buffer, engineData.getEngineProperties().size());
                    for (Map.Entry entry : engineData.getEngineProperties().entrySet()) {
                        OClusterBasedStorageConfiguration.write(buffer, entry.getKey());
                        OClusterBasedStorageConfiguration.write(buffer, entry.getValue());
                    }
                }
                OClusterBasedStorageConfiguration.write(buffer, engineData.getApiVersion());
                OClusterBasedStorageConfiguration.write(buffer, engineData.isMultivalue());
            }
            OClusterBasedStorageConfiguration.write(buffer, this.getCreatedAtVersion());
            OClusterBasedStorageConfiguration.write(buffer, this.getPageSize());
            OClusterBasedStorageConfiguration.write(buffer, this.getFreeListBoundary());
            OClusterBasedStorageConfiguration.write(buffer, this.getMaxKeySize());
            buffer.append("|");
            Object object = buffer.toString().getBytes(charset);
            return object;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private static void entryToStream(StringBuilder buffer, OStorageEntryConfiguration entry) {
        OClusterBasedStorageConfiguration.write(buffer, entry.name);
        OClusterBasedStorageConfiguration.write(buffer, entry.value);
    }

    private static void phySegmentToStream(StringBuilder buffer, OStorageSegmentConfiguration segment) {
        OClusterBasedStorageConfiguration.write(buffer, segment.getLocation());
        OClusterBasedStorageConfiguration.write(buffer, segment.maxSize);
        OClusterBasedStorageConfiguration.write(buffer, segment.fileType);
        OClusterBasedStorageConfiguration.write(buffer, segment.fileStartSize);
        OClusterBasedStorageConfiguration.write(buffer, segment.fileMaxSize);
        OClusterBasedStorageConfiguration.write(buffer, segment.fileIncrementSize);
        OClusterBasedStorageConfiguration.write(buffer, segment.defrag);
        OClusterBasedStorageConfiguration.write(buffer, segment.infoFiles.length);
        for (OStorageFileConfiguration f : segment.infoFiles) {
            OClusterBasedStorageConfiguration.fileToStream(buffer, f);
        }
    }

    private static void fileToStream(StringBuilder iBuffer, OStorageFileConfiguration iFile) {
        OClusterBasedStorageConfiguration.write(iBuffer, iFile.path);
        OClusterBasedStorageConfiguration.write(iBuffer, iFile.type);
        OClusterBasedStorageConfiguration.write(iBuffer, iFile.maxSize);
    }

    private static void write(StringBuilder buffer, Object value) {
        if (buffer.length() > 0) {
            buffer.append('|');
        }
        buffer.append(value != null ? value.toString() : Character.valueOf(' '));
    }

    private void updateVersion() {
        this.updateIntProperty(VERSION_PROPERTY, 22);
    }

    private void updateVersion(int version) {
        this.updateIntProperty(VERSION_PROPERTY, version);
    }

    @Override
    public int getVersion() {
        this.lock.acquireReadLock();
        try {
            int n = this.readIntProperty(VERSION_PROPERTY, true);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public String getName() {
        return null;
    }

    public void setSchemaRecordId(String schemaRecordId) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(SCHEMA_RECORD_ID_PROPERTY, schemaRecordId, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getSchemaRecordId() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(SCHEMA_RECORD_ID_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(INDEX_MANAGER_RECORD_ID_PROPERTY, indexMgrRecordId, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getIndexMgrRecordId() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(INDEX_MANAGER_RECORD_ID_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setLocaleLanguage(String value) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(LOCALE_LANGUAGE_PROPERTY, value, true);
            this.recalculateLocale();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getLocaleLanguage() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(LOCALE_LANGUAGE_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setLocaleCountry(String value) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(LOCALE_COUNTRY_PROPERTY, value, true);
            this.recalculateLocale();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getLocaleCountry() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(LOCALE_COUNTRY_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setDateFormat(String dateFormat) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(DATE_FORMAT_PROPERTY, dateFormat, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getDateFormat() {
        this.lock.acquireReadLock();
        try {
            String dateFormat = this.readStringProperty(DATE_FORMAT_PROPERTY);
            assert (dateFormat != null);
            String string = dateFormat;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleDateFormat getDateFormatInstance() {
        this.lock.acquireReadLock();
        try {
            SimpleDateFormat dateFormatInstance = new SimpleDateFormat(this.getDateFormat());
            dateFormatInstance.setLenient(false);
            TimeZone timeZone = this.getTimeZone();
            if (timeZone != null) {
                dateFormatInstance.setTimeZone(timeZone);
            }
            SimpleDateFormat simpleDateFormat = dateFormatInstance;
            return simpleDateFormat;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public String getDateTimeFormat() {
        this.lock.acquireReadLock();
        try {
            String dateTimeFormat = this.readStringProperty(DATE_TIME_FORMAT_PROPERTY);
            assert (dateTimeFormat != null);
            String string = dateTimeFormat;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(DATE_TIME_FORMAT_PROPERTY, dateTimeFormat, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleDateFormat getDateTimeFormatInstance() {
        this.lock.acquireReadLock();
        try {
            SimpleDateFormat dateTimeFormatInstance = new SimpleDateFormat(this.getDateTimeFormat());
            dateTimeFormatInstance.setLenient(false);
            TimeZone timeZone = this.getTimeZone();
            if (timeZone != null) {
                dateTimeFormatInstance.setTimeZone(timeZone);
            }
            SimpleDateFormat simpleDateFormat = dateTimeFormatInstance;
            return simpleDateFormat;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(TIME_ZONE_PROPERTY, timeZone.getID(), true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public TimeZone getTimeZone() {
        this.lock.acquireReadLock();
        try {
            String timeZone = this.readStringProperty(TIME_ZONE_PROPERTY);
            if (timeZone == null) {
                TimeZone timeZone2 = null;
                return timeZone2;
            }
            TimeZone timeZone3 = TimeZone.getTimeZone(timeZone);
            return timeZone3;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setCharset(String charset) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(CHARSET_PROPERTY, charset, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getCharset() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(CHARSET_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setConflictStrategy(String conflictStrategy) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(CONFLICT_STRATEGY_PROPERTY, conflictStrategy, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getConflictStrategy() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(CONFLICT_STRATEGY_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private void updateBinaryFormatVersion() {
        this.updateIntProperty(BINARY_FORMAT_VERSION_PROPERTY, 13);
    }

    private void updateBinaryFormatVersion(int version) {
        this.updateIntProperty(BINARY_FORMAT_VERSION_PROPERTY, version);
    }

    @Override
    public int getBinaryFormatVersion() {
        this.lock.acquireReadLock();
        try {
            int n = this.readIntProperty(BINARY_FORMAT_VERSION_PROPERTY, true);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setClusterSelection(String clusterSelection) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(CLUSTER_SELECTION_PROPERTY, clusterSelection, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getClusterSelection() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(CLUSTER_SELECTION_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setRecordSerializer(String recordSerializer) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(RECORD_SERIALIZER_PROPERTY, recordSerializer, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getRecordSerializer() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(RECORD_SERIALIZER_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setRecordSerializerVersion(int recordSerializerVersion) {
        this.lock.acquireWriteLock();
        try {
            this.updateIntProperty(RECORD_SERIALIZER_VERSION_PROPERTY, recordSerializerVersion);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getRecordSerializerVersion() {
        this.lock.acquireReadLock();
        try {
            int n = this.readIntProperty(RECORD_SERIALIZER_VERSION_PROPERTY, true);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private void updateConfigurationProperty() {
        ArrayList<byte[]> entries = new ArrayList<byte[]>(8);
        int totalSize = 0;
        byte[] contextSize = new byte[4];
        totalSize += contextSize.length;
        entries.add(contextSize);
        OIntegerSerializer.INSTANCE.serializeNative(this.configuration.getContextSize(), contextSize, 0, new Object[0]);
        for (String k : this.configuration.getContextKeys()) {
            byte[] value;
            OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(k);
            byte[] key = OClusterBasedStorageConfiguration.serializeStringValue(k);
            totalSize += key.length;
            entries.add(key);
            if (cfg != null) {
                value = OClusterBasedStorageConfiguration.serializeStringValue(cfg.isHidden() ? null : this.configuration.getValueAsString(cfg));
                totalSize += value.length;
                entries.add(value);
                continue;
            }
            value = OClusterBasedStorageConfiguration.serializeStringValue(null);
            totalSize += value.length;
            entries.add(value);
            OLogManager.instance().warn((Object)this, "Storing configuration for property:'" + k + "' not existing in current version", new Object[0]);
        }
        byte[] property = OClusterBasedStorageConfiguration.mergeBinaryEntries(totalSize, entries);
        this.storeProperty(CONFIGURATION_PROPERTY, property);
    }

    private void readConfiguration() {
        byte[] property = this.readProperty(CONFIGURATION_PROPERTY);
        if (property == null) {
            return;
        }
        int pos = 0;
        int size = OIntegerSerializer.INSTANCE.deserializeNative(property, pos);
        pos += 4;
        for (int i = 0; i < size; ++i) {
            String key = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
            pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
            String value = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
            pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
            OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(key);
            if (cfg != null) {
                if (value == null) continue;
                this.configuration.setValue(key, OType.convert(value, cfg.getType()));
                continue;
            }
            OLogManager.instance().warn((Object)this, "Ignored storage configuration because not supported: %s=%s", key, value);
        }
    }

    public void setCreationVersion(String version) {
        this.lock.acquireWriteLock();
        try {
            this.updateStringProperty(CREATED_AT_VERSION_PROPERTY, version, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getCreatedAtVersion() {
        this.lock.acquireReadLock();
        try {
            String string = this.readStringProperty(CREATED_AT_VERSION_PROPERTY);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setPageSize(int pageSize) {
        this.lock.acquireWriteLock();
        try {
            this.updateIntProperty(PAGE_SIZE_PROPERTY, pageSize);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getPageSize() {
        this.lock.acquireReadLock();
        try {
            int n = this.readIntProperty(PAGE_SIZE_PROPERTY, true);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setFreeListBoundary(int freeListBoundary) {
        this.lock.acquireWriteLock();
        try {
            this.updateIntProperty(FREE_LIST_BOUNDARY_PROPERTY, freeListBoundary);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getFreeListBoundary() {
        this.lock.acquireReadLock();
        try {
            int n = this.readIntProperty(FREE_LIST_BOUNDARY_PROPERTY, true);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setMaxKeySize(int maxKeySize) {
        this.lock.acquireWriteLock();
        try {
            this.updateIntProperty(MAX_KEY_SIZE_PROPERTY, maxKeySize);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getMaxKeySize() {
        this.lock.acquireReadLock();
        try {
            int n = this.readIntProperty(MAX_KEY_SIZE_PROPERTY, true);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        this.lock.acquireWriteLock();
        try {
            if ("validation".equalsIgnoreCase(name)) {
                this.validation = "true".equalsIgnoreCase(value);
            }
            String key = PROPERTY_PREFIX_PROPERTY + name;
            this.updateStringProperty(key, value, false);
            Map properties = (Map)this.cache.get(PROPERTIES);
            properties.put(name, value);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void setValidation(boolean validation) {
        this.setProperty("validation", validation ? "true" : "false");
    }

    @Override
    public boolean isValidationEnabled() {
        this.lock.acquireReadLock();
        try {
            boolean bl = this.validation;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public String getDirectory() {
        if (this.storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)this.storage).getStoragePath().toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String name) {
        this.lock.acquireReadLock();
        try {
            Map properties = (Map)this.cache.get(PROPERTIES);
            String string = (String)properties.get(name);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OStorageEntryConfiguration> getProperties() {
        this.lock.acquireReadLock();
        try {
            Map properties = (Map)this.cache.get(PROPERTIES);
            ArrayList<OStorageEntryConfiguration> result = new ArrayList<OStorageEntryConfiguration>(8);
            for (Map.Entry entry : properties.entrySet()) {
                result.add(new OStorageEntryConfiguration((String)entry.getKey(), (String)entry.getValue()));
            }
            ArrayList<OStorageEntryConfiguration> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private void preloadConfigurationProperties() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(8);
        OCellBTreeSingleValue.OSBTreeCursor<String, ORID> cursor = this.btree.iterateEntriesMajor(PROPERTY_PREFIX_PROPERTY, false, true);
        Map.Entry<String, ORID> entry = cursor.next(-1);
        while (entry != null && entry.getKey().startsWith(PROPERTY_PREFIX_PROPERTY)) {
            ORawBuffer buffer = this.cluster.readRecord(entry.getValue().getClusterPosition(), false);
            properties.put(entry.getKey().substring(PROPERTY_PREFIX_PROPERTY.length()), OClusterBasedStorageConfiguration.deserializeStringValue(buffer.buffer, 0));
            entry = cursor.next(-1);
        }
        this.cache.put(PROPERTIES, properties);
    }

    @Override
    public Locale getLocaleInstance() {
        this.lock.acquireReadLock();
        try {
            Locale locale = (Locale)this.cache.get(LOCALE_PROPERTY_INSTANCE);
            return locale;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private void recalculateLocale() {
        Locale locale;
        try {
            String localeLanguage = this.getLocaleLanguage();
            String localeCountry = this.getLocaleCountry();
            locale = localeLanguage == null || localeCountry == null ? Locale.getDefault() : new Locale(this.getLocaleLanguage(), this.getLocaleCountry());
        }
        catch (RuntimeException e) {
            locale = Locale.getDefault();
        }
        this.cache.put(LOCALE_PROPERTY_INSTANCE, locale);
    }

    @Override
    public boolean isStrictSql() {
        return true;
    }

    public void clearProperties() {
        this.lock.acquireWriteLock();
        try {
            OCellBTreeSingleValue.OSBTreeCursor<String, ORID> cursor = this.btree.iterateEntriesMajor(PROPERTY_PREFIX_PROPERTY, false, true);
            ArrayList<String> keysToRemove = new ArrayList<String>(8);
            ArrayList<ORID> ridsToRemove = new ArrayList<ORID>(8);
            Map.Entry<String, ORID> entry = cursor.next(-1);
            while (entry != null && entry.getKey().startsWith(PROPERTY_PREFIX_PROPERTY)) {
                keysToRemove.add(entry.getKey());
                ridsToRemove.add(entry.getValue());
                entry = cursor.next(-1);
            }
            boolean rollback = false;
            this.atomicOperationsManager.startAtomicOperation(COMPONENT_NAME, true);
            try {
                for (String key : keysToRemove) {
                    this.btree.remove(key);
                }
                for (ORID rid : ridsToRemove) {
                    this.cluster.deleteRecord(rid.getClusterPosition());
                }
                Map properties = (Map)this.cache.get(PROPERTIES);
                properties.clear();
            }
            catch (Exception e) {
                rollback = true;
                throw e;
            }
            finally {
                this.atomicOperationsManager.endAtomicOperation(rollback);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during clear of configuration properties"), e);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void removeProperty(String name) {
        this.lock.acquireWriteLock();
        try {
            this.dropProperty(PROPERTY_PREFIX_PROPERTY + name);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexEngine(String name, OStorageConfiguration.IndexEngineData engineData) {
        this.lock.acquireWriteLock();
        try {
            ORID identifiable = this.btree.get(ENGINE_PREFIX_PROPERTY + name);
            if (identifiable != null) {
                OLogManager.instance().warn((Object)this, "Index engine with name '" + engineData.getName() + "' already contained in database configuration", new Object[0]);
            } else {
                this.storeProperty(ENGINE_PREFIX_PROPERTY + name, OClusterBasedStorageConfiguration.serializeIndexEngineProperty(engineData));
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void deleteIndexEngine(String name) {
        this.lock.acquireWriteLock();
        try {
            this.dropProperty(ENGINE_PREFIX_PROPERTY + name);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> indexEngines() {
        this.lock.acquireReadLock();
        try {
            OCellBTreeSingleValue.OSBTreeCursor<String, ORID> cursor = this.btree.iterateEntriesMajor(ENGINE_PREFIX_PROPERTY, false, true);
            HashSet<String> result = new HashSet<String>(4);
            Map.Entry<String, ORID> entry = cursor.next(-1);
            while (entry != null && entry.getKey().startsWith(ENGINE_PREFIX_PROPERTY)) {
                result.add(entry.getKey().substring(ENGINE_PREFIX_PROPERTY.length()));
                entry = cursor.next(-1);
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private List<OStorageConfiguration.IndexEngineData> loadIndexEngines() {
        try {
            OCellBTreeSingleValue.OSBTreeCursor<String, ORID> cursor = this.btree.iterateEntriesMajor(ENGINE_PREFIX_PROPERTY, false, true);
            ArrayList<OStorageConfiguration.IndexEngineData> result = new ArrayList<OStorageConfiguration.IndexEngineData>(4);
            Map.Entry<String, ORID> entry = cursor.next(-1);
            while (entry != null && entry.getKey().startsWith(ENGINE_PREFIX_PROPERTY)) {
                String name = entry.getKey().substring(ENGINE_PREFIX_PROPERTY.length());
                ORawBuffer buffer = this.cluster.readRecord(entry.getValue().getClusterPosition(), false);
                OStorageConfiguration.IndexEngineData engine = this.deserializeIndexEngineProperty(name, buffer.buffer);
                result.add(engine);
                entry = cursor.next(-1);
            }
            return result;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Can not fetch list of index engines"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageConfiguration.IndexEngineData getIndexEngine(String name) {
        this.lock.acquireReadLock();
        try {
            byte[] property = this.readProperty(ENGINE_PREFIX_PROPERTY + name);
            if (property == null) {
                OStorageConfiguration.IndexEngineData indexEngineData = null;
                return indexEngineData;
            }
            OStorageConfiguration.IndexEngineData indexEngineData = this.deserializeIndexEngineProperty(name, property);
            return indexEngineData;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCluster(OStorageClusterConfiguration config) {
        this.lock.acquireWriteLock();
        try {
            List clusters = (List)this.cache.get(CLUSTERS);
            if (config.getId() < clusters.size()) {
                clusters.set(config.getId(), config);
            } else {
                int diff = config.getId() - clusters.size();
                for (int i = 0; i < diff; ++i) {
                    clusters.add(null);
                }
                clusters.add(config);
                assert (clusters.size() - 1 == config.getId());
            }
            this.storeProperty(CLUSTERS_PREFIX_PROPERTY + config.getId(), OClusterBasedStorageConfiguration.updateClusterConfig(config));
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS status) {
        this.lock.acquireWriteLock();
        try {
            byte[] property;
            List clusters = (List)this.cache.get(CLUSTERS);
            if (clusterId < clusters.size()) {
                OStorageClusterConfiguration config = (OStorageClusterConfiguration)clusters.get(clusterId);
                config.setStatus(status);
            }
            if ((property = this.readProperty(CLUSTERS_PREFIX_PROPERTY + clusterId)) != null) {
                OStorageClusterConfiguration clusterCfg = this.deserializeStorageClusterConfig(clusterId, property);
                clusterCfg.setStatus(status);
                this.updateCluster(clusterCfg);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public List<OStorageClusterConfiguration> getClusters() {
        this.lock.acquireReadLock();
        try {
            List<OStorageClusterConfiguration> list = Collections.unmodifiableList((List)this.cache.get(CLUSTERS));
            return list;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private void preloadClusters() throws IOException {
        ArrayList<OStorageClusterConfiguration> clusters = new ArrayList<OStorageClusterConfiguration>(1024);
        OCellBTreeSingleValue.OSBTreeCursor<String, ORID> cursor = this.btree.iterateEntriesMajor(CLUSTERS_PREFIX_PROPERTY, false, true);
        Map.Entry<String, ORID> entry = cursor.next(-1);
        while (entry != null && entry.getKey().startsWith(CLUSTERS_PREFIX_PROPERTY)) {
            int id = Integer.parseInt(entry.getKey().substring(CLUSTERS_PREFIX_PROPERTY.length()));
            ORawBuffer buffer = this.cluster.readRecord(entry.getValue().getClusterPosition(), false);
            if (clusters.size() <= id) {
                int diff = id - clusters.size();
                for (int i = 0; i < diff; ++i) {
                    clusters.add(null);
                }
                clusters.add(this.deserializeStorageClusterConfig(id, buffer.buffer));
                assert (id == clusters.size() - 1);
            } else {
                clusters.set(id, this.deserializeStorageClusterConfig(id, buffer.buffer));
            }
            entry = cursor.next(-1);
        }
        this.cache.put(CLUSTERS, clusters);
    }

    public void dropCluster(int clusterId) {
        this.lock.acquireWriteLock();
        try {
            List clusters = (List)this.cache.get(CLUSTERS);
            if (clusterId < clusters.size()) {
                clusters.set(clusterId, null);
            }
            this.dropProperty(CLUSTERS_PREFIX_PROPERTY + clusterId);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void setConfigurationUpdateListener(OStorageConfigurationUpdateListener updateListener) {
        this.lock.acquireWriteLock();
        try {
            this.updateListener = updateListener;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private static byte[] serializeIndexEngineProperty(OStorageConfiguration.IndexEngineData indexEngineData) {
        int totalSize = 0;
        ArrayList<byte[]> entries = new ArrayList<byte[]>(16);
        byte[] numericProperties = new byte[17];
        totalSize += numericProperties.length;
        entries.add(numericProperties);
        int pos = 0;
        OIntegerSerializer.INSTANCE.serializeNative(indexEngineData.getVersion(), numericProperties, pos, new Object[0]);
        OIntegerSerializer.INSTANCE.serializeNative(indexEngineData.getApiVersion(), numericProperties, pos += 4, new Object[0]);
        numericProperties[pos += 4] = indexEngineData.getValueSerializerId();
        numericProperties[++pos] = indexEngineData.getKeySerializedId();
        numericProperties[++pos] = indexEngineData.isAutomatic() ? (byte)1 : 0;
        numericProperties[++pos] = indexEngineData.isNullValuesSupport() ? (byte)1 : 0;
        numericProperties[++pos] = indexEngineData.isMultivalue() ? (byte)1 : 0;
        OIntegerSerializer.INSTANCE.serializeNative(indexEngineData.getKeySize(), numericProperties, ++pos, new Object[0]);
        byte[] algorithm = OClusterBasedStorageConfiguration.serializeStringValue(indexEngineData.getAlgorithm());
        totalSize += algorithm.length;
        entries.add(algorithm);
        byte[] indexType = OClusterBasedStorageConfiguration.serializeStringValue(indexEngineData.getIndexType() == null ? "" : indexEngineData.getIndexType());
        entries.add(indexType);
        totalSize += indexType.length;
        byte[] encryption = OClusterBasedStorageConfiguration.serializeStringValue(indexEngineData.getEncryption());
        totalSize += encryption.length;
        entries.add(encryption);
        OType[] keyTypesValue = indexEngineData.getKeyTypes();
        byte[] keyTypesSize = new byte[4];
        OIntegerSerializer.INSTANCE.serializeNative(keyTypesValue.length, keyTypesSize, 0, new Object[0]);
        totalSize += keyTypesSize.length;
        entries.add(keyTypesSize);
        for (OType typeValue : keyTypesValue) {
            byte[] keyTypeName = OClusterBasedStorageConfiguration.serializeStringValue(typeValue.name());
            totalSize += keyTypeName.length;
            entries.add(keyTypeName);
        }
        Map<String, String> engineProperties = indexEngineData.getEngineProperties();
        byte[] enginePropertiesSize = new byte[4];
        totalSize += enginePropertiesSize.length;
        entries.add(enginePropertiesSize);
        if (engineProperties != null) {
            OIntegerSerializer.INSTANCE.serializeNative(engineProperties.size(), enginePropertiesSize, 0, new Object[0]);
            for (Map.Entry<String, String> engineProperty : engineProperties.entrySet()) {
                byte[] key = OClusterBasedStorageConfiguration.serializeStringValue(engineProperty.getKey());
                totalSize += key.length;
                entries.add(key);
                byte[] value = OClusterBasedStorageConfiguration.serializeStringValue(engineProperty.getValue());
                totalSize += value.length;
                entries.add(value);
            }
        }
        return OClusterBasedStorageConfiguration.mergeBinaryEntries(totalSize, entries);
    }

    private OStorageConfiguration.IndexEngineData deserializeIndexEngineProperty(String name, byte[] property) {
        int pos = 0;
        int version = OIntegerSerializer.INSTANCE.deserializeNative(property, pos);
        int apiVersion = OIntegerSerializer.INSTANCE.deserializeNative(property, pos += 4);
        byte valueSerializerId = property[pos += 4];
        byte keySerializerId = property[++pos];
        boolean isAutomatic = property[++pos] == 1;
        boolean isNullValueSupport = property[++pos] == 1;
        boolean isMultiValue = property[++pos] == 1;
        int keySize = OIntegerSerializer.INSTANCE.deserializeNative(property, ++pos);
        String algorithm = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos += 4);
        pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
        String indexType = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
        pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
        String encryption = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
        pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
        int keyTypesSize = OIntegerSerializer.INSTANCE.deserializeNative(property, pos);
        pos += 4;
        OType[] keyTypes = new OType[keyTypesSize];
        for (int i = 0; i < keyTypesSize; ++i) {
            String typeName = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
            pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
            keyTypes[i] = OType.valueOf(typeName);
        }
        HashMap<String, String> engineProperties = new HashMap<String, String>(8);
        int enginePropertiesSize = OIntegerSerializer.INSTANCE.deserializeNative(property, pos);
        pos += 4;
        for (int i = 0; i < enginePropertiesSize; ++i) {
            String key = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
            pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
            String value = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
            pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
            engineProperties.put(key, value);
        }
        return new OStorageConfiguration.IndexEngineData(name, algorithm, indexType, true, version, apiVersion, isMultiValue, valueSerializerId, keySerializerId, isAutomatic, keyTypes, isNullValueSupport, keySize, encryption, this.configuration.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY), engineProperties);
    }

    private static byte[] mergeBinaryEntries(int totalSize, List<byte[]> entries) {
        byte[] property = new byte[totalSize];
        int pos = 0;
        for (byte[] entry : entries) {
            System.arraycopy(entry, 0, property, pos, entry.length);
            pos += entry.length;
        }
        assert (pos == property.length);
        return property;
    }

    private static byte[] updateClusterConfig(OStorageClusterConfiguration cluster) {
        int totalSize = 0;
        ArrayList<byte[]> entries = new ArrayList<byte[]>(8);
        byte[] name = OClusterBasedStorageConfiguration.serializeStringValue(cluster.getName());
        totalSize += name.length;
        entries.add(name);
        OStoragePaginatedClusterConfiguration paginatedClusterConfiguration = (OStoragePaginatedClusterConfiguration)cluster;
        byte[] numericData = new byte[5];
        totalSize += numericData.length;
        entries.add(numericData);
        numericData[0] = paginatedClusterConfiguration.useWal ? (byte)1 : 0;
        OIntegerSerializer.INSTANCE.serializeNative(paginatedClusterConfiguration.getBinaryVersion(), numericData, 1, new Object[0]);
        byte[] encryption = OClusterBasedStorageConfiguration.serializeStringValue(paginatedClusterConfiguration.encryption);
        totalSize += encryption.length;
        entries.add(encryption);
        byte[] conflictStrategy = OClusterBasedStorageConfiguration.serializeStringValue(paginatedClusterConfiguration.conflictStrategy);
        totalSize += conflictStrategy.length;
        entries.add(conflictStrategy);
        byte[] status = OClusterBasedStorageConfiguration.serializeStringValue(paginatedClusterConfiguration.getStatus().name());
        totalSize += status.length;
        entries.add(status);
        byte[] compression = OClusterBasedStorageConfiguration.serializeStringValue(paginatedClusterConfiguration.compression);
        entries.add(compression);
        return OClusterBasedStorageConfiguration.mergeBinaryEntries(totalSize += compression.length, entries);
    }

    private OStorageClusterConfiguration deserializeStorageClusterConfig(int id, byte[] property) {
        int pos = 0;
        String name = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
        boolean useWal = property[pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos)] == 1;
        int binaryVersion = OIntegerSerializer.INSTANCE.deserializeNative(property, ++pos);
        String encryption = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos += 4);
        pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
        String conflictStrategy = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
        pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
        String status = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
        pos += OClusterBasedStorageConfiguration.getSerializedStringSize(property, pos);
        String compression = OClusterBasedStorageConfiguration.deserializeStringValue(property, pos);
        return new OStoragePaginatedClusterConfiguration(this, id, name, null, useWal, 0.0f, 0.0f, compression, encryption, this.configuration.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY), conflictStrategy, OStorageClusterConfiguration.STATUS.valueOf(status), binaryVersion);
    }

    private void dropProperty(String name) {
        try {
            boolean rollback = false;
            this.atomicOperationsManager.startAtomicOperation(COMPONENT_NAME, true);
            try {
                ORID identifiable = this.btree.remove(name);
                if (identifiable != null) {
                    this.cluster.deleteRecord(identifiable.getClusterPosition());
                }
            }
            catch (Exception e) {
                rollback = true;
                throw e;
            }
            finally {
                this.atomicOperationsManager.endAtomicOperation(rollback);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during drop of property " + name), e);
        }
        PausedNotificationsState pausedNotificationsState = this.pauseNotifications.get();
        if (this.updateListener != null) {
            if (!pausedNotificationsState.notificationsPaused) {
                this.updateListener.onUpdate(this);
                pausedNotificationsState.pendingChanges = 0L;
            } else {
                pausedNotificationsState.pendingChanges++;
            }
        }
    }

    private void updateStringProperty(String name, String value, boolean useCache) {
        if (useCache) {
            this.cache.put(name, value);
        }
        byte[] property = OClusterBasedStorageConfiguration.serializeStringValue(value);
        this.storeProperty(name, property);
    }

    private static byte[] serializeStringValue(String value) {
        byte[] property;
        if (value == null) {
            property = new byte[1];
        } else {
            byte[] rawString = value.getBytes(StandardCharsets.UTF_16);
            property = new byte[rawString.length + 1 + 4];
            property[0] = 1;
            OIntegerSerializer.INSTANCE.serializeNative(rawString.length, property, 1, new Object[0]);
            System.arraycopy(rawString, 0, property, 5, rawString.length);
        }
        return property;
    }

    private static String deserializeStringValue(byte[] raw, int start) {
        if (raw[start] == 0) {
            return null;
        }
        int stringSize = OIntegerSerializer.INSTANCE.deserializeNative(raw, start + 1);
        return new String(raw, start + 5, stringSize, StandardCharsets.UTF_16);
    }

    private static int getSerializedStringSize(byte[] raw, int start) {
        if (raw[start] == 0) {
            return 1;
        }
        return OIntegerSerializer.INSTANCE.deserializeNative(raw, start + 1) + 5;
    }

    private void updateIntProperty(String name, int value) {
        this.cache.put(name, value);
        byte[] property = new byte[4];
        OIntegerSerializer.INSTANCE.serializeNative(value, property, 0, new Object[0]);
        this.storeProperty(name, property);
    }

    private void storeProperty(String name, byte[] property) {
        try {
            boolean rollback = false;
            this.atomicOperationsManager.startAtomicOperation(COMPONENT_NAME, true);
            try {
                ORID identity = this.btree.get(name);
                if (identity == null) {
                    OPhysicalPosition position = this.cluster.createRecord(property, 0, (byte)0, null);
                    identity = new ORecordId(0, position.clusterPosition);
                    this.btree.put(name, identity);
                } else {
                    this.cluster.updateRecord(identity.getClusterPosition(), property, -1, (byte)0);
                }
            }
            catch (Exception e) {
                rollback = true;
                throw e;
            }
            finally {
                this.atomicOperationsManager.endAtomicOperation(rollback);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during update of configuration property " + name), e);
        }
        PausedNotificationsState pausedNotificationsState = this.pauseNotifications.get();
        if (this.updateListener != null) {
            if (!pausedNotificationsState.notificationsPaused) {
                pausedNotificationsState.pendingChanges = 0L;
                this.updateListener.onUpdate(this);
            } else {
                pausedNotificationsState.pendingChanges++;
            }
        }
    }

    private byte[] readProperty(String name) {
        try {
            ORID rid = this.btree.get(name);
            if (rid == null) {
                return null;
            }
            ORawBuffer buffer = this.cluster.readRecord(rid.getClusterPosition(), false);
            return buffer.buffer;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of configuration property " + name), e);
        }
    }

    private boolean containsProperty(String name) {
        return this.btree.get(name) != null;
    }

    private String readStringProperty(String name) {
        return (String)this.cache.get(name);
    }

    private int readIntProperty(String name, boolean useCache) {
        if (useCache) {
            Object cachedValue = this.cache.get(name);
            return (Integer)cachedValue;
        }
        byte[] property = this.readProperty(name);
        if (property == null) {
            throw new IllegalStateException("Property " + name + " is absent");
        }
        if (property.length < 4) {
            throw new IllegalStateException("Invalid length of property " + name + " len = " + property.length);
        }
        return OIntegerSerializer.INSTANCE.deserializeNative(property, 0);
    }

    private void preloadIntProperties() {
        for (String name : INT_PROPERTIES) {
            byte[] property = this.readProperty(name);
            if (property == null) continue;
            this.cache.put(name, OIntegerSerializer.INSTANCE.deserializeNative(property, 0));
        }
    }

    private void preloadStringProperties() {
        for (String name : STRING_PROPERTIES) {
            byte[] property = this.readProperty(name);
            if (property == null) continue;
            this.cache.put(name, OClusterBasedStorageConfiguration.deserializeStringValue(property, 0));
        }
    }

    private void init() {
        this.updateVersion();
        this.updateBinaryFormatVersion();
        this.setCharset("UTF-8");
        this.setDateFormat("yyyy-MM-dd");
        this.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        this.setLocaleLanguage(Locale.getDefault().getLanguage());
        this.setLocaleCountry(Locale.getDefault().getCountry());
        this.setTimeZone(TimeZone.getDefault());
        this.setPageSize(-1);
        this.setFreeListBoundary(-1);
        this.setMaxKeySize(-1);
        if (!this.configuration.getContextKeys().contains(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS.getKey())) {
            this.configuration.setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS.getValueAsInteger());
        }
        this.autoInitClusters();
        this.updateMinimumClusters();
        this.setRecordSerializerVersion(0);
    }

    private void copy(OStorageConfiguration storageConfiguration) {
        this.updateVersion(storageConfiguration.getVersion());
        this.updateBinaryFormatVersion(storageConfiguration.getBinaryFormatVersion());
        this.setCharset(storageConfiguration.getCharset());
        this.setSchemaRecordId(storageConfiguration.getSchemaRecordId());
        this.setIndexMgrRecordId(storageConfiguration.getIndexMgrRecordId());
        TimeZone timeZone = storageConfiguration.getTimeZone();
        assert (timeZone != null);
        this.setTimeZone(timeZone);
        this.setDateFormat(storageConfiguration.getDateFormat());
        this.setDateTimeFormat(storageConfiguration.getDateTimeFormat());
        this.configuration = storageConfiguration.getContextConfiguration();
        this.setMinimumClusters(storageConfiguration.getMinimumClusters());
        this.setLocaleCountry(storageConfiguration.getLocaleCountry());
        this.setLocaleLanguage(storageConfiguration.getLocaleLanguage());
        List<OStorageEntryConfiguration> properties = storageConfiguration.getProperties();
        for (OStorageEntryConfiguration oStorageEntryConfiguration : properties) {
            this.setProperty(oStorageEntryConfiguration.name, oStorageEntryConfiguration.value);
        }
        this.setClusterSelection(storageConfiguration.getClusterSelection());
        this.setConflictStrategy(storageConfiguration.getConflictStrategy());
        this.setValidation(storageConfiguration.isValidationEnabled());
        Set<String> indexEngines = storageConfiguration.indexEngines();
        for (String engine : indexEngines) {
            this.addIndexEngine(engine, storageConfiguration.getIndexEngine(engine));
        }
        this.setRecordSerializer(storageConfiguration.getRecordSerializer());
        this.setRecordSerializerVersion(storageConfiguration.getRecordSerializerVersion());
        List<OStorageClusterConfiguration> list = storageConfiguration.getClusters();
        for (OStorageClusterConfiguration cluster : list) {
            if (cluster == null) continue;
            this.updateCluster(cluster);
        }
        this.setCreationVersion(storageConfiguration.getCreatedAtVersion());
        this.setPageSize(storageConfiguration.getPageSize());
        this.setFreeListBoundary(storageConfiguration.getFreeListBoundary());
        this.setMaxKeySize(storageConfiguration.getMaxKeySize());
    }

    private void autoInitClusters() {
        if (this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS) == 0) {
            int cpus = Runtime.getRuntime().availableProcessors();
            this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)(cpus > 64 ? 64 : cpus));
        }
    }

    private static final class PausedNotificationsState {
        private boolean notificationsPaused;
        private long pendingChanges;

        private PausedNotificationsState() {
        }
    }
}

