/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm.writequeue;

import com.orientechnologies.orient.core.storage.cache.chm.writequeue.Node;
import java.util.concurrent.atomic.AtomicReference;

public final class MPSCLinkedQueue<E> {
    private final AtomicReference<Node<E>> head = new AtomicReference();
    private final AtomicReference<Node<E>> tail = new AtomicReference();

    public MPSCLinkedQueue() {
        Node<Object> dummyNode = new Node<Object>(null);
        this.head.set(dummyNode);
        this.tail.set(dummyNode);
    }

    public void offer(E item) {
        Node<E> newNode = new Node<E>(item);
        Node<E> prev = this.tail.getAndSet(newNode);
        prev.lazySetNext(newNode);
    }

    public E poll() {
        Node<E> head = this.head.get();
        Node<E> next = head.getNext();
        if (next != null) {
            this.head.lazySet(next);
            return next.getItem();
        }
        Node<E> tail = this.tail.get();
        if (head == tail) {
            return null;
        }
        while ((next = head.getNext()) == null) {
            Thread.yield();
        }
        this.head.lazySet(next);
        return next.getItem();
    }

    public boolean isEmpty() {
        return this.tail.get() == this.head.get();
    }
}

