/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm;

public final class PageKey {
    private final long fileId;
    private final int pageIndex;
    private int hash;

    PageKey(long fileId, int pageIndex) {
        this.fileId = fileId;
        this.pageIndex = pageIndex;
    }

    public long getFileId() {
        return this.fileId;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageKey pageKey = (PageKey)o;
        if (this.fileId != pageKey.fileId) {
            return false;
        }
        return this.pageIndex == pageKey.pageIndex;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = PageKey.hashCode(this.fileId, this.pageIndex);
        return this.hash;
    }

    public String toString() {
        return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
    }

    public static int hashCode(long fileId, int pageIndex) {
        int result = (int)(fileId ^ fileId >>> 32);
        result = 31 * result + pageIndex;
        return result;
    }
}

