/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.EmptyStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OForEachBlock;
import com.orientechnologies.orient.core.sql.parser.OIfStatement;
import com.orientechnologies.orient.core.sql.parser.OReturnStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhileBlock;
import java.util.List;

public class WhileStep
extends AbstractExecutionStep {
    private final OBooleanExpression condition;
    private final List<OStatement> statements;
    private OExecutionStepInternal finalResult = null;

    public WhileStep(OBooleanExpression condition, List<OStatement> statements, OCommandContext ctx, boolean enableProfiling) {
        super(ctx, enableProfiling);
        this.condition = condition;
        this.statements = statements;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.prev.ifPresent(x -> x.syncPull(ctx, nRecords));
        if (this.finalResult != null) {
            return this.finalResult.syncPull(ctx, nRecords);
        }
        while (this.condition.evaluate(new OResultInternal(), ctx)) {
            if (OExecutionThreadLocal.isInterruptCurrentOperation()) {
                throw new OCommandInterruptedException("The command has been interrupted");
            }
            OScriptExecutionPlan plan = this.initPlan(ctx);
            OExecutionStepInternal result = plan.executeFull();
            if (result == null) continue;
            this.finalResult = result;
            return result.syncPull(ctx, nRecords);
        }
        this.finalResult = new EmptyStep(ctx, false);
        return this.finalResult.syncPull(ctx, nRecords);
    }

    public OScriptExecutionPlan initPlan(OCommandContext ctx) {
        OBasicCommandContext subCtx1 = new OBasicCommandContext();
        subCtx1.setParent(ctx);
        OScriptExecutionPlan plan = new OScriptExecutionPlan(subCtx1);
        for (OStatement stm : this.statements) {
            if (stm.originalStatement == null) {
                stm.originalStatement = stm.toString();
            }
            OInternalExecutionPlan subPlan = stm.originalStatement.contains("?") ? stm.createExecutionPlanNoCache(subCtx1, this.profilingEnabled) : stm.createExecutionPlan(subCtx1, this.profilingEnabled);
            plan.chain(subPlan, this.profilingEnabled);
        }
        return plan;
    }

    public boolean containsReturn() {
        for (OStatement stm : this.statements) {
            if (stm instanceof OReturnStatement) {
                return true;
            }
            if (stm instanceof OForEachBlock && ((OForEachBlock)stm).containsReturn()) {
                return true;
            }
            if (stm instanceof OIfStatement && ((OIfStatement)stm).containsReturn()) {
                return true;
            }
            if (!(stm instanceof OWhileBlock) || !((OWhileBlock)stm).containsReturn()) continue;
            return true;
        }
        return false;
    }
}

