/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OSleepStatement
extends OSimpleExecStatement {
    protected OInteger millis;

    public OSleepStatement(int id) {
        super(id);
    }

    public OSleepStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        OInternalResultSet result = new OInternalResultSet();
        OResultInternal item = new OResultInternal();
        item.setProperty("operation", "sleep");
        try {
            Thread.sleep(this.millis.getValue().intValue());
            item.setProperty("result", "OK");
            item.setProperty("millis", this.millis.getValue().intValue());
        }
        catch (InterruptedException e) {
            item.setProperty("result", "failure");
            item.setProperty("errorType", e.getClass().getSimpleName());
            item.setProperty("errorMessage", e.getMessage());
        }
        result.add(item);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("SLEEP ");
        this.millis.toString(params, builder);
    }

    @Override
    public OSleepStatement copy() {
        OSleepStatement result = new OSleepStatement(-1);
        result.millis = this.millis == null ? null : this.millis.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSleepStatement that = (OSleepStatement)o;
        return !(this.millis != null ? !this.millis.equals(that.millis) : that.millis != null);
    }

    public int hashCode() {
        return this.millis != null ? this.millis.hashCode() : 0;
    }
}

