/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.parser.OFetchPlan;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OGroupBy;
import com.orientechnologies.orient.core.sql.parser.OLetClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OSkip;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUnwind;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.HashMap;
import java.util.Map;

public class OSelectStatement
extends OStatement {
    protected OFromClause target;
    protected OProjection projection;
    protected OWhereClause whereClause;
    protected OGroupBy groupBy;
    protected OOrderBy orderBy;
    protected OUnwind unwind;
    protected OSkip skip;
    protected OLimit limit;
    protected OStorage.LOCKING_STRATEGY lockRecord = null;
    protected OFetchPlan fetchPlan;
    protected OLetClause letClause;
    protected OTimeout timeout;
    protected Boolean parallel;
    protected Boolean noCache;

    public OSelectStatement(int id) {
        super(id);
    }

    public OSelectStatement(OrientSql p, int id) {
        super(p, id);
    }

    public OProjection getProjection() {
        return this.projection;
    }

    public void setProjection(OProjection projection) {
        this.projection = projection;
    }

    public OFromClause getTarget() {
        return this.target;
    }

    public void setTarget(OFromClause target) {
        this.target = target;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(OWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public OGroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(OGroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public OOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public OSkip getSkip() {
        return this.skip;
    }

    public void setSkip(OSkip skip) {
        this.skip = skip;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public void setLimit(OLimit limit) {
        this.limit = limit;
    }

    public OStorage.LOCKING_STRATEGY getLockRecord() {
        return this.lockRecord;
    }

    public void setLockRecord(OStorage.LOCKING_STRATEGY lockRecord) {
        this.lockRecord = lockRecord;
    }

    public OFetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(OFetchPlan fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    public OLetClause getLetClause() {
        return this.letClause;
    }

    public void setLetClause(OLetClause letClause) {
        this.letClause = letClause;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("SELECT");
        if (this.projection != null) {
            builder.append(" ");
            this.projection.toString(params, builder);
        }
        if (this.target != null) {
            builder.append(" FROM ");
            this.target.toString(params, builder);
        }
        if (this.letClause != null) {
            builder.append(" ");
            this.letClause.toString(params, builder);
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.groupBy != null) {
            builder.append(" ");
            this.groupBy.toString(params, builder);
        }
        if (this.orderBy != null) {
            builder.append(" ");
            this.orderBy.toString(params, builder);
        }
        if (this.unwind != null) {
            builder.append(" ");
            this.unwind.toString(params, builder);
        }
        if (this.skip != null) {
            this.skip.toString(params, builder);
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (this.lockRecord != null) {
            builder.append(" LOCK ");
            switch (this.lockRecord) {
                case DEFAULT: {
                    builder.append("DEFAULT");
                    break;
                }
                case EXCLUSIVE_LOCK: {
                    builder.append("RECORD");
                    break;
                }
                case SHARED_LOCK: {
                    builder.append("SHARED");
                    break;
                }
                case NONE: {
                    builder.append("NONE");
                }
            }
        }
        if (this.fetchPlan != null) {
            builder.append(" ");
            this.fetchPlan.toString(params, builder);
        }
        if (this.timeout != null) {
            this.timeout.toString(params, builder);
        }
        if (Boolean.TRUE.equals(this.parallel)) {
            builder.append(" PARALLEL");
        }
        if (Boolean.TRUE.equals(this.noCache)) {
            builder.append(" NOCACHE");
        }
    }

    @Override
    public void validate() throws OCommandSQLParsingException {
        if (this.projection != null) {
            this.projection.validate();
            if (this.projection.isExpand() && this.groupBy != null) {
                throw new OCommandSQLParsingException("expand() cannot be used together with GROUP BY");
            }
        }
    }

    @Override
    public boolean executinPlanCanBeCached() {
        if (this.originalStatement == null) {
            this.setOriginalStatement(this.toString());
        }
        if (this.target != null && !this.target.isCacheable()) {
            return false;
        }
        if (this.letClause != null && !this.letClause.isCacheable()) {
            return false;
        }
        if (this.projection != null && !this.projection.isCacheable()) {
            return false;
        }
        return this.whereClause == null || this.whereClause.isCacheable();
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : this.createExecutionPlanNoCache(ctx, false);
        OLocalResultSet result = new OLocalResultSet(executionPlan);
        return result;
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : this.createExecutionPlanNoCache(ctx, false);
        OLocalResultSet result = new OLocalResultSet(executionPlan);
        return result;
    }

    @Override
    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(this);
        OInternalExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling, true);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public OInternalExecutionPlan createExecutionPlanNoCache(OCommandContext ctx, boolean enableProfiling) {
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(this);
        OInternalExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling, false);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public OSelectStatement copy() {
        OSelectStatement result = null;
        try {
            result = (OSelectStatement)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.originalStatement = this.originalStatement;
        result.target = this.target == null ? null : this.target.copy();
        result.projection = this.projection == null ? null : this.projection.copy();
        result.whereClause = this.whereClause == null ? null : this.whereClause.copy();
        result.groupBy = this.groupBy == null ? null : this.groupBy.copy();
        result.orderBy = this.orderBy == null ? null : this.orderBy.copy();
        result.unwind = this.unwind == null ? null : this.unwind.copy();
        result.skip = this.skip == null ? null : this.skip.copy();
        result.limit = this.limit == null ? null : this.limit.copy();
        result.lockRecord = this.lockRecord;
        result.fetchPlan = this.fetchPlan == null ? null : this.fetchPlan.copy();
        result.letClause = this.letClause == null ? null : this.letClause.copy();
        result.timeout = this.timeout == null ? null : this.timeout.copy();
        result.parallel = this.parallel;
        result.noCache = this.noCache;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSelectStatement that = (OSelectStatement)o;
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.projection != null ? !this.projection.equals(that.projection) : that.projection != null) {
            return false;
        }
        if (this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null) {
            return false;
        }
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.unwind != null ? !this.unwind.equals(that.unwind) : that.unwind != null) {
            return false;
        }
        if (this.skip != null ? !this.skip.equals(that.skip) : that.skip != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.lockRecord != that.lockRecord) {
            return false;
        }
        if (this.fetchPlan != null ? !this.fetchPlan.equals(that.fetchPlan) : that.fetchPlan != null) {
            return false;
        }
        if (this.letClause != null ? !this.letClause.equals(that.letClause) : that.letClause != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) {
            return false;
        }
        if (this.parallel != null ? !this.parallel.equals(that.parallel) : that.parallel != null) {
            return false;
        }
        return !(this.noCache != null ? !this.noCache.equals(that.noCache) : that.noCache != null);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.projection != null ? this.projection.hashCode() : 0);
        result = 31 * result + (this.whereClause != null ? this.whereClause.hashCode() : 0);
        result = 31 * result + (this.groupBy != null ? this.groupBy.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.unwind != null ? this.unwind.hashCode() : 0);
        result = 31 * result + (this.skip != null ? this.skip.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.lockRecord != null ? this.lockRecord.hashCode() : 0);
        result = 31 * result + (this.fetchPlan != null ? this.fetchPlan.hashCode() : 0);
        result = 31 * result + (this.letClause != null ? this.letClause.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.parallel != null ? this.parallel.hashCode() : 0);
        result = 31 * result + (this.noCache != null ? this.noCache.hashCode() : 0);
        return result;
    }

    @Override
    public boolean refersToParent() {
        if (this.projection != null && this.projection.refersToParent()) {
            return true;
        }
        if (this.target != null && this.target.refersToParent()) {
            return true;
        }
        if (this.whereClause != null && this.whereClause.refersToParent()) {
            return true;
        }
        if (this.groupBy != null && this.groupBy.refersToParent()) {
            return true;
        }
        if (this.orderBy != null && this.orderBy.refersToParent()) {
            return true;
        }
        return this.letClause != null && this.letClause.refersToParent();
    }

    public OUnwind getUnwind() {
        return this.unwind;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    public void setUnwind(OUnwind unwind) {
        this.unwind = unwind;
    }

    public void setTimeout(OTimeout timeout) {
        this.timeout = timeout;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public void setNoCache(Boolean noCache) {
        this.noCache = noCache;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = (OResultInternal)super.serialize();
        if (this.target != null) {
            result.setProperty("target", this.target.serialize());
        }
        if (this.projection != null) {
            result.setProperty("projection", this.projection.serialize());
        }
        if (this.whereClause != null) {
            result.setProperty("whereClause", this.whereClause.serialize());
        }
        if (this.groupBy != null) {
            result.setProperty("groupBy", this.groupBy.serialize());
        }
        if (this.orderBy != null) {
            result.setProperty("orderBy", this.orderBy.serialize());
        }
        if (this.unwind != null) {
            result.setProperty("unwind", this.unwind.serialize());
        }
        if (this.skip != null) {
            result.setProperty("skip", this.skip.serialize());
        }
        if (this.limit != null) {
            result.setProperty("limit", this.limit.serialize());
        }
        if (this.lockRecord != null) {
            result.setProperty("lockRecord", this.lockRecord.toString());
        }
        if (this.fetchPlan != null) {
            result.setProperty("fetchPlan", this.fetchPlan.serialize());
        }
        if (this.letClause != null) {
            result.setProperty("letClause", this.letClause.serialize());
        }
        if (this.timeout != null) {
            result.setProperty("timeout", this.timeout.serialize());
        }
        result.setProperty("parallel", this.parallel);
        result.setProperty("noCache", this.noCache);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("target") != null) {
            this.target = new OFromClause(-1);
            this.target.deserialize((OResult)fromResult.getProperty("target"));
        }
        if (fromResult.getProperty("projection") != null) {
            this.projection = new OProjection(-1);
            this.projection.deserialize((OResult)fromResult.getProperty("projection"));
        }
        if (fromResult.getProperty("whereClause") != null) {
            this.whereClause = new OWhereClause(-1);
            this.whereClause.deserialize((OResult)fromResult.getProperty("whereClause"));
        }
        if (fromResult.getProperty("groupBy") != null) {
            this.groupBy = new OGroupBy(-1);
            this.groupBy.deserialize((OResult)fromResult.getProperty("groupBy"));
        }
        if (fromResult.getProperty("orderBy") != null) {
            this.orderBy = new OOrderBy(-1);
            this.orderBy.deserialize((OResult)fromResult.getProperty("orderBy"));
        }
        if (fromResult.getProperty("unwind") != null) {
            this.unwind = new OUnwind(-1);
            this.unwind.deserialize((OResult)fromResult.getProperty("unwind"));
        }
        if (fromResult.getProperty("skip") != null) {
            this.skip = new OSkip(-1);
            this.skip.deserialize((OResult)fromResult.getProperty("skip"));
        }
        if (fromResult.getProperty("limit") != null) {
            this.limit = new OLimit(-1);
            this.limit.deserialize((OResult)fromResult.getProperty("limit"));
        }
        if (fromResult.getProperty("lockRecord") != null) {
            this.lockRecord = OStorage.LOCKING_STRATEGY.valueOf((String)fromResult.getProperty("lockRecord"));
        }
        if (fromResult.getProperty("fetchPlan") != null) {
            this.fetchPlan = new OFetchPlan(-1);
            this.fetchPlan.deserialize((OResult)fromResult.getProperty("fetchPlan"));
        }
        if (fromResult.getProperty("letClause") != null) {
            this.letClause = new OLetClause(-1);
            this.letClause.deserialize((OResult)fromResult.getProperty("letClause"));
        }
        if (fromResult.getProperty("timeout") != null) {
            this.timeout = new OTimeout(-1);
            this.timeout.deserialize((OResult)fromResult.getProperty("timeout"));
        }
        this.parallel = (Boolean)fromResult.getProperty("parallel");
        this.noCache = (Boolean)fromResult.getProperty("noCache");
    }
}

