/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIndexName;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class ORebuildIndexStatement
extends OSimpleExecStatement {
    protected boolean all = false;
    protected OIndexName name;

    public ORebuildIndexStatement(int id) {
        super(id);
    }

    public ORebuildIndexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "rebuild index");
        ODatabaseDocumentInternal database = ORebuildIndexStatement.getDatabase();
        if (this.all) {
            long totalIndexed = 0L;
            for (OIndex<?> idx : database.getMetadata().getIndexManager().getIndexes()) {
                if (!idx.isAutomatic()) continue;
                totalIndexed += idx.rebuild();
            }
            result.setProperty("totalIndexed", totalIndexed);
        } else {
            OIndex<?> idx = database.getMetadata().getIndexManager().getIndex(this.name.getValue());
            if (idx == null) {
                throw new OCommandExecutionException("Index '" + this.name + "' not found");
            }
            if (!idx.isAutomatic()) {
                throw new OCommandExecutionException("Cannot rebuild index '" + this.name + "' because it's manual and there aren't indications of what to index");
            }
            long val = idx.rebuild();
            result.setProperty("totalIndexed", val);
        }
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("REBUILD INDEX ");
        if (this.all) {
            builder.append("*");
        } else {
            this.name.toString(params, builder);
        }
    }

    @Override
    public ORebuildIndexStatement copy() {
        ORebuildIndexStatement result = new ORebuildIndexStatement(-1);
        result.all = this.all;
        result.name = this.name == null ? null : this.name.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ORebuildIndexStatement that = (ORebuildIndexStatement)o;
        if (this.all != that.all) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.all ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

